/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.ui.dashboard;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.vaadin.data.Property;
import com.vaadin.server.ClientConnector;
import com.vaadin.server.Page;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.VerticalLayout;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.opennms.features.vaadin.components.graph.GraphContainer;
import org.opennms.features.vaadin.surveillanceviews.service.SurveillanceViewService;
import org.opennms.features.vaadin.surveillanceviews.ui.dashboard.SurveillanceViewDetail;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewGraphComponent
extends VerticalLayout
implements SurveillanceViewDetail,
Page.BrowserWindowResizeListener {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewGraphComponent.class);
    private SurveillanceViewService m_surveillanceViewService;
    protected boolean m_enabled;
    private NativeSelect m_nodeSelect;
    private NativeSelect m_resourceSelect;
    private NativeSelect m_graphSelect;
    private VerticalLayout m_graphLayout;
    protected ListenableFuture<List<OnmsNode>> m_future;

    public SurveillanceViewGraphComponent(SurveillanceViewService surveillanceViewService, boolean enabled) {
        this.m_surveillanceViewService = surveillanceViewService;
        this.m_enabled = enabled;
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        horizontalLayout.setSpacing(false);
        horizontalLayout.setPrimaryStyleName("v-caption-surveillance-view");
        horizontalLayout.addComponent((Component)new Label("Resource Graphs"));
        this.addComponent((Component)horizontalLayout);
        this.m_nodeSelect = new NativeSelect();
        this.m_nodeSelect.setNullSelectionAllowed(false);
        this.m_nodeSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                Integer onmsNodeId = (Integer)SurveillanceViewGraphComponent.this.m_nodeSelect.getValue();
                SurveillanceViewGraphComponent.this.m_resourceSelect.removeAllItems();
                if (onmsNodeId != null) {
                    Map<OnmsResourceType, List<OnmsResource>> map = SurveillanceViewGraphComponent.this.getSurveillanceViewService().getResourceTypeMapForNodeId(onmsNodeId);
                    for (OnmsResourceType onmsResourceType : map.keySet()) {
                        for (OnmsResource onmsResource : map.get(onmsResourceType)) {
                            SurveillanceViewGraphComponent.this.m_resourceSelect.addItem((Object)onmsResource.getId());
                            SurveillanceViewGraphComponent.this.m_resourceSelect.setItemCaption((Object)onmsResource.getId(), onmsResourceType.getLabel() + ": " + onmsResource.getLabel());
                        }
                    }
                    Iterator i = SurveillanceViewGraphComponent.this.m_resourceSelect.getItemIds().iterator();
                    if (i.hasNext()) {
                        SurveillanceViewGraphComponent.this.m_resourceSelect.select(i.next());
                    }
                }
            }
        });
        this.m_resourceSelect = new NativeSelect();
        this.m_resourceSelect.setNullSelectionAllowed(false);
        this.m_resourceSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                String onmsResourceId = (String)SurveillanceViewGraphComponent.this.m_resourceSelect.getValue();
                SurveillanceViewGraphComponent.this.m_graphSelect.removeAllItems();
                if (onmsResourceId != null) {
                    Map<String, String> map = SurveillanceViewGraphComponent.this.getSurveillanceViewService().getGraphResultsForResourceId(onmsResourceId);
                    for (String string : map.keySet()) {
                        SurveillanceViewGraphComponent.this.m_graphSelect.addItem((Object)map.get(string));
                        SurveillanceViewGraphComponent.this.m_graphSelect.setItemCaption((Object)map.get(string), string);
                    }
                    Iterator i = SurveillanceViewGraphComponent.this.m_graphSelect.getItemIds().iterator();
                    if (i.hasNext()) {
                        SurveillanceViewGraphComponent.this.m_graphSelect.select(i.next());
                    }
                }
            }
        });
        this.m_graphSelect = new NativeSelect();
        this.m_graphSelect.setNullSelectionAllowed(false);
        this.m_graphSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                String graphName = (String)SurveillanceViewGraphComponent.this.m_graphSelect.getValue();
                String resourceId = (String)SurveillanceViewGraphComponent.this.m_resourceSelect.getValue();
                SurveillanceViewGraphComponent.this.replaceGraph(graphName, resourceId);
            }
        });
        this.m_nodeSelect.setSizeFull();
        this.m_resourceSelect.setSizeFull();
        this.m_graphSelect.setSizeFull();
        this.m_nodeSelect.addStyleName("surveillance-view");
        this.m_resourceSelect.addStyleName("surveillance-view");
        this.m_graphSelect.addStyleName("surveillance-view");
        this.m_graphLayout = new VerticalLayout();
        this.m_graphLayout.setSizeUndefined();
        this.m_graphLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        HorizontalLayout selectionBoxesLayout = new HorizontalLayout();
        selectionBoxesLayout.setSizeFull();
        selectionBoxesLayout.addComponent((Component)this.m_nodeSelect);
        selectionBoxesLayout.addComponent((Component)this.m_resourceSelect);
        selectionBoxesLayout.addComponent((Component)this.m_graphSelect);
        this.m_graphLayout.setId("graphLayout");
        this.addAttachListener(new ClientConnector.AttachListener(){

            public void attach(ClientConnector.AttachEvent attachEvent) {
                SurveillanceViewGraphComponent.this.getUI().getPage().addBrowserWindowResizeListener((Page.BrowserWindowResizeListener)SurveillanceViewGraphComponent.this);
            }
        });
        this.addDetachListener(new ClientConnector.DetachListener(){

            public void detach(ClientConnector.DetachEvent detachEvent) {
                SurveillanceViewGraphComponent.this.getUI().getPage().removeBrowserWindowResizeListener((Page.BrowserWindowResizeListener)SurveillanceViewGraphComponent.this);
            }
        });
        this.addComponent((Component)selectionBoxesLayout);
        this.addComponent((Component)this.m_graphLayout);
    }

    public void browserWindowResized(Page.BrowserWindowResizeEvent browserWindowResizeEvent) {
        String graphName = (String)this.m_graphSelect.getValue();
        String resourceId = (String)this.m_resourceSelect.getValue();
        if (graphName != null && resourceId != null) {
            this.replaceGraph(graphName, resourceId);
        }
    }

    private void replaceGraph(String graphName, String resourceId) {
        this.m_graphLayout.removeAllComponents();
        if (graphName != null && resourceId != null) {
            GraphContainer graph = new GraphContainer(graphName, resourceId);
            GregorianCalendar calendar = new GregorianCalendar();
            graph.setEnd(calendar.getTime());
            ((Calendar)calendar).add(11, -1);
            graph.setStart(calendar.getTime());
            graph.setWidthRatio(Double.valueOf(1.0));
            graph.setHeightRatio(Double.valueOf(0.2));
            this.m_graphLayout.addComponent((Component)graph);
        }
    }

    protected SurveillanceViewService getSurveillanceViewService() {
        return this.m_surveillanceViewService;
    }

    @Override
    public void refreshDetails(final Set<OnmsCategory> rowCategories, final Set<OnmsCategory> colCategories) {
        if (this.m_future != null && !this.m_future.isDone()) {
            return;
        }
        this.m_nodeSelect.setEnabled(false);
        this.m_resourceSelect.setEnabled(false);
        this.m_graphSelect.setEnabled(false);
        this.m_future = this.getSurveillanceViewService().getExecutorService().submit((Callable)new Callable<List<OnmsNode>>(){

            @Override
            public List<OnmsNode> call() throws Exception {
                return SurveillanceViewGraphComponent.this.getSurveillanceViewService().getNodesForCategories(rowCategories, colCategories);
            }
        });
        this.m_future.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    final List nodes = (List)SurveillanceViewGraphComponent.this.m_future.get();
                    SurveillanceViewGraphComponent.this.getUI().access(new Runnable(){

                        @Override
                        public void run() {
                            Iterator i;
                            Integer selectedNodeId = (Integer)SurveillanceViewGraphComponent.this.m_nodeSelect.getValue();
                            String selectedResourceId = (String)SurveillanceViewGraphComponent.this.m_resourceSelect.getValue();
                            String selectedGraph = (String)SurveillanceViewGraphComponent.this.m_graphSelect.getValue();
                            LOG.debug("Saved selection={} / {} / {}", new Object[]{selectedNodeId == null ? "null" : selectedNodeId, selectedResourceId == null ? "null" : selectedResourceId, selectedGraph});
                            SurveillanceViewGraphComponent.this.m_nodeSelect.removeAllItems();
                            if (nodes != null && !nodes.isEmpty()) {
                                for (OnmsNode node : nodes) {
                                    SurveillanceViewGraphComponent.this.m_nodeSelect.addItem((Object)node.getId());
                                    SurveillanceViewGraphComponent.this.m_nodeSelect.setItemCaption((Object)node.getId(), "Node: " + node.getLabel());
                                }
                            }
                            SurveillanceViewGraphComponent.this.m_nodeSelect.setEnabled(true);
                            SurveillanceViewGraphComponent.this.m_resourceSelect.setEnabled(true);
                            SurveillanceViewGraphComponent.this.m_graphSelect.setEnabled(true);
                            if (selectedNodeId != null) {
                                for (Integer onmsNodeId : SurveillanceViewGraphComponent.this.m_nodeSelect.getItemIds()) {
                                    if (!onmsNodeId.equals(selectedNodeId)) continue;
                                    SurveillanceViewGraphComponent.this.m_nodeSelect.select((Object)onmsNodeId);
                                    if (selectedResourceId != null) {
                                        for (String onmsResourceId : SurveillanceViewGraphComponent.this.m_resourceSelect.getItemIds()) {
                                            if (!onmsResourceId.equals(selectedResourceId)) continue;
                                            SurveillanceViewGraphComponent.this.m_resourceSelect.select((Object)onmsResourceId);
                                            if (selectedGraph == null) continue;
                                            SurveillanceViewGraphComponent.this.m_graphSelect.select((Object)selectedGraph);
                                        }
                                    }
                                    return;
                                }
                            }
                            if ((i = SurveillanceViewGraphComponent.this.m_nodeSelect.getItemIds().iterator()).hasNext()) {
                                SurveillanceViewGraphComponent.this.m_nodeSelect.select(i.next());
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    LOG.error("Interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.error("Exception in task", e.getCause());
                }
            }
        }, (Executor)MoreExecutors.sameThreadExecutor());
    }
}

