/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.config;

import java.io.File;
import javax.xml.bind.JAXB;
import org.opennms.features.vaadin.surveillanceviews.model.SurveillanceViewConfiguration;
import org.opennms.features.vaadin.surveillanceviews.model.View;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurveillanceViewProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SurveillanceViewProvider.class);
    private static SurveillanceViewProvider m_surveillanceViewProvider = new SurveillanceViewProvider();
    private SurveillanceViewConfiguration m_surveillanceViewConfiguration = null;
    private File m_cfgFile = new File("etc/surveillance-views.xml");

    private SurveillanceViewProvider() {
        this.load();
    }

    public static SurveillanceViewProvider getInstance() {
        return m_surveillanceViewProvider;
    }

    public synchronized void save() {
        if (this.m_surveillanceViewConfiguration == null) {
            this.load();
        }
        JAXB.marshal((Object)this.m_surveillanceViewConfiguration, (File)this.m_cfgFile);
    }

    public synchronized void load() {
        this.m_surveillanceViewConfiguration = !this.m_cfgFile.exists() ? new SurveillanceViewConfiguration() : (SurveillanceViewConfiguration)JAXB.unmarshal((File)this.m_cfgFile, SurveillanceViewConfiguration.class);
    }

    public synchronized boolean containsView(String name) {
        for (View view : this.m_surveillanceViewConfiguration.getViews()) {
            if (!view.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public synchronized View getView(String name) {
        for (View view : this.m_surveillanceViewConfiguration.getViews()) {
            if (!view.getName().equals(name)) continue;
            return view;
        }
        return null;
    }

    public synchronized void replaceView(View oldView, View newView) {
        View viewFound = null;
        for (View view : this.m_surveillanceViewConfiguration.getViews()) {
            if (!view.getName().equals(oldView.getName())) continue;
            viewFound = view;
            break;
        }
        if (viewFound != null) {
            int index = this.getSurveillanceViewConfiguration().getViews().indexOf(viewFound);
            this.getSurveillanceViewConfiguration().getViews().set(index, newView);
        }
    }

    public synchronized View getDefaultView() {
        return this.getView(this.m_surveillanceViewConfiguration.getDefaultView());
    }

    public SurveillanceViewConfiguration getSurveillanceViewConfiguration() {
        return this.m_surveillanceViewConfiguration;
    }

    public synchronized boolean containsView(View view) {
        return this.m_surveillanceViewConfiguration.getViews().contains(view);
    }

    public synchronized void addView(View view) {
        if (this.m_surveillanceViewConfiguration == null) {
            this.load();
        }
        this.m_surveillanceViewConfiguration.getViews().add(view);
        this.save();
    }

    public synchronized void removeView(View view) {
        if (this.m_surveillanceViewConfiguration == null) {
            this.load();
        }
        this.m_surveillanceViewConfiguration.getViews().remove(view);
        this.save();
    }
}

