/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.surveillanceviews.model;

import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.features.vaadin.surveillanceviews.model.ColumnDef;
import org.opennms.features.vaadin.surveillanceviews.model.RowDef;

@XmlRootElement
public class View {
    private List<RowDef> m_rows = new LinkedList<RowDef>();
    private List<ColumnDef> m_columns = new LinkedList<ColumnDef>();
    private String m_name = "untitled";
    private Integer m_refreshSeconds = 300;

    @XmlElement(name="row-def")
    @XmlElementWrapper(name="rows")
    public List<RowDef> getRows() {
        return this.m_rows;
    }

    @XmlElement(name="column-def")
    @XmlElementWrapper(name="columns")
    public List<ColumnDef> getColumns() {
        return this.m_columns;
    }

    @XmlAttribute(name="name", required=true)
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @XmlAttribute(name="refresh-seconds", required=false)
    public int getRefreshSeconds() {
        return this.m_refreshSeconds;
    }

    public void setRefreshSeconds(int refreshSeconds) {
        this.m_refreshSeconds = refreshSeconds;
    }

    public RowDef getRowDef(String label) {
        for (RowDef rowDef : this.getRows()) {
            if (!label.equals(rowDef.getLabel())) continue;
            return rowDef;
        }
        return null;
    }

    public ColumnDef getColumnDef(String label) {
        for (ColumnDef columnDef : this.getColumns()) {
            if (!label.equals(columnDef.getLabel())) continue;
            return columnDef;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        if (this.m_columns != null ? !this.m_columns.equals(view.m_columns) : view.m_columns != null) {
            return false;
        }
        if (this.m_name != null ? !this.m_name.equals(view.m_name) : view.m_name != null) {
            return false;
        }
        if (this.m_refreshSeconds != null ? !this.m_refreshSeconds.equals(view.m_refreshSeconds) : view.m_refreshSeconds != null) {
            return false;
        }
        return !(this.m_rows != null ? !this.m_rows.equals(view.m_rows) : view.m_rows != null);
    }

    public int hashCode() {
        int result = this.m_rows != null ? this.m_rows.hashCode() : 0;
        result = 31 * result + (this.m_columns != null ? this.m_columns.hashCode() : 0);
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_refreshSeconds != null ? this.m_refreshSeconds.hashCode() : 0);
        return result;
    }
}

