/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.google.common.base.Strings;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapConfiguration;

public class InvalidConfigurationWindow
extends Window {
    public InvalidConfigurationWindow(NodeMapConfiguration nodeMapConfiguration) {
        this.setModal(true);
        this.setResizable(false);
        this.setWidth(500.0f, Sizeable.Unit.PIXELS);
        this.setHeight(250.0f, Sizeable.Unit.PIXELS);
        this.setCaption("Configuration Error");
        Button btnClose = new Button("OK", new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                InvalidConfigurationWindow.this.close();
            }
        });
        String errorMessage = this.getErrorLabel(nodeMapConfiguration);
        Label label = new Label(errorMessage, ContentMode.HTML);
        VerticalLayout rootLayout = new VerticalLayout();
        rootLayout.setSpacing(true);
        rootLayout.setMargin(true);
        rootLayout.addComponent((Component)label);
        rootLayout.addComponent((Component)btnClose);
        rootLayout.setExpandRatio((Component)label, 1.0f);
        rootLayout.setComponentAlignment((Component)btnClose, Alignment.BOTTOM_RIGHT);
        this.setContent((Component)rootLayout);
        this.center();
    }

    public void open() {
        UI.getCurrent().addWindow((Window)this);
    }

    private String getErrorLabel(NodeMapConfiguration nodeMapConfiguration) {
        try {
            String errorTemplate = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/error-configuration.txt"), (Charset)StandardCharsets.UTF_8);
            String problems = "";
            if (Strings.isNullOrEmpty((String)nodeMapConfiguration.getTileServerUrl())) {
                problems = "<li>No <i>gwt.openlayers.url</i> property defined</li>";
            }
            if (Strings.isNullOrEmpty((String)nodeMapConfiguration.getTileLayerAttribution())) {
                problems = problems + "<li>No <i>gwt.openlayers.options.attribution</i> property defined</li>";
            }
            String errorMessage = errorTemplate.replace("{problems}", problems);
            return errorMessage;
        }
        catch (IOException e) {
            return "Error determining error message: " + e.getMessage();
        }
    }
}

