/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ComponentTracker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.JSNodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.OpenNMSEventManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.FilterUpdatedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.FilterUpdatedEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.FilteredMarkersUpdatedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.MarkersModelUpdatedEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.MarkersModelUpdatedEventHandler;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerFilter;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerProvider;

public class MarkerContainer
implements MarkerProvider,
FilterUpdatedEventHandler,
MarkersModelUpdatedEventHandler {
    List<JSNodeMarker> m_markers = new ArrayList<JSNodeMarker>();
    List<JSNodeMarker> m_filteredMarkers = new ArrayList<JSNodeMarker>();
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private final OpenNMSEventManager m_eventManager;
    private final MarkerFilter m_filter;
    private final ComponentTracker m_componentTracker;

    public MarkerContainer(MarkerFilter filter, OpenNMSEventManager eventManager, ComponentTracker componentTracker) {
        this.m_filter = filter;
        this.m_eventManager = eventManager;
        this.m_componentTracker = componentTracker;
    }

    public void onLoad() {
        this.m_eventManager.addHandler(FilterUpdatedEvent.TYPE, this);
        this.m_eventManager.addHandler(MarkersModelUpdatedEvent.TYPE, this);
        this.m_componentTracker.ready(this.getClass());
    }

    public void onUnload() {
        this.m_eventManager.removeHandler(FilterUpdatedEvent.TYPE, this);
        this.m_eventManager.removeHandler(MarkersModelUpdatedEvent.TYPE, this);
    }

    public int size() {
        return this.getMarkers().size();
    }

    public ListIterator<JSNodeMarker> listIterator() {
        return this.getMarkers().listIterator();
    }

    public List<JSNodeMarker> getDisabledMarkers() {
        ArrayList<JSNodeMarker> markers = new ArrayList<JSNodeMarker>();
        List<JSNodeMarker> existingMarkers = this.getMarkers();
        if (existingMarkers != null) {
            for (NodeMarker nodeMarker : existingMarkers) {
                JSNodeMarker m;
                if (!(nodeMarker instanceof JSNodeMarker) || this.m_filteredMarkers.contains(m = (JSNodeMarker)nodeMarker)) continue;
                markers.add(m);
            }
        }
        return Collections.unmodifiableList(markers);
    }

    public List<JSNodeMarker> getAllMarkers() {
        return Collections.unmodifiableList(this.m_markers);
    }

    @Override
    public List<JSNodeMarker> getMarkers() {
        return Collections.unmodifiableList(this.m_filteredMarkers);
    }

    public void setMarkers(List<JSNodeMarker> markers) {
        if (markers == null) {
            this.logger.info("MarkerContainer.setMarkers(): clearing master marker list in the marker container.");
            if (this.m_markers != null) {
                this.m_markers.clear();
            }
        } else {
            this.logger.info("MarkerContainer.setMarkers(): saving " + markers.size() + " markers to the master marker list in the marker container.");
            this.m_markers = markers;
        }
        this.m_eventManager.fireEvent(new MarkersModelUpdatedEvent());
        this.refresh();
    }

    public void refresh() {
        this.logger.info("MarkerContainer.refresh()");
        ArrayList<JSNodeMarker> markers = new ArrayList<JSNodeMarker>();
        List<JSNodeMarker> existingMarkers = this.getAllMarkers();
        if (existingMarkers != null) {
            for (JSNodeMarker marker : existingMarkers) {
                if (!this.m_filter.matches(marker)) continue;
                markers.add(marker);
            }
        }
        this.m_filteredMarkers = markers;
        this.logger.info("MarkerContainer.refresh(): out of " + this.getMarkers().size() + " markers, " + markers.size() + " matched the search filter.");
        this.m_eventManager.fireEvent(new FilteredMarkersUpdatedEvent());
    }

    @Override
    public void onFilterUpdatedEvent(FilterUpdatedEvent event) {
        this.logger.info("MarkerContainer.onFilterUpdatedEvent()");
        this.refresh();
    }

    @Override
    public void onMarkersModelUpdated(MarkersModelUpdatedEvent event) {
        this.logger.info("MarkerContainer.onMarkersModelUpdated()");
        this.refresh();
    }
}

