/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.geolocation.api.GeolocationInfo;
import org.opennms.features.geolocation.api.GeolocationQueryBuilder;
import org.opennms.features.geolocation.api.GeolocationService;
import org.opennms.features.geolocation.api.GeolocationSeverity;
import org.opennms.features.geolocation.api.NodeInfo;
import org.opennms.features.geolocation.api.StatusCalculationStrategy;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.vaadin.nodemaps.internal.GeoAssetProvider;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapConfiguration;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapsApplication;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.MapNode;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMapState;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.NodeIdSelectionRpc;
import org.opennms.netmgt.dao.api.NodeDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMapComponent
extends AbstractComponent
implements GeoAssetProvider {
    private static final long serialVersionUID = 3L;
    private static final Logger LOG = LoggerFactory.getLogger(NodeMapComponent.class);
    private NodeIdSelectionRpc m_rpc = new NodeIdSelectionRpc(){
        private static final long serialVersionUID = 3263343063196874423L;

        @Override
        public void setSelectedNodes(List<Integer> nodeIds) {
            ((NodeMapsApplication)UI.getCurrent()).setFocusedNodes(nodeIds);
        }

        @Override
        public void refresh() {
            ((NodeMapsApplication)UI.getCurrent()).refresh();
        }
    };
    private NodeDao m_nodeDao;
    private GeolocationService geolocationService;
    private Boolean m_aclsEnabled = false;
    private NodeMapConfiguration configuration;
    private Map<Integer, MapNode> m_activeNodes = new HashMap<Integer, MapNode>();

    public NodeMapComponent() {
        this.registerRpc(this.m_rpc);
        this.m_aclsEnabled = Boolean.valueOf(System.getProperty("org.opennms.web.aclsEnabled", "false"));
    }

    public void setGeolocationService(GeolocationService geolocationService) {
        this.geolocationService = geolocationService;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    @Override
    public Collection<VertexRef> getNodesWithCoordinates() {
        ArrayList<VertexRef> nodes = new ArrayList<VertexRef>();
        for (Map.Entry<Integer, MapNode> entry : this.m_activeNodes.entrySet()) {
            nodes.add((VertexRef)new AbstractVertex("nodes", entry.getKey().toString(), entry.getValue().getNodeLabel()));
        }
        return nodes;
    }

    public void refresh() {
        List locations = this.geolocationService.getLocations(new GeolocationQueryBuilder().withIncludeAcknowledgedAlarms(false).withStatusCalculationStrategy(StatusCalculationStrategy.Alarms).withSeverity(GeolocationSeverity.Normal).build());
        if (this.m_aclsEnabled.booleanValue()) {
            Map nodes = this.m_nodeDao.getAllLabelsById();
            locations = locations.stream().filter(l -> nodes.containsKey(l.getNodeInfo().getNodeId())).collect(Collectors.toList());
        }
        this.m_activeNodes = locations.stream().map(NodeMapComponent::createMapNode).collect(Collectors.toMap(l -> Integer.valueOf(l.getNodeId()), Function.identity()));
        this.showNodes(this.m_activeNodes);
    }

    public void setMaxClusterRadius(Integer radius) {
        this.getState().maxClusterRadius = radius;
    }

    public void setConfiguration(NodeMapConfiguration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
        this.getState().tileServerUrl = configuration.getTileServerUrl();
        this.getState().tileLayerOptions = configuration.getOptions();
    }

    public void setSearchString(String searchString) {
        LOG.debug("setSearchString(" + searchString + ")");
        this.getState().searchString = searchString;
    }

    public void setSelectedNodes(List<Integer> nodeIds) {
        LOG.debug("setSelectedNodes(" + nodeIds + ")");
        this.getState().nodeIds = nodeIds;
    }

    public void setGroupByState(boolean groupByState) {
        this.getState().groupByState = groupByState;
    }

    public void showNodes(Map<Integer, MapNode> nodeEntries) {
        LOG.info("Updating map node list: {} entries.", (Object)nodeEntries.size());
        ArrayList<MapNode> nodeEntryList = new ArrayList<MapNode>(nodeEntries.values());
        if (this.getState().nodes != null && nodeEntryList.containsAll(this.getState().nodes) && this.getState().nodes.containsAll(nodeEntryList)) {
            LOG.info("Skipping update. Map node list is unchanged.");
            return;
        }
        this.getState().nodes = new ArrayList<MapNode>(nodeEntries.values());
        LOG.info("Finished updating map node list.");
    }

    protected NodeMapState getState() {
        return (NodeMapState)super.getState();
    }

    protected NodeIdSelectionRpc getRpc() {
        return this.m_rpc;
    }

    private static MapNode createMapNode(GeolocationInfo geolocationInfo) {
        MapNode node = new MapNode();
        if (geolocationInfo.getCoordinates() != null) {
            node.setLatitude(geolocationInfo.getCoordinates().getLatitude());
            node.setLongitude(geolocationInfo.getCoordinates().getLongitude());
        }
        NodeInfo nodeInfo = geolocationInfo.getNodeInfo();
        node.setNodeId(String.valueOf(nodeInfo.getNodeId()));
        node.setNodeLabel(nodeInfo.getNodeLabel());
        node.setForeignSource(nodeInfo.getForeignSource());
        node.setForeignId(nodeInfo.getForeignId());
        node.setIpAddress(nodeInfo.getIpAddress());
        node.setDescription(nodeInfo.getDescription());
        node.setMaintcontract(nodeInfo.getMaintcontract());
        node.setCategories(new ArrayList<String>(nodeInfo.getCategories()));
        node.setSeverityLabel(geolocationInfo.getSeverityInfo().getLabel());
        node.setSeverity(String.valueOf(geolocationInfo.getSeverityInfo().getId()));
        node.setUnackedCount(geolocationInfo.getAlarmUnackedCount());
        return node;
    }
}

