/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client;

import com.google.gwt.core.client.Scheduler;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.OpenNMSEventManager;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.ApplicationInitializedEvent;

public class ComponentTracker {
    private final Logger LOG = Logger.getLogger(this.getClass().getName());
    private OpenNMSEventManager m_eventManager;
    private Set<String> m_expectedComponents = new HashSet<String>();

    public ComponentTracker(OpenNMSEventManager eventManager) {
        this.m_eventManager = eventManager;
    }

    public void track(Class<?> clazz) {
        this.LOG.warning("ComponentTracker: Watching for " + clazz.getName() + " initialization.");
        this.m_expectedComponents.add(clazz.getName());
    }

    public void ready(Class<?> clazz) {
        this.LOG.warning("ComponentTracker: Component " + clazz.getName() + " is ready.");
        this.m_expectedComponents.remove(clazz.getName());
        this.onReady();
    }

    private void onReady() {
        if (this.m_expectedComponents.size() == 0) {
            this.LOG.warning("ComponentTracker: All anticipated components are ready.  Firing ApplicationInitializedEvent.");
            Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                public void execute() {
                    ComponentTracker.this.m_eventManager.fireEvent(new ApplicationInitializedEvent());
                }
            });
        } else {
            this.LOG.warning("ComponentTracker: Waiting for " + this.m_expectedComponents.size() + " more components to initialize.");
            this.LOG.info("ComponentTracker: Components remaining: " + this.m_expectedComponents);
        }
    }
}

