/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client;

import java.util.ArrayList;
import java.util.List;

public enum AlarmSeverity {
    NORMAL(3, "Normal"),
    WARNING(4, "Warning"),
    MINOR(5, "Minor"),
    MAJOR(6, "Major"),
    CRITICAL(7, "Critical");

    private final int m_id;
    private final String m_label;

    private AlarmSeverity(int id, String label) {
        this.m_id = id;
        this.m_label = label;
    }

    public int getId() {
        return this.m_id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public boolean isLessThan(AlarmSeverity other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqual(AlarmSeverity other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(AlarmSeverity other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqual(AlarmSeverity other) {
        return this.compareTo(other) >= 0;
    }

    public static AlarmSeverity get(int id) {
        for (AlarmSeverity severity : AlarmSeverity.values()) {
            if (severity.getId() != id) continue;
            return severity;
        }
        return NORMAL;
    }

    public static AlarmSeverity get(String label) {
        for (AlarmSeverity severity : AlarmSeverity.values()) {
            if (!severity.getLabel().equalsIgnoreCase(label)) continue;
            return severity;
        }
        return NORMAL;
    }

    public static List<String> labels() {
        ArrayList<String> labels = new ArrayList<String>();
        for (AlarmSeverity severity : AlarmSeverity.values()) {
            labels.add(severity.getLabel());
        }
        return labels;
    }
}

