/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.Coordinates;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;

public class SimpleNodeMarker
implements NodeMarker {
    private Integer m_nodeId;
    private String m_foreignSource;
    private String m_foreignId;
    private String m_nodeLabel;
    private String m_description;
    private String m_ipAddress;
    private Integer m_severity;
    private String m_severityLabel;
    private Integer m_unackedCount;
    private String m_maintContract;
    private Coordinates m_coordinates;
    private List<String> m_categoryList = new ArrayList<String>();

    @Override
    public final Map<String, String> getProperties() {
        Coordinates coordinates;
        Integer unackedCount;
        Integer severity;
        HashMap<String, String> props = new HashMap<String, String>();
        Integer nodeId = this.getNodeId();
        if (nodeId != null) {
            props.put("nodeid", nodeId.toString());
        }
        if ((severity = this.getSeverity()) != null) {
            props.put("severity", severity.toString());
        }
        if ((unackedCount = this.getUnackedCount()) != null) {
            props.put("unackedcount", unackedCount.toString());
        }
        if ((coordinates = this.getCoordinates()) != null) {
            props.put("coordinates", coordinates.toString());
        }
        if (this.m_categoryList != null && this.m_categoryList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Iterator<String> i = this.getCategoryList().iterator();
            while (i.hasNext()) {
                sb.append(i.next());
                if (!i.hasNext()) continue;
                sb.append(",");
            }
            props.put("categories", sb.toString());
        }
        this.addIfExists(props, "foreignsource", this.getForeignSource());
        this.addIfExists(props, "foreignid", this.getForeignId());
        this.addIfExists(props, "nodelabel", this.getNodeLabel());
        this.addIfExists(props, "description", this.getDescription());
        this.addIfExists(props, "ipaddress", this.getIpAddress());
        this.addIfExists(props, "severitylabel", this.getSeverityLabel());
        this.addIfExists(props, "maintcontract", this.getMaintContract());
        return props;
    }

    private final void addIfExists(Map<String, String> props, String key, String value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    @Override
    public Integer getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(Integer nodeId) {
        this.m_nodeId = nodeId;
    }

    @Override
    public String getForeignSource() {
        return this.m_foreignSource;
    }

    public void setForeignSource(String foreignSource) {
        this.m_foreignSource = foreignSource;
    }

    @Override
    public String getForeignId() {
        return this.m_foreignId;
    }

    public void setForeignId(String foreignId) {
        this.m_foreignId = foreignId;
    }

    @Override
    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public void setNodeLabel(String nodeLabel) {
        this.m_nodeLabel = nodeLabel;
    }

    @Override
    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    @Override
    public String getIpAddress() {
        return this.m_ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.m_ipAddress = ipAddress;
    }

    @Override
    public Integer getSeverity() {
        return this.m_severity;
    }

    public void setSeverity(Integer severity) {
        this.m_severity = severity;
    }

    @Override
    public String getSeverityLabel() {
        return this.m_severityLabel;
    }

    public void setSeverityLabel(String severityLabel) {
        this.m_severityLabel = severityLabel;
    }

    @Override
    public Integer getUnackedCount() {
        return this.m_unackedCount;
    }

    public void setUnackedCount(Integer unackedCount) {
        this.m_unackedCount = unackedCount;
    }

    @Override
    public String getMaintContract() {
        return this.m_maintContract;
    }

    public void setMaintContract(String maintContract) {
        this.m_maintContract = maintContract;
    }

    @Override
    public Coordinates getCoordinates() {
        return this.m_coordinates;
    }

    public void setCoordinates(Coordinates coordinates) {
        this.m_coordinates = coordinates;
    }

    @Override
    public List<String> getCategoryList() {
        return Collections.unmodifiableList(new ArrayList<String>(this.m_categoryList));
    }

    public void setCategoryList(List<String> categoryList) {
        this.m_categoryList = new ArrayList<String>(categoryList);
    }

    public void addCategory(String category) {
        this.m_categoryList.add(category);
    }
}

