/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.vaadin.server.VaadinServlet;
import com.vaadin.ui.UI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.opennms.features.topology.api.Operation;
import org.opennms.features.topology.api.OperationContext;
import org.opennms.features.topology.api.geo.GeoAssetProvider;
import org.opennms.features.topology.api.topo.VertexRef;

public class NodeMapQueryLink
implements Operation {
    private static final Logger LOG = Logger.getLogger(NodeMapQueryLink.class.getName());
    private GeoAssetProvider m_geoAssetProvider;

    public void setGeoAssetProvider(GeoAssetProvider provider) {
        this.m_geoAssetProvider = provider;
    }

    public String getId() {
        return "NodeMapQueryLink";
    }

    public void execute(List<VertexRef> targets, OperationContext operationContext) {
        Collection availableNodes = this.m_geoAssetProvider.getNodesWithCoordinates();
        StringBuilder sb = new StringBuilder();
        sb.append(VaadinServlet.getCurrent().getServletContext().getContextPath());
        sb.append("/node-maps#search/nodeId%20in%20");
        ArrayList<String> nodeIds = new ArrayList<String>();
        for (VertexRef ref : targets) {
            if (!availableNodes.contains(ref)) continue;
            nodeIds.add(ref.getId());
        }
        Iterator i = nodeIds.iterator();
        while (i.hasNext()) {
            sb.append((String)i.next());
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        String redirectUrl = sb.toString();
        LOG.info("redirecting to: " + redirectUrl);
        UI ui = operationContext.getMainWindow();
        ui.getPage().getJavaScript().execute("window.location = '" + redirectUrl + "';");
    }

    public boolean display(List<VertexRef> targets, OperationContext operationContext) {
        return targets != null && targets.size() > 0 && this.hasCoordinates(targets);
    }

    public boolean enabled(List<VertexRef> targets, OperationContext operationContext) {
        return this.hasCoordinates(targets);
    }

    private boolean hasCoordinates(List<VertexRef> targets) {
        Collection availableNodes = this.m_geoAssetProvider.getNodesWithCoordinates();
        for (VertexRef ref : targets) {
            if (!availableNodes.contains(ref)) continue;
            return true;
        }
        return false;
    }
}

