/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.Option;

public class NodeMapConfiguration {
    private static final String URL_KEY = "gwt.openlayers.url";
    private static final String OPTIONS_KEY_PREFIX = "gwt.openlayers.options";

    public static String getTileServerUrl() {
        String url = System.getProperty(URL_KEY);
        return NodeMapConfiguration.sanitizeForVaadin(url);
    }

    public static List<Option> getTileLayerOptions() {
        Properties properties = System.getProperties();
        HashMap<String, String> options = new HashMap<String, String>();
        for (Object objectKey : properties.keySet()) {
            String key = (String)objectKey;
            if (!key.startsWith(OPTIONS_KEY_PREFIX)) continue;
            String optionsKey = key.substring(OPTIONS_KEY_PREFIX.length() + 1);
            String optionsValue = properties.getProperty(key);
            options.put(optionsKey, NodeMapConfiguration.sanitizeForVaadin(optionsValue));
        }
        ArrayList<Option> optionsList = new ArrayList<Option>();
        for (Map.Entry eachEntry : options.entrySet()) {
            optionsList.add(new Option((String)eachEntry.getKey(), (String)eachEntry.getValue()));
        }
        return optionsList;
    }

    private static String sanitizeForVaadin(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return input;
        }
        return input.replaceAll("\\$\\{", "{");
    }

    public static boolean isValid() {
        return !Strings.isNullOrEmpty((String)NodeMapConfiguration.getTileServerUrl()) && !Strings.isNullOrEmpty((String)NodeMapConfiguration.getTileLayerAttribution());
    }

    static String getTileLayerAttribution() {
        return System.getProperty("gwt.openlayers.options.attribution");
    }
}

