/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.UI;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapsApplication;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.MapNode;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMapState;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.NodeIdSelectionRpc;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeMapComponent
extends AbstractComponent {
    private static final long serialVersionUID = 3L;
    private static final Logger LOG = LoggerFactory.getLogger(NodeMapComponent.class);
    private NodeIdSelectionRpc m_rpc = new NodeIdSelectionRpc(){
        private static final long serialVersionUID = 3263343063196874423L;

        @Override
        public void setSelectedNodes(List<Integer> nodeIds) {
            ((NodeMapsApplication)UI.getCurrent()).setFocusedNodes(nodeIds);
        }

        @Override
        public void refresh() {
            ((NodeMapsApplication)UI.getCurrent()).refresh();
        }
    };

    public NodeMapComponent() {
        this.registerRpc(this.m_rpc);
    }

    protected NodeIdSelectionRpc getRpc() {
        return this.m_rpc;
    }

    public void setGroupByState(boolean groupByState) {
        this.getState().groupByState = groupByState;
    }

    public void showNodes(Map<Integer, NodeEntry> nodeEntries) {
        LOG.info("Updating map node list: {} entries.", (Object)nodeEntries.size());
        LinkedList<MapNode> nodes = new LinkedList<MapNode>();
        for (NodeEntry node : nodeEntries.values()) {
            nodes.add(node.createNode());
        }
        this.getState().nodes = nodes;
        LOG.info("Finished updating map node list.");
    }

    protected NodeMapState getState() {
        return (NodeMapState)super.getState();
    }

    public void setSearchString(String searchString) {
        LOG.debug("setSearchString(" + searchString + ")");
        this.getState().searchString = searchString;
    }

    public void setSelectedNodes(List<Integer> nodeIds) {
        LOG.debug("setSelectedNodes(" + nodeIds + ")");
        this.getState().nodeIds = nodeIds;
    }

    protected static final class NodeEntry {
        private Float m_longitude;
        private Float m_latitude;
        private Integer m_nodeId;
        private String m_nodeLabel;
        private String m_foreignSource;
        private String m_foreignId;
        private String m_description;
        private String m_maintcontract;
        private String m_ipAddress;
        private OnmsSeverity m_severity = OnmsSeverity.NORMAL;
        private List<String> m_categories = new ArrayList<String>();
        private int m_unackedCount = 0;

        NodeEntry(Integer nodeId, String nodeLabel, float longitude, float latitude) {
            this.m_nodeId = nodeId;
            this.m_nodeLabel = nodeLabel;
            this.m_longitude = Float.valueOf(longitude);
            this.m_latitude = Float.valueOf(latitude);
        }

        public NodeEntry(OnmsNode node) {
            OnmsAssetRecord assetRecord = node.getAssetRecord();
            if (assetRecord != null && assetRecord.getGeolocation() != null) {
                OnmsGeolocation geolocation = assetRecord.getGeolocation();
                this.m_longitude = geolocation.getLongitude();
                this.m_latitude = geolocation.getLatitude();
            }
            this.m_nodeId = node.getId();
            this.m_nodeLabel = node.getLabel();
            this.m_foreignSource = node.getForeignSource();
            this.m_foreignId = node.getForeignId();
            if (assetRecord != null) {
                this.m_maintcontract = assetRecord.getMaintcontract();
                this.m_description = assetRecord.getDescription();
            }
            if (node.getPrimaryInterface() != null) {
                this.m_ipAddress = InetAddressUtils.str((InetAddress)node.getPrimaryInterface().getIpAddress());
            }
            if (node.getCategories() != null && node.getCategories().size() > 0) {
                for (OnmsCategory category : node.getCategories()) {
                    this.m_categories.add(category.getName());
                }
            }
        }

        public Integer getNodeId() {
            return this.m_nodeId;
        }

        public String getNodeLabel() {
            return this.m_nodeLabel;
        }

        public void setSeverity(OnmsSeverity severity) {
            this.m_severity = severity;
        }

        public MapNode createNode() {
            MapNode node = new MapNode();
            node.setLatitude(this.m_latitude.floatValue());
            node.setLongitude(this.m_longitude.floatValue());
            node.setNodeId(String.valueOf(this.m_nodeId));
            node.setNodeLabel(this.m_nodeLabel);
            node.setForeignSource(this.m_foreignSource);
            node.setForeignId(this.m_foreignId);
            node.setIpAddress(this.m_ipAddress);
            node.setDescription(this.m_description);
            node.setMaintcontract(this.m_maintcontract);
            node.setSeverityLabel(this.m_severity.getLabel());
            node.setSeverity(String.valueOf(this.m_severity.getId()));
            node.setUnackedCount(this.m_unackedCount);
            node.setCategories(this.m_categories);
            return node;
        }

        public void setUnackedCount(int unackedCount) {
            this.m_unackedCount = unackedCount;
        }
    }
}

