/*
 Copyright (c) 2012, Smartrak, David Leaver
 Leaflet.markercluster is an open-source JavaScript library for Marker Clustering on leaflet powered maps.
 https://github.com/danzel/Leaflet.markercluster
*/
(function (window, undefined) {


/*
 * L.MarkerClusterGroup extends L.FeatureGroup by clustering the markers contained within
 */

L.MarkerClusterGroup = L.FeatureGroup.extend({

	options: {
		maxClusterRadius: 80, //A cluster will cover at most this many pixels from its center
		iconCreateFunction: null,

		spiderfyOnMaxZoom: true,
		showCoverageOnHover: true,
		zoomToBoundsOnClick: true,
		singleMarkerMode: false,

		disableClusteringAtZoom: null,

        // Setting this to false prevents the removal of any clusters outside of the viewpoint, which
        // is the default behaviour for performance reasons.
        removeOutsideVisibleBounds: true,

		//Whether to animate adding markers after adding the MarkerClusterGroup to the map
		// If you are adding individual markers set to true, if adding bulk markers leave false for massive performance gains.
		animateAddingMarkers: false,

		//Increase to increase the distance away that spiderfied markers appear from the center
		spiderfyDistanceMultiplier: 1,
		
		//options for being a US state
		inUs: false,
		stateID: null,
		stateData: null, 
		statePolygon: null,

		//Options to pass to the L.Polygon constructor
		polygonOptions: {}
	},

	initialize: function (options) {
		L.Util.setOptions(this, options);
		if (!this.options.iconCreateFunction) {
			this.options.iconCreateFunction = this._defaultIconCreateFunction;
		}
		
		
		L.FeatureGroup.prototype.initialize.call(this, []);

		this._inZoomAnimation = 0;
		this._needsClustering = [];
		this._needsRemoving = []; //Markers removed while we aren't on the map need to be kept track of
		//The bounds of the currently shown area (from _getExpandedVisibleBounds) Updated on zoom/move
		this._currentShownBounds = null;
		
		//constructs LatLng array used for state bounds
		if(this.options.inUs){
			var ncArray =  [  [ [ [ -75.753765, 35.199612 ], [ -75.745220, 35.203030 ], [ -75.734171, 35.204347 ], [ -75.718015, 35.209377 ], [ -75.708947, 35.213912 ], [ -75.698972, 35.221166 ], [ -75.694437, 35.222980 ], [ -75.687490, 35.231171 ], [ -75.684006, 35.232913 ], [ -75.681916, 35.232913 ], [ -75.675394, 35.228421 ], [ -75.664512, 35.227514 ], [ -75.640934, 35.233862 ], [ -75.630358, 35.238487 ], [ -75.615378, 35.248938 ], [ -75.599005, 35.256253 ], [ -75.598312, 35.261067 ], [ -75.597960, 35.266704 ], [ -75.596915, 35.269491 ], [ -75.585419, 35.266356 ], [ -75.581935, 35.263917 ], [ -75.561033, 35.266008 ], [ -75.535741, 35.272856 ], [ -75.529393, 35.288272 ], [ -75.523952, 35.318198 ], [ -75.518511, 35.336335 ], [ -75.512610, 35.362853 ], [ -75.506722, 35.387118 ], [ -75.500374, 35.424298 ], [ -75.494933, 35.454224 ], [ -75.487678, 35.485056 ], [ -75.488585, 35.497752 ], [ -75.489618, 35.508471 ], [ -75.487528, 35.525889 ], [ -75.482237, 35.538560 ], [ -75.478610, 35.553069 ], [ -75.478610, 35.599318 ], [ -75.481330, 35.622896 ], [ -75.487678, 35.648287 ], [ -75.498675, 35.666281 ], [ -75.507385, 35.680564 ], [ -75.515745, 35.721671 ], [ -75.515397, 35.730380 ], [ -75.533512, 35.773577 ], [ -75.528992, 35.776289 ], [ -75.522232, 35.774178 ], [ -75.502427, 35.742913 ], [ -75.496086, 35.728515 ], [ -75.479128, 35.678634 ], [ -75.458659, 35.596597 ], [ -75.460061, 35.581314 ], [ -75.462491, 35.553556 ], [ -75.471355, 35.479615 ], [ -75.486771, 35.391652 ], [ -75.502188, 35.320012 ], [ -75.525920, 35.233839 ], [ -75.533627, 35.225825 ], [ -75.544809, 35.228421 ], [ -75.560225, 35.232048 ], [ -75.580176, 35.231142 ], [ -75.610101, 35.227514 ], [ -75.635493, 35.220260 ], [ -75.672673, 35.208471 ], [ -75.728897, 35.190334 ], [ -75.749406, 35.185207 ], [ -75.757916, 35.183079 ], [ -75.769705, 35.180359 ], [ -75.789655, 35.172197 ], [ -75.840438, 35.151340 ], [ -75.912985, 35.119600 ], [ -75.944725, 35.105091 ], [ -75.963768, 35.092395 ], [ -75.982812, 35.081513 ], [ -76.001510, 35.067230 ], [ -76.013145, 35.061855 ], [ -76.014954, 35.065349 ], [ -76.013561, 35.068832 ], [ -76.000949, 35.084234 ], [ -75.991880, 35.092395 ], [ -75.989175, 35.100882 ], [ -75.990569, 35.108546 ], [ -75.989175, 35.115165 ], [ -75.983950, 35.120042 ], [ -75.973499, 35.121087 ], [ -75.966489, 35.117787 ], [ -75.954700, 35.119600 ], [ -75.923867, 35.135017 ], [ -75.910265, 35.142271 ], [ -75.893942, 35.150433 ], [ -75.839531, 35.172197 ], [ -75.819172, 35.176826 ], [ -75.812902, 35.178568 ], [ -75.801444, 35.183079 ], [ -75.793283, 35.188520 ], [ -75.785729, 35.194244 ], [ -75.754289, 35.199402 ], [ -75.753765, 35.199612 ] ] ], [ [ [ -75.675245, 35.929024 ], [ -75.659540, 35.919564 ], [ -75.662938, 35.916166 ], [ -75.662019, 35.906522 ], [ -75.653478, 35.904686 ], [ -75.648519, 35.906982 ], [ -75.645120, 35.905788 ], [ -75.627670, 35.883149 ], [ -75.616833, 35.856331 ], [ -75.619772, 35.847606 ], [ -75.614361, 35.815659 ], [ -75.620454, 35.809253 ], [ -75.624235, 35.809387 ], [ -75.638980, 35.818639 ], [ -75.667891, 35.823540 ], [ -75.675054, 35.830204 ], [ -75.660086, 35.838610 ], [ -75.660598, 35.862541 ], [ -75.663356, 35.869835 ], [ -75.672830, 35.882423 ], [ -75.681415, 35.883980 ], [ -75.697672, 35.901639 ], [ -75.696871, 35.909556 ], [ -75.702165, 35.915428 ], [ -75.723782, 35.925569 ], [ -75.727251, 35.933620 ], [ -75.726807, 35.935844 ], [ -75.718266, 35.939714 ], [ -75.705323, 35.939403 ], [ -75.691150, 35.936932 ], [ -75.686358, 35.932973 ], [ -75.675245, 35.929024 ] ] ], [ [ [ -76.491497, 36.550365 ], [ -76.313215, 36.550551 ], [ -76.313196, 36.550551 ], [ -76.122360, 36.550621 ], [ -76.034751, 36.550653 ], [ -76.026750, 36.550553 ], [ -75.957648, 36.550553 ], [ -75.955748, 36.550553 ], [ -75.953447, 36.550553 ], [ -75.952847, 36.550553 ], [ -75.922046, 36.550654 ], [ -75.911446, 36.550654 ], [ -75.909046, 36.550654 ], [ -75.904745, 36.550654 ], [ -75.903445, 36.550654 ], [ -75.894145, 36.550754 ], [ -75.893245, 36.550654 ], [ -75.891945, 36.550754 ], [ -75.886545, 36.550754 ], [ -75.885945, 36.550754 ], [ -75.880644, 36.550754 ], [ -75.879744, 36.550754 ], [ -75.867044, 36.550754 ], [ -75.856901, 36.500155 ], [ -75.834975, 36.422650 ], [ -75.818735, 36.357579 ], [ -75.796410, 36.290351 ], [ -75.773329, 36.231529 ], [ -75.772510, 36.229440 ], [ -75.759637, 36.204705 ], [ -75.738431, 36.154282 ], [ -75.718310, 36.113674 ], [ -75.696742, 36.077497 ], [ -75.658537, 36.020430 ], [ -75.569794, 35.863301 ], [ -75.552299, 35.822173 ], [ -75.538739, 35.797396 ], [ -75.533012, 35.787377 ], [ -75.536428, 35.780118 ], [ -75.543259, 35.779691 ], [ -75.546675, 35.787377 ], [ -75.553934, 35.799332 ], [ -75.566238, 35.813072 ], [ -75.573083, 35.828867 ], [ -75.588878, 35.844926 ], [ -75.601250, 35.867302 ], [ -75.619151, 35.889415 ], [ -75.617045, 35.906000 ], [ -75.617552, 35.914186 ], [ -75.620114, 35.925288 ], [ -75.631215, 35.941512 ], [ -75.648899, 35.965758 ], [ -75.668379, 35.978394 ], [ -75.671801, 35.985238 ], [ -75.678909, 35.993925 ], [ -75.723662, 36.003139 ], [ -75.727084, 36.010510 ], [ -75.726558, 36.021040 ], [ -75.722082, 36.032360 ], [ -75.722609, 36.037362 ], [ -75.726821, 36.040521 ], [ -75.737088, 36.040784 ], [ -75.740510, 36.046839 ], [ -75.741563, 36.055526 ], [ -75.739457, 36.066846 ], [ -75.739720, 36.075270 ], [ -75.750250, 36.121076 ], [ -75.750479, 36.131208 ], [ -75.752226, 36.140817 ], [ -75.755720, 36.153922 ], [ -75.775814, 36.201097 ], [ -75.783676, 36.215949 ], [ -75.793286, 36.226432 ], [ -75.794371, 36.227336 ], [ -75.798528, 36.230800 ], [ -75.803690, 36.235853 ], [ -75.811588, 36.244014 ], [ -75.811851, 36.247699 ], [ -75.808165, 36.259545 ], [ -75.814483, 36.285344 ], [ -75.822907, 36.291662 ], [ -75.833964, 36.292188 ], [ -75.837913, 36.294558 ], [ -75.845284, 36.305614 ], [ -75.841335, 36.328517 ], [ -75.831858, 36.339047 ], [ -75.831595, 36.346418 ], [ -75.836201, 36.363135 ], [ -75.843046, 36.371032 ], [ -75.847258, 36.372085 ], [ -75.851470, 36.379456 ], [ -75.852523, 36.384721 ], [ -75.851470, 36.415785 ], [ -75.864106, 36.430527 ], [ -75.880428, 36.435792 ], [ -75.888325, 36.441583 ], [ -75.891484, 36.460537 ], [ -75.899908, 36.482124 ], [ -75.907279, 36.485809 ], [ -75.913071, 36.486336 ], [ -75.917283, 36.485809 ], [ -75.924127, 36.482124 ], [ -75.927333, 36.482815 ], [ -75.935473, 36.490601 ], [ -75.960069, 36.495025 ], [ -75.972545, 36.494671 ], [ -76.003708, 36.506235 ], [ -76.019261, 36.503506 ], [ -76.023627, 36.500778 ], [ -76.029221, 36.494365 ], [ -76.031949, 36.482496 ], [ -76.020216, 36.458620 ], [ -76.012337, 36.447462 ], [ -76.003912, 36.441864 ], [ -75.989869, 36.436808 ], [ -75.980050, 36.435464 ], [ -75.962285, 36.417240 ], [ -75.940676, 36.418850 ], [ -75.936446, 36.423079 ], [ -75.932694, 36.427627 ], [ -75.928369, 36.428588 ], [ -75.923601, 36.425788 ], [ -75.916409, 36.389010 ], [ -75.916949, 36.383167 ], [ -75.923511, 36.367796 ], [ -75.923331, 36.361863 ], [ -75.917758, 36.353593 ], [ -75.915331, 36.352335 ], [ -75.895285, 36.319615 ], [ -75.888211, 36.293414 ], [ -75.882154, 36.284674 ], [ -75.872721, 36.282770 ], [ -75.864933, 36.284674 ], [ -75.860520, 36.280607 ], [ -75.861818, 36.266415 ], [ -75.867356, 36.252483 ], [ -75.864154, 36.235522 ], [ -75.858703, 36.222628 ], [ -75.848838, 36.216570 ], [ -75.838367, 36.200129 ], [ -75.841222, 36.193812 ], [ -75.839924, 36.177110 ], [ -75.823915, 36.158332 ], [ -75.822531, 36.145957 ], [ -75.813444, 36.136871 ], [ -75.800378, 36.112728 ], [ -75.791637, 36.082267 ], [ -75.793974, 36.071710 ], [ -75.799779, 36.072640 ], [ -75.836084, 36.092616 ], [ -75.847785, 36.101990 ], [ -75.867792, 36.127262 ], [ -75.866323, 36.141410 ], [ -75.867385, 36.151182 ], [ -75.869828, 36.154580 ], [ -75.875033, 36.157448 ], [ -75.887415, 36.160233 ], [ -75.904999, 36.164188 ], [ -75.920028, 36.164853 ], [ -75.924654, 36.163591 ], [ -75.939047, 36.165518 ], [ -75.995191, 36.178072 ], [ -76.016984, 36.186367 ], [ -76.018936, 36.188318 ], [ -76.031784, 36.189131 ], [ -76.047100, 36.183106 ], [ -76.051626, 36.181325 ], [ -76.063498, 36.173518 ], [ -76.065287, 36.170591 ], [ -76.065450, 36.165224 ], [ -76.059920, 36.155140 ], [ -76.059270, 36.149285 ], [ -76.064224, 36.143775 ], [ -76.071672, 36.140183 ], [ -76.092555, 36.135794 ], [ -76.178946, 36.123424 ], [ -76.184133, 36.121562 ], [ -76.190510, 36.116333 ], [ -76.190784, 36.116108 ], [ -76.192380, 36.113448 ], [ -76.191715, 36.107197 ], [ -76.216599, 36.095409 ], [ -76.238712, 36.098568 ], [ -76.265037, 36.104886 ], [ -76.287150, 36.104886 ], [ -76.298733, 36.101200 ], [ -76.303998, 36.092776 ], [ -76.323478, 36.084879 ], [ -76.331902, 36.083826 ], [ -76.337168, 36.086458 ], [ -76.355069, 36.086458 ], [ -76.410878, 36.078034 ], [ -76.411844, 36.075376 ], [ -76.412984, 36.072243 ], [ -76.420881, 36.060660 ], [ -76.442994, 36.042758 ], [ -76.451418, 36.039073 ], [ -76.458789, 36.028016 ], [ -76.459316, 36.024331 ], [ -76.491959, 36.018013 ], [ -76.514335, 36.005640 ], [ -76.547505, 36.009852 ], [ -76.563300, 36.009852 ], [ -76.575936, 36.006167 ], [ -76.580674, 36.007220 ], [ -76.589625, 36.015644 ], [ -76.603840, 36.033018 ], [ -76.615423, 36.037757 ], [ -76.631745, 36.038283 ], [ -76.653332, 36.035124 ], [ -76.668814, 36.020968 ], [ -76.671759, 36.018276 ], [ -76.684922, 36.009852 ], [ -76.683869, 36.000375 ], [ -76.679657, 35.991951 ], [ -76.684922, 35.983001 ], [ -76.695452, 35.973524 ], [ -76.700190, 35.964573 ], [ -76.697558, 35.951937 ], [ -76.692376, 35.945342 ], [ -76.691766, 35.944566 ], [ -76.673865, 35.935089 ], [ -76.667547, 35.933509 ], [ -76.657017, 35.935089 ], [ -76.608052, 35.936668 ], [ -76.603840, 35.939827 ], [ -76.586992, 35.941933 ], [ -76.528551, 35.944039 ], [ -76.507491, 35.949831 ], [ -76.496961, 35.955096 ], [ -76.473795, 35.960888 ], [ -76.460632, 35.970365 ], [ -76.398242, 35.984317 ], [ -76.389818, 35.980105 ], [ -76.381920, 35.971681 ], [ -76.381394, 35.962730 ], [ -76.365210, 35.944697 ], [ -76.362966, 35.942197 ], [ -76.340327, 35.943250 ], [ -76.317687, 35.946935 ], [ -76.272408, 35.972734 ], [ -76.213966, 35.988002 ], [ -76.176585, 35.993267 ], [ -76.093697, 35.993001 ], [ -76.083131, 35.989845 ], [ -76.062071, 35.993004 ], [ -76.024162, 35.970891 ], [ -76.014685, 35.960361 ], [ -76.014159, 35.957202 ], [ -76.019950, 35.934036 ], [ -76.011526, 35.914029 ], [ -76.004682, 35.905078 ], [ -75.999386, 35.903521 ], [ -75.977830, 35.897181 ], [ -75.966247, 35.899287 ], [ -75.962562, 35.901393 ], [ -75.947820, 35.920347 ], [ -75.934131, 35.928244 ], [ -75.929919, 35.928771 ], [ -75.927286, 35.931930 ], [ -75.926760, 35.940354 ], [ -75.937816, 35.950884 ], [ -75.943608, 35.952464 ], [ -75.946767, 35.955623 ], [ -75.947293, 35.959835 ], [ -75.938343, 35.965100 ], [ -75.899382, 35.977209 ], [ -75.879374, 35.978789 ], [ -75.860420, 35.978262 ], [ -75.849890, 35.976156 ], [ -75.809350, 35.959308 ], [ -75.805138, 35.954043 ], [ -75.800926, 35.944566 ], [ -75.782498, 35.935615 ], [ -75.782498, 35.928244 ], [ -75.778813, 35.918241 ], [ -75.768809, 35.901393 ], [ -75.751961, 35.878227 ], [ -75.753014, 35.871382 ], [ -75.748276, 35.852428 ], [ -75.734587, 35.839266 ], [ -75.727216, 35.822703 ], [ -75.726689, 35.811361 ], [ -75.732612, 35.790666 ], [ -75.738233, 35.778301 ], [ -75.739357, 35.770994 ], [ -75.735422, 35.767622 ], [ -75.724743, 35.742892 ], [ -75.719123, 35.714227 ], [ -75.715188, 35.708045 ], [ -75.712940, 35.698490 ], [ -75.713502, 35.693993 ], [ -75.741605, 35.672073 ], [ -75.742167, 35.655212 ], [ -75.737109, 35.638350 ], [ -75.729802, 35.628795 ], [ -75.729802, 35.625985 ], [ -75.747225, 35.610248 ], [ -75.762963, 35.603503 ], [ -75.778138, 35.592262 ], [ -75.775328, 35.579335 ], [ -75.797248, 35.574276 ], [ -75.837154, 35.570904 ], [ -75.851767, 35.578773 ], [ -75.859636, 35.586641 ], [ -75.869869, 35.582743 ], [ -75.895045, 35.573152 ], [ -75.906848, 35.559101 ], [ -75.908534, 35.555166 ], [ -75.908534, 35.546174 ], [ -75.916403, 35.538305 ], [ -75.945630, 35.534370 ], [ -75.950126, 35.530998 ], [ -75.954623, 35.526502 ], [ -75.964178, 35.511326 ], [ -75.964740, 35.504582 ], [ -75.961929, 35.496713 ], [ -75.963053, 35.493903 ], [ -75.987222, 35.484348 ], [ -75.995652, 35.475355 ], [ -75.994528, 35.463552 ], [ -75.997901, 35.453435 ], [ -76.009704, 35.442194 ], [ -76.012514, 35.432639 ], [ -76.011390, 35.423084 ], [ -76.014762, 35.416902 ], [ -76.020945, 35.410719 ], [ -76.025441, 35.408471 ], [ -76.037244, 35.414091 ], [ -76.050171, 35.415778 ], [ -76.059726, 35.410157 ], [ -76.063661, 35.405099 ], [ -76.063661, 35.398354 ], [ -76.060850, 35.392733 ], [ -76.059726, 35.383741 ], [ -76.069281, 35.370813 ], [ -76.092887, 35.361259 ], [ -76.123238, 35.351142 ], [ -76.132793, 35.349455 ], [ -76.142910, 35.338776 ], [ -76.142910, 35.328660 ], [ -76.149655, 35.326411 ], [ -76.165392, 35.328659 ], [ -76.168764, 35.332032 ], [ -76.182254, 35.336528 ], [ -76.205860, 35.336528 ], [ -76.235087, 35.350017 ], [ -76.253072, 35.350017 ], [ -76.257569, 35.344397 ], [ -76.265437, 35.343273 ], [ -76.282299, 35.345521 ], [ -76.304781, 35.355638 ], [ -76.327263, 35.356762 ], [ -76.335132, 35.355638 ], [ -76.340752, 35.346645 ], [ -76.349745, 35.345521 ], [ -76.365483, 35.348893 ], [ -76.374475, 35.355638 ], [ -76.382344, 35.356762 ], [ -76.387965, 35.356762 ], [ -76.399206, 35.348893 ], [ -76.408199, 35.350017 ], [ -76.409323, 35.353390 ], [ -76.420564, 35.359010 ], [ -76.431805, 35.362383 ], [ -76.436301, 35.378120 ], [ -76.448666, 35.383741 ], [ -76.455411, 35.383741 ], [ -76.462156, 35.380368 ], [ -76.472273, 35.371375 ], [ -76.485762, 35.371375 ], [ -76.499251, 35.381492 ], [ -76.521733, 35.391609 ], [ -76.546901, 35.389673 ], [ -76.580187, 35.387113 ], [ -76.606041, 35.387113 ], [ -76.620654, 35.378120 ], [ -76.628125, 35.368515 ], [ -76.628523, 35.368003 ], [ -76.619530, 35.345521 ], [ -76.604962, 35.337751 ], [ -76.602669, 35.336528 ], [ -76.588055, 35.333156 ], [ -76.554332, 35.332032 ], [ -76.548712, 35.328659 ], [ -76.500375, 35.321915 ], [ -76.482389, 35.314046 ], [ -76.472273, 35.294936 ], [ -76.467776, 35.276951 ], [ -76.467776, 35.261213 ], [ -76.477893, 35.243228 ], [ -76.483514, 35.240979 ], [ -76.490258, 35.233111 ], [ -76.491382, 35.220745 ], [ -76.494755, 35.212877 ], [ -76.504872, 35.207256 ], [ -76.521733, 35.192643 ], [ -76.536346, 35.174657 ], [ -76.539719, 35.166788 ], [ -76.536346, 35.149927 ], [ -76.536346, 35.142058 ], [ -76.546463, 35.122948 ], [ -76.557704, 35.116204 ], [ -76.561077, 35.108335 ], [ -76.568945, 35.097094 ], [ -76.575690, 35.092598 ], [ -76.586931, 35.092598 ], [ -76.592552, 35.083605 ], [ -76.593676, 35.075736 ], [ -76.600420, 35.067867 ], [ -76.613910, 35.061123 ], [ -76.622902, 35.061123 ], [ -76.631895, 35.056626 ], [ -76.639764, 35.051006 ], [ -76.646509, 35.042013 ], [ -76.646509, 35.025151 ], [ -76.644562, 35.019799 ], [ -76.642012, 35.012786 ], [ -76.628523, 34.994801 ], [ -76.588055, 34.991428 ], [ -76.566697, 34.998173 ], [ -76.539719, 35.000421 ], [ -76.502623, 35.007166 ], [ -76.495879, 35.011662 ], [ -76.491382, 35.017283 ], [ -76.490258, 35.034144 ], [ -76.480141, 35.052130 ], [ -76.474521, 35.070116 ], [ -76.468796, 35.075345 ], [ -76.463468, 35.076411 ], [ -76.435762, 35.057941 ], [ -76.432565, 35.049061 ], [ -76.431855, 35.030945 ], [ -76.425461, 35.001464 ], [ -76.406281, 34.987256 ], [ -76.398466, 34.976600 ], [ -76.395625, 34.975179 ], [ -76.332044, 34.970917 ], [ -76.326361, 34.976245 ], [ -76.329557, 34.986901 ], [ -76.350159, 35.016737 ], [ -76.360815, 35.025973 ], [ -76.364367, 35.031301 ], [ -76.364367, 35.034853 ], [ -76.352290, 35.033077 ], [ -76.318546, 35.020645 ], [ -76.293682, 35.009633 ], [ -76.288354, 35.005726 ], [ -76.288709, 34.997201 ], [ -76.290930, 34.994285 ], [ -76.293851, 34.991948 ], [ -76.296188, 34.986690 ], [ -76.296524, 34.976245 ], [ -76.290691, 34.969059 ], [ -76.275567, 34.960971 ], [ -76.274856, 34.953867 ], [ -76.277698, 34.940014 ], [ -76.284092, 34.936817 ], [ -76.311442, 34.910177 ], [ -76.319967, 34.897745 ], [ -76.333820, 34.882116 ], [ -76.347673, 34.872171 ], [ -76.368274, 34.872881 ], [ -76.377154, 34.867553 ], [ -76.379641, 34.862580 ], [ -76.395269, 34.855476 ], [ -76.400242, 34.855476 ], [ -76.411609, 34.841268 ], [ -76.415871, 34.825640 ], [ -76.415871, 34.813563 ], [ -76.403108, 34.806153 ], [ -76.390254, 34.805568 ], [ -76.383827, 34.807906 ], [ -76.373247, 34.817115 ], [ -76.362591, 34.824219 ], [ -76.341279, 34.842689 ], [ -76.322808, 34.861160 ], [ -76.273986, 34.897298 ], [ -76.233672, 34.925926 ], [ -76.194936, 34.962747 ], [ -76.160127, 34.991163 ], [ -76.111820, 35.034497 ], [ -76.093349, 35.048705 ], [ -76.069906, 35.075701 ], [ -76.064933, 35.077121 ], [ -76.043621, 35.070017 ], [ -76.038648, 35.065045 ], [ -76.035933, 35.058987 ], [ -76.073000, 35.030509 ], [ -76.137269, 34.987858 ], [ -76.233088, 34.905477 ], [ -76.310210, 34.852309 ], [ -76.386804, 34.784579 ], [ -76.450454, 34.714450 ], [ -76.494068, 34.661970 ], [ -76.524199, 34.615416 ], [ -76.535946, 34.588577 ], [ -76.555196, 34.615993 ], [ -76.553806, 34.628252 ], [ -76.550423, 34.630789 ], [ -76.549343, 34.645585 ], [ -76.579467, 34.660174 ], [ -76.618719, 34.672550 ], [ -76.642939, 34.677618 ], [ -76.662645, 34.685524 ], [ -76.676312, 34.693151 ], [ -76.693751, 34.692509 ], [ -76.726969, 34.696690 ], [ -76.770044, 34.696899 ], [ -76.817453, 34.693722 ], [ -76.906257, 34.682820 ], [ -76.990262, 34.669623 ], [ -77.031105, 34.661184 ], [ -77.112800, 34.639352 ], [ -77.136843, 34.632926 ], [ -77.169701, 34.622023 ], [ -77.209161, 34.605032 ], [ -77.240991, 34.587507 ], [ -77.322524, 34.535574 ], [ -77.462922, 34.471354 ], [ -77.491796, 34.456098 ], [ -77.517960, 34.440483 ], [ -77.556943, 34.417218 ], [ -77.582323, 34.400506 ], [ -77.635034, 34.359555 ], [ -77.661673, 34.341868 ], [ -77.687226, 34.320444 ], [ -77.713322, 34.294879 ], [ -77.715916, 34.292719 ], [ -77.740136, 34.272546 ], [ -77.764022, 34.245641 ], [ -77.829209, 34.162618 ], [ -77.841785, 34.140747 ], [ -77.870327, 34.079221 ], [ -77.874384, 34.075671 ], [ -77.878161, 34.067963 ], [ -77.915536, 33.971723 ], [ -77.927926, 33.945265 ], [ -77.937313, 33.928645 ], [ -77.946568, 33.912261 ], [ -77.956881, 33.877790 ], [ -77.960172, 33.853315 ], [ -77.970606, 33.844517 ], [ -78.006765, 33.858704 ], [ -78.009973, 33.861406 ], [ -78.009426, 33.867823 ], [ -78.018689, 33.888289 ], [ -78.095429, 33.906031 ], [ -78.136952, 33.912178 ], [ -78.177720, 33.914272 ], [ -78.276147, 33.912364 ], [ -78.383964, 33.901946 ], [ -78.509042, 33.865515 ], [ -78.541087, 33.851112 ], [ -78.650500, 33.944035 ], [ -78.710141, 33.994688 ], [ -78.712206, 33.996732 ], [ -79.071169, 34.299240 ], [ -79.143242, 34.359817 ], [ -79.151485, 34.366753 ], [ -79.190739, 34.399751 ], [ -79.192041, 34.401040 ], [ -79.198982, 34.406699 ], [ -79.323249, 34.514634 ], [ -79.324854, 34.516282 ], [ -79.331328, 34.521869 ], [ -79.358317, 34.545358 ], [ -79.450034, 34.621036 ], [ -79.459766, 34.629027 ], [ -79.461318, 34.630126 ], [ -79.461754, 34.630432 ], [ -79.468717, 34.635323 ], [ -79.471599, 34.637200 ], [ -79.479305, 34.644640 ], [ -79.490201, 34.653819 ], [ -79.519043, 34.677321 ], [ -79.520269, 34.678327 ], [ -79.554454, 34.706363 ], [ -79.561691, 34.711996 ], [ -79.631577, 34.768835 ], [ -79.634216, 34.771012 ], [ -79.688088, 34.804897 ], [ -79.690201, 34.804937 ], [ -79.692948, 34.804973 ], [ -79.744116, 34.805651 ], [ -79.744925, 34.805686 ], [ -79.772829, 34.805954 ], [ -79.773607, 34.805931 ], [ -79.927618, 34.806555 ], [ -80.027464, 34.808726 ], [ -80.042764, 34.809097 ], [ -80.072912, 34.809736 ], [ -80.077223, 34.809716 ], [ -80.098022, 34.810147 ], [ -80.098994, 34.810147 ], [ -80.320413, 34.813813 ], [ -80.399871, 34.815128 ], [ -80.417014, 34.815508 ], [ -80.418433, 34.815622 ], [ -80.419586, 34.815581 ], [ -80.425902, 34.815810 ], [ -80.434843, 34.815968 ], [ -80.448766, 34.816332 ], [ -80.451660, 34.816396 ], [ -80.485683, 34.816732 ], [ -80.561657, 34.817481 ], [ -80.561674, 34.817481 ], [ -80.621222, 34.818174 ], [ -80.625993, 34.818239 ], [ -80.626077, 34.818217 ], [ -80.644656, 34.818568 ], [ -80.646601, 34.818592 ], [ -80.771792, 34.819646 ], [ -80.777712, 34.819697 ], [ -80.796750, 34.825281 ], [ -80.782042, 34.935782 ], [ -80.806461, 34.962894 ], [ -80.806784, 34.963249 ], [ -80.840461, 35.001566 ], [ -80.906417, 35.076608 ], [ -80.906553, 35.076763 ], [ -80.934950, 35.107409 ], [ -80.957870, 35.092639 ], [ -81.041489, 35.044703 ], [ -81.057465, 35.061983 ], [ -81.058029, 35.073190 ], [ -81.057236, 35.086129 ], [ -81.052078, 35.096276 ], [ -81.046524, 35.100617 ], [ -81.036163, 35.103205 ], [ -81.032547, 35.109102 ], [ -81.042758, 35.146042 ], [ -81.043407, 35.148390 ], [ -81.090215, 35.152627 ], [ -81.239358, 35.159974 ], [ -81.241686, 35.160081 ], [ -81.269199, 35.161140 ], [ -81.328020, 35.163404 ], [ -81.366599, 35.164889 ], [ -81.366691, 35.164893 ], [ -81.452398, 35.168293 ], [ -81.461408, 35.168657 ], [ -81.493401, 35.169951 ], [ -81.494265, 35.169882 ], [ -81.768073, 35.180132 ], [ -81.857832, 35.183492 ], [ -81.874433, 35.184113 ], [ -81.969325, 35.187215 ], [ -82.167676, 35.193699 ], [ -82.176874, 35.193790 ], [ -82.185513, 35.194355 ], [ -82.195483, 35.194951 ], [ -82.216217, 35.196044 ], [ -82.230517, 35.196764 ], [ -82.230915, 35.196784 ], [ -82.257515, 35.198636 ], [ -82.288453, 35.198605 ], [ -82.352430, 35.206595 ], [ -82.384029, 35.210542 ], [ -82.476136, 35.175486 ], [ -82.516910, 35.163029 ], [ -82.517284, 35.162643 ], [ -82.535804, 35.158699 ], [ -82.536527, 35.159137 ], [ -82.574406, 35.144216 ], [ -82.580127, 35.141963 ], [ -82.582264, 35.142268 ], [ -82.686496, 35.121822 ], [ -82.686738, 35.119790 ], [ -82.764464, 35.068177 ], [ -82.781973, 35.066817 ], [ -82.780546, 35.069043 ], [ -82.779116, 35.073674 ], [ -82.777407, 35.076885 ], [ -82.781062, 35.084492 ], [ -82.781130, 35.084585 ], [ -82.897499, 35.056021 ], [ -83.008447, 35.026974 ], [ -83.108535, 35.000771 ], [ -83.108714, 35.000768 ], [ -83.483064, 34.993737 ], [ -83.549381, 34.992492 ], [ -83.620185, 34.992091 ], [ -83.673621, 34.987111 ], [ -83.936413, 34.987485 ], [ -83.936646, 34.987485 ], [ -84.005457, 34.987440 ], [ -84.021357, 34.987430 ], [ -84.029954, 34.987321 ], [ -84.129455, 34.987504 ], [ -84.129555, 34.987504 ], [ -84.321869, 34.988408 ], [ -84.308576, 35.092761 ], [ -84.308437, 35.093173 ], [ -84.292321, 35.206677 ], [ -84.290240, 35.225572 ], [ -84.227818, 35.267878 ], [ -84.223718, 35.269078 ], [ -84.211818, 35.266078 ], [ -84.202879, 35.255772 ], [ -84.124915, 35.249830 ], [ -84.121150, 35.250644 ], [ -84.115279, 35.250438 ], [ -84.115048, 35.249765 ], [ -84.097508, 35.247382 ], [ -84.055712, 35.268182 ], [ -84.029033, 35.291049 ], [ -84.023510, 35.295783 ], [ -84.021410, 35.301383 ], [ -84.032479, 35.325318 ], [ -84.032450, 35.326530 ], [ -84.038081, 35.348363 ], [ -84.037494, 35.349850 ], [ -84.035343, 35.350833 ], [ -84.024756, 35.353896 ], [ -84.002250, 35.422548 ], [ -83.999906, 35.425201 ], [ -83.961400, 35.459496 ], [ -83.961054, 35.462838 ], [ -83.961056, 35.463738 ], [ -83.961053, 35.464143 ], [ -83.952882, 35.460635 ], [ -83.952676, 35.460763 ], [ -83.933876, 35.472438 ], [ -83.880074, 35.518745 ], [ -83.756917, 35.563604 ], [ -83.676268, 35.570289 ], [ -83.662957, 35.569138 ], [ -83.640498, 35.566075 ], [ -83.498335, 35.562981 ], [ -83.485527, 35.568204 ], [ -83.480617, 35.576633 ], [ -83.478523, 35.579202 ], [ -83.479082, 35.583316 ], [ -83.445802, 35.611803 ], [ -83.366941, 35.638728 ], [ -83.297154, 35.657750 ], [ -83.254231, 35.695807 ], [ -83.250695, 35.709349 ], [ -83.255489, 35.714974 ], [ -83.251247, 35.719916 ], [ -83.240669, 35.726760 ], [ -83.164909, 35.759965 ], [ -83.100233, 35.774745 ], [ -83.100329, 35.774804 ], [ -83.100225, 35.774765 ], [ -82.995803, 35.773128 ], [ -82.983970, 35.778010 ], [ -82.964108, 35.794100 ], [ -82.962842, 35.795126 ], [ -82.918356, 35.845467 ], [ -82.897980, 35.881278 ], [ -82.913338, 35.924113 ], [ -82.898506, 35.945100 ], [ -82.898505, 35.945101 ], [ -82.874159, 35.952698 ], [ -82.852554, 35.949089 ], [ -82.830112, 35.932972 ], [ -82.778625, 35.974792 ], [ -82.754465, 36.004304 ], [ -82.715365, 36.024253 ], [ -82.683565, 36.046104 ], [ -82.637165, 36.065805 ], [ -82.632265, 36.065705 ], [ -82.619205, 36.056556 ], [ -82.602877, 36.039833 ], [ -82.615062, 36.000306 ], [ -82.611262, 35.973155 ], [ -82.596774, 35.964987 ], [ -82.557529, 35.954671 ], [ -82.512598, 35.975664 ], [ -82.507068, 35.977475 ], [ -82.505860, 35.978342 ], [ -82.487451, 35.991557 ], [ -82.487411, 35.991634 ], [ -82.462958, 36.007309 ], [ -82.416857, 36.072885 ], [ -82.409458, 36.083409 ], [ -82.375558, 36.105609 ], [ -82.371383, 36.106388 ], [ -82.366566, 36.107650 ], [ -82.360919, 36.110614 ], [ -82.348422, 36.115929 ], [ -82.329177, 36.117427 ], [ -82.325169, 36.119363 ], [ -82.237737, 36.139189 ], [ -82.236415, 36.139926 ], [ -82.235479, 36.140748 ], [ -82.234807, 36.141720 ], [ -82.222052, 36.156911 ], [ -82.211251, 36.159012 ], [ -82.147948, 36.149516 ], [ -82.136547, 36.128817 ], [ -82.137974, 36.119576 ], [ -82.130646, 36.106417 ], [ -82.127146, 36.104417 ], [ -82.080518, 36.105710 ], [ -82.080143, 36.105720 ], [ -82.026640, 36.130222 ], [ -81.960101, 36.228131 ], [ -81.932994, 36.264881 ], [ -81.918113, 36.287110 ], [ -81.908137, 36.302013 ], [ -81.855005, 36.337259 ], [ -81.800812, 36.358073 ], [ -81.793688, 36.360428 ], [ -81.789712, 36.348324 ], [ -81.764927, 36.338672 ], [ -81.747842, 36.337356 ], [ -81.730976, 36.341187 ], [ -81.725938, 36.340364 ], [ -81.720969, 36.387500 ], [ -81.714277, 36.450978 ], [ -81.715082, 36.453365 ], [ -81.697287, 36.484738 ], [ -81.695907, 36.491580 ], [ -81.696835, 36.493393 ], [ -81.697261, 36.496141 ], [ -81.698265, 36.497221 ], [ -81.699928, 36.498018 ], [ -81.700238, 36.500475 ], [ -81.699923, 36.500865 ], [ -81.697970, 36.504063 ], [ -81.697290, 36.504887 ], [ -81.697829, 36.507544 ], [ -81.697744, 36.508448 ], [ -81.699446, 36.511504 ], [ -81.699601, 36.512883 ], [ -81.700093, 36.514158 ], [ -81.700553, 36.515190 ], [ -81.707963, 36.536209 ], [ -81.699962, 36.539714 ], [ -81.677535, 36.588117 ], [ -81.606970, 36.587094 ], [ -81.521032, 36.580520 ], [ -81.353322, 36.574723 ], [ -81.353169, 36.574724 ], [ -81.307511, 36.575024 ], [ -81.061866, 36.567020 ], [ -81.058844, 36.566976 ], [ -80.945988, 36.563196 ], [ -80.944338, 36.563058 ], [ -80.901836, 36.561754 ], [ -80.901726, 36.561751 ], [ -80.837954, 36.559131 ], [ -80.837641, 36.559118 ], [ -80.837089, 36.559154 ], [ -80.744101, 36.561686 ], [ -80.687539, 36.561411 ], [ -80.612158, 36.558127 ], [ -80.440100, 36.550630 ], [ -80.432628, 36.550302 ], [ -80.431605, 36.550219 ], [ -80.228263, 36.543867 ], [ -80.225408, 36.543748 ], [ -80.171636, 36.543219 ], [ -80.169535, 36.543190 ], [ -80.053455, 36.542623 ], [ -80.027269, 36.542495 ], [ -79.967511, 36.542502 ], [ -79.966979, 36.542475 ], [ -79.920239, 36.542365 ], [ -79.714855, 36.541884 ], [ -79.667309, 36.541772 ], [ -79.666827, 36.541772 ], [ -79.510961, 36.540740 ], [ -79.510647, 36.540738 ], [ -79.470047, 36.541025 ], [ -79.445961, 36.541195 ], [ -79.445687, 36.541218 ], [ -79.342696, 36.541382 ], [ -79.218638, 36.541579 ], [ -79.209480, 36.541594 ], [ -79.208686, 36.541571 ], [ -79.137936, 36.541739 ], [ -79.126078, 36.541533 ], [ -79.124736, 36.541568 ], [ -78.971814, 36.542123 ], [ -78.970577, 36.542154 ], [ -78.942254, 36.542079 ], [ -78.942009, 36.542113 ], [ -78.915420, 36.541974 ], [ -78.914543, 36.541972 ], [ -78.796300, 36.541713 ], [ -78.765430, 36.541727 ], [ -78.758392, 36.541852 ], [ -78.734122, 36.541902 ], [ -78.670051, 36.542035 ], [ -78.663317, 36.542011 ], [ -78.533013, 36.541004 ], [ -78.529722, 36.540981 ], [ -78.471022, 36.542307 ], [ -78.470792, 36.542316 ], [ -78.456970, 36.542474 ], [ -78.441199, 36.542687 ], [ -78.436333, 36.542666 ], [ -78.323912, 36.543809 ], [ -78.246681, 36.544341 ], [ -78.245462, 36.544411 ], [ -78.133323, 36.543847 ], [ -78.132911, 36.543811 ], [ -78.046202, 36.544168 ], [ -78.039420, 36.544196 ], [ -78.038938, 36.544173 ], [ -77.899771, 36.544663 ], [ -77.882357, 36.544737 ], [ -77.875280, 36.544754 ], [ -77.767117, 36.544752 ], [ -77.296875, 36.544746 ], [ -77.249690, 36.544745 ], [ -77.164500, 36.546330 ], [ -76.916048, 36.543815 ], [ -76.916001, 36.543818 ], [ -76.915384, 36.543856 ], [ -76.807078, 36.550606 ], [ -76.781296, 36.550659 ], [ -76.541687, 36.550312 ], [ -76.541391, 36.550312 ], [ -76.491497, 36.550365 ] ] ] ];
			var ncLatLngArray = [];
			
			this.options.statePolygon = [];
			
			
			if(this.options.stateData.geometry.type === "MultiPolygon"){
			for(var i = 0; i < this.options.stateData.geometry.coordinates.length; i++){
				this.options.statePolygon.push([]);
				for(var j = 0; j<this.options.stateData.geometry.coordinates[i][0].length; j++){
					this.options.statePolygon[i].push(new L.LatLng(this.options.stateData.geometry.coordinates[i][0][j][1], this.options.stateData.geometry.coordinates[i][0][j][0]));
				}
			}
		}
			else{
				this.options.statePolygon.push([]);
				for(var j = 0; j < this.options.stateData.geometry.coordinates[0].length - 1; j++){

					this.options.statePolygon[0].push(new L.LatLng(this.options.stateData.geometry.coordinates[0][j][1], this.options.stateData.geometry.coordinates[0][j][0]));

			}
			
			}
		}
	},

	addLayer: function (layer) {

		if (layer instanceof L.LayerGroup) {
			var array = [];
			for (var i in layer._layers) {
				array.push(layer._layers[i]);
			}
			return this.addLayers(array);
		}

		if (!this._map) {
			this._needsClustering.push(layer);
			return this;
		}

		if (this.hasLayer(layer)) {
			return this;
		}

		//If we have already clustered we'll need to add this one to a cluster

		if (this._unspiderfy) {
			this._unspiderfy();
		}

		this._addLayer(layer, this._maxZoom);

		//Work out what is visible
		var visibleLayer = layer,
			currentZoom = this._map.getZoom();
		if (layer.__parent) {
			while (visibleLayer.__parent._zoom >= currentZoom) {
				visibleLayer = visibleLayer.__parent;
			}
		}

		if (this._currentShownBounds.contains(visibleLayer.getLatLng())) {
			if (this.options.animateAddingMarkers) {
				this._animationAddLayer(layer, visibleLayer);
			} else {
				this._animationAddLayerNonAnimated(layer, visibleLayer);
			}
		}
		return this;
	},

	removeLayer: function (layer) {

		if (!this._map) {
			if (!this._arraySplice(this._needsClustering, layer) && this.hasLayer(layer)) {
				this._needsRemoving.push(layer);
			}
			return this;
		}

		if (!layer.__parent) {
			return this;
		}

		if (this._unspiderfy) {
			this._unspiderfy();
			this._unspiderfyLayer(layer);
		}

		//Remove the marker from clusters
		this._removeLayer(layer, true);

		if (layer._icon) {
			L.FeatureGroup.prototype.removeLayer.call(this, layer);
			layer.setOpacity(1);
		}

		return this;
	},

	//Takes an array of markers and adds them in bulk
	addLayers: function (layersArray) {
		var i, l, m;
		if (!this._map) {
			this._needsClustering = this._needsClustering.concat(layersArray);
			return this;
		}

		for (i = 0, l = layersArray.length; i < l; i++) {
			m = layersArray[i];

			if (this.hasLayer(m)) {
				continue;
			}

			this._addLayer(m, this._maxZoom);

			//If we just made a cluster of size 2 then we need to remove the other marker from the map (if it is) or we never will
			if (m.__parent) {
				if (m.__parent.getChildCount() === 2) {
					var markers = m.__parent.getAllChildMarkers(),
						otherMarker = markers[0] === m ? markers[1] : markers[0];
					L.FeatureGroup.prototype.removeLayer.call(this, otherMarker);
				}
			}
		}

		//Update the icons of all those visible clusters that were affected
		for (i in this._layers) {
			m = this._layers[i];
			if (m instanceof L.MarkerCluster && m._iconNeedsUpdate) {
				m._updateIcon();
			}
		}

		this._topClusterLevel._recursivelyAddChildrenToMap(null, this._zoom, this._currentShownBounds);

		return this;
	},

	//Takes an array of markers and removes them in bulk
	removeLayers: function (layersArray) {
		var i, l, m;

		if (!this._map) {
			for (i = 0, l = layersArray.length; i < l; i++) {
				this._arraySplice(this._needsClustering, layersArray[i]);
			}
			return this;
		}

		for (i = 0, l = layersArray.length; i < l; i++) {
			m = layersArray[i];

			if (!m.__parent) {
				continue;
			}

			this._removeLayer(m, true, true);

			if (m._icon) {
				L.FeatureGroup.prototype.removeLayer.call(this, m);
				m.setOpacity(1);
			}
		}

		//Fix up the clusters and markers on the map
		this._topClusterLevel._recursivelyAddChildrenToMap(null, this._zoom, this._currentShownBounds);

		for (i in this._layers) {
			m = this._layers[i];
			if (m instanceof L.MarkerCluster) {
				m._updateIcon();
			}
		}

		return this;
	},

	//Removes all layers from the MarkerClusterGroup
	clearLayers: function () {
		//Need our own special implementation as the LayerGroup one doesn't work for us

		//If we aren't on the map (yet), blow away the markers we know of
		if (!this._map) {
			this._needsClustering = [];
			delete this._gridClusters;
			delete this._gridUnclustered;
		}

		if (this._noanimationUnspiderfy) {
			this._noanimationUnspiderfy();
		}

		//Remove all the visible layers
		for (var i in this._layers) {
			L.FeatureGroup.prototype.removeLayer.call(this, this._layers[i]);
		}

		this.eachLayer(function (marker) {
			delete marker.__parent;
		});

		if (this._map) {
			//Reset _topClusterLevel and the DistanceGrids
			this._generateInitialClusters();
		}

		return this;
	},

	//Override FeatureGroup.getBounds as it doesn't work
	getBounds: function () {
		var bounds = new L.LatLngBounds();
		if (this._topClusterLevel) {
			bounds.extend(this._topClusterLevel._bounds);
		} else {
			for (var i = this._needsClustering.length - 1; i >= 0; i--) {
				bounds.extend(this._needsClustering[i].getLatLng());
			}
		}
		return bounds;
	},

	//Overrides LayerGroup.eachLayer
	eachLayer: function (method, context) {
		var markers = this._needsClustering.slice(),
		    i;

		if (this._topClusterLevel) {
			this._topClusterLevel.getAllChildMarkers(markers);
		}

		for (i = markers.length - 1; i >= 0; i--) {
			method.call(context, markers[i]);
		}
	},

	//Returns true if the given layer is in this MarkerClusterGroup
	hasLayer: function (layer) {
		if (layer._noHas) {
			return false;
		}

		var i, anArray = this._needsClustering;

		for (i = anArray.length - 1; i >= 0; i--) {
			if (anArray[i] === layer) {
				return true;
			}
		}

		anArray = this._needsRemoving;
		for (i = anArray.length - 1; i >= 0; i--) {
			if (anArray[i] === layer) {
				return false;
			}
		}

		return !!(layer.__parent && layer.__parent._group === this);
	},

	//Zoom down to show the given layer (spiderfying if necessary) then calls the callback
	zoomToShowLayer: function (layer, callback) {

		var showMarker = function () {
			if ((layer._icon || layer.__parent._icon) && !this._inZoomAnimation) {
				this._map.off('moveend', showMarker, this);
				this.off('animationend', showMarker, this);

				if (layer._icon) {
					callback();
				} else if (layer.__parent._icon) {
					var afterSpiderfy = function () {
						this.off('spiderfied', afterSpiderfy, this);
						callback();
					};

					this.on('spiderfied', afterSpiderfy, this);
					layer.__parent.spiderfy();
				}
			}
		};

		if (layer._icon) {
			callback();
		} else if (layer.__parent._zoom < this._map.getZoom()) {
			//Layer should be visible now but isn't on screen, just pan over to it
			this._map.on('moveend', showMarker, this);
			if (!layer._icon) {
				this._map.panTo(layer.getLatLng());
			}
		} else {
			this._map.on('moveend', showMarker, this);
			this.on('animationend', showMarker, this);
			this._map.setView(layer.getLatLng(), layer.__parent._zoom + 1);
			layer.__parent.zoomToBounds();
		}
	},

	//Overrides FeatureGroup.onAdd
	onAdd: function (map) {
		this._map = map;
		var i, l, layer;

		if (!this._gridClusters) {
			this._generateInitialClusters();
		}

		for (i = 0, l = this._needsRemoving.length; i < l; i++) {
			layer = this._needsRemoving[i];
			this._removeLayer(layer);
		}
		this._needsRemoving = [];

		for (i = 0, l = this._needsClustering.length; i < l; i++) {
			layer = this._needsClustering[i];
			if (layer.__parent) {
				continue;
			}
			this._addLayer(layer, this._maxZoom);
		}
		this._needsClustering = [];


		this._map.on('zoomend', this._zoomEnd, this);
		this._map.on('moveend', this._moveEnd, this);

		if (this._spiderfierOnAdd) { //TODO FIXME: Not sure how to have spiderfier add something on here nicely
			this._spiderfierOnAdd();
		}

		this._bindEvents();


		//Actually add our markers to the map:

		//Remember the current zoom level and bounds
		this._zoom = this._map.getZoom();
		this._currentShownBounds = this._getExpandedVisibleBounds();

		//Make things appear on the map
		this._topClusterLevel._recursivelyAddChildrenToMap(null, this._zoom, this._currentShownBounds);
	},

	//Overrides FeatureGroup.onRemove
	onRemove: function (map) {
		map.off('zoomend', this._zoomEnd, this);
		map.off('moveend', this._moveEnd, this);

		this._unbindEvents();

		//In case we are in a cluster animation
		this._map._mapPane.className = this._map._mapPane.className.replace(' leaflet-cluster-anim', '');

		if (this._spiderfierOnRemove) { //TODO FIXME: Not sure how to have spiderfier add something on here nicely
			this._spiderfierOnRemove();
		}

		//Clean up all the layers we added to the map
		for (var i in this._layers) {
			L.FeatureGroup.prototype.removeLayer.call(this, this._layers[i]);
		}

		this._map = null;
	},


	//Remove the given object from the given array
	_arraySplice: function (anArray, obj) {
		for (var i = anArray.length - 1; i >= 0; i--) {
			if (anArray[i] === obj) {
				anArray.splice(i, 1);
				return true;
			}
		}
	},

	//Internal function for removing a marker from everything.
	//dontUpdateMap: set to true if you will handle updating the map manually (for bulk functions)
	_removeLayer: function (marker, removeFromDistanceGrid, dontUpdateMap) {
		var gridClusters = this._gridClusters,
			gridUnclustered = this._gridUnclustered,
			map = this._map;

		//Remove the marker from distance clusters it might be in
		if (removeFromDistanceGrid) {
			for (var z = this._maxZoom; z >= 0; z--) {
				if (!gridUnclustered[z].removeObject(marker, map.project(marker.getLatLng(), z))) {
					break;
				}
			}
		}

		//Work our way up the clusters removing them as we go if required
		var cluster = marker.__parent,
			markers = cluster._markers,
			otherMarker;

		//Remove the marker from the immediate parents marker list
		this._arraySplice(markers, marker);

		while (cluster) {
			cluster._childCount--;

			if (cluster._zoom < 0) {
				//Top level, do nothing
				break;
			} else if (removeFromDistanceGrid && cluster._childCount <= 1) { //Cluster no longer required
				//We need to push the other marker up to the parent
				otherMarker = cluster._markers[0] === marker ? cluster._markers[1] : cluster._markers[0];

				//Update distance grid
				gridClusters[cluster._zoom].removeObject(cluster, map.project(cluster._cLatLng, cluster._zoom));
				gridUnclustered[cluster._zoom].addObject(otherMarker, map.project(otherMarker.getLatLng(), cluster._zoom));

				//Move otherMarker up to parent
				this._arraySplice(cluster.__parent._childClusters, cluster);
				cluster.__parent._markers.push(otherMarker);
				otherMarker.__parent = cluster.__parent;

				if (cluster._icon) {
					//Cluster is currently on the map, need to put the marker on the map instead
					L.FeatureGroup.prototype.removeLayer.call(this, cluster);
					if (!dontUpdateMap) {
						L.FeatureGroup.prototype.addLayer.call(this, otherMarker);
					}
				}
			} else {
				cluster._recalculateBounds();
				if (!dontUpdateMap || !cluster._icon) {
					cluster._updateIcon();
				}
			}

			cluster = cluster.__parent;
		}

		delete marker.__parent;
	},

	//Overrides FeatureGroup._propagateEvent
	_propagateEvent: function (e) {
		if (e.target instanceof L.MarkerCluster) {
			e.type = 'cluster' + e.type;
		}
		L.FeatureGroup.prototype._propagateEvent.call(this, e);
	},

	//Default functionality
	_defaultIconCreateFunction: function (cluster) {
		var childCount = cluster.getChildCount();

		var c = ' marker-cluster-';
		if (childCount < 10) {
			c += 'small';
		} else if (childCount < 100) {
			c += 'medium';
		} else {
			c += 'large';
		}

		return new L.DivIcon({ html: '<div><span>' + childCount + '</span></div>', className: 'marker-cluster' + c, iconSize: new L.Point(40, 40) });
	},

	_bindEvents: function () {
		var shownPolygon = null,
			map = this._map,

			spiderfyOnMaxZoom = this.options.spiderfyOnMaxZoom,
			showCoverageOnHover = this.options.showCoverageOnHover,
			zoomToBoundsOnClick = this.options.zoomToBoundsOnClick;

		//Zoom on cluster click or spiderfy if we are at the lowest level
		if (spiderfyOnMaxZoom || zoomToBoundsOnClick) {
			this.on('clusterclick', function (a) {
				if (map.getMaxZoom() === map.getZoom()) {
					if (spiderfyOnMaxZoom) {
						a.layer.spiderfy();
					}
				} else if (zoomToBoundsOnClick) {
					a.layer.zoomToBounds();
				}
			}, this);
		}

		//Show convex hull (boundary) polygon on mouse over
		
		if (showCoverageOnHover) {
			if(this.options.inUs){
			this.on('clustermouseover', function (a) {
				
				if (this._inZoomAnimation) {
					return;
				}
				if (shownPolygon) {
					map.removeLayer(shownPolygon);
				}
				if (a.layer !== this._spiderfied) {
					shownPolygon = new L.MultiPolygon(this.options.statePolygon, this.options.polygonOptions);
					map.addLayer(shownPolygon);
				}
			}, this);
		}
		else{
			this.on('clustermouseover', function (a) {
				if (this._inZoomAnimation) {
					return;
				}
				if (shownPolygon) {
					map.removeLayer(shownPolygon);
				}
				if (a.layer.getChildCount() > 2 && a.layer !== this._spiderfied) {
					shownPolygon = new L.Polygon(a.layer.getConvexHull(), this.options.polygonOptions);
					map.addLayer(shownPolygon);
				}
			}, this);
		}
			this.on('clustermouseout', function () {
				if (shownPolygon) {
					map.removeLayer(shownPolygon);
					shownPolygon = null;
				}
			}, this);
			map.on('zoomend', function () {
				if (shownPolygon) {
					map.removeLayer(shownPolygon);
					shownPolygon = null;
				}
			}, this);
			map.on('layerremove', function (opt) {
				if (shownPolygon && opt.layer === this) {
					map.removeLayer(shownPolygon);
					shownPolygon = null;
				}
			}, this);
		}
	},

	_unbindEvents: function () {
		var spiderfyOnMaxZoom = this.options.spiderfyOnMaxZoom,
			showCoverageOnHover = this.options.showCoverageOnHover,
			zoomToBoundsOnClick = this.options.zoomToBoundsOnClick,
			map = this._map;

		if (spiderfyOnMaxZoom || zoomToBoundsOnClick) {
			this.off('clusterclick', null, this);
		}
		if (showCoverageOnHover) {
			this.off('clustermouseover', null, this);
			this.off('clustermouseout', null, this);
			map.off('zoomend', null, this);
			map.off('layerremove', null, this);
		}
	},

	_zoomEnd: function () {
		if (!this._map) { //May have been removed from the map by a zoomEnd handler
			return;
		}
		this._mergeSplitClusters();

		this._zoom = this._map._zoom;
		this._currentShownBounds = this._getExpandedVisibleBounds();
	},

	_moveEnd: function () {
		if (this._inZoomAnimation) {
			return;
		}

		var newBounds = this._getExpandedVisibleBounds();

		this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds, this._zoom, newBounds);
		this._topClusterLevel._recursivelyAddChildrenToMap(null, this._zoom, newBounds);

		this._currentShownBounds = newBounds;
		return;
	},

	_generateInitialClusters: function () {
		var maxZoom = this._map.getMaxZoom(),
			radius = this.options.maxClusterRadius;

		if (this.options.disableClusteringAtZoom) {
			maxZoom = this.options.disableClusteringAtZoom - 1;
		}
		this._maxZoom = maxZoom;
		this._gridClusters = {};
		this._gridUnclustered = {};

		//Set up DistanceGrids for each zoom
		for (var zoom = maxZoom; zoom >= 0; zoom--) {
			this._gridClusters[zoom] = new L.DistanceGrid(radius);
			this._gridUnclustered[zoom] = new L.DistanceGrid(radius);
		}

		this._topClusterLevel = new L.MarkerCluster(this, -1);
	},

	//Zoom: Zoom to start adding at (Pass this._maxZoom to start at the bottom)
	_addLayer: function (layer, zoom) {
		var gridClusters = this._gridClusters,
		    gridUnclustered = this._gridUnclustered,
		    markerPoint, z;

		if (this.options.singleMarkerMode) {
			layer.options.icon = this.options.iconCreateFunction({
				getChildCount: function () {
					return 1;
				},
				getAllChildMarkers: function () {
					return [layer];
				}
			});
		}

		//Find the lowest zoom level to slot this one in
		for (; zoom >= 0; zoom--) {
			markerPoint = this._map.project(layer.getLatLng(), zoom); // calculate pixel position

			//Try find a cluster close by
			var closest = gridClusters[zoom].getNearObject(markerPoint);
			if (closest) {
				closest._addChild(layer);
				layer.__parent = closest;
				return;
			}

			//Try find a marker close by to form a new cluster with
			closest = gridUnclustered[zoom].getNearObject(markerPoint);
			if (closest) {
				var parent = closest.__parent;
				if (parent) {
					this._removeLayer(closest, false);
				}

				//Create new cluster with these 2 in it

				var newCluster = new L.MarkerCluster(this, zoom, closest, layer);
				gridClusters[zoom].addObject(newCluster, this._map.project(newCluster._cLatLng, zoom));
				closest.__parent = newCluster;
				layer.__parent = newCluster;

				//First create any new intermediate parent clusters that don't exist
				var lastParent = newCluster;
				for (z = zoom - 1; z > parent._zoom; z--) {
					lastParent = new L.MarkerCluster(this, z, lastParent);
					gridClusters[z].addObject(lastParent, this._map.project(closest.getLatLng(), z));
				}
				parent._addChild(lastParent);

				//Remove closest from this zoom level and any above that it is in, replace with newCluster
				for (z = zoom; z >= 0; z--) {
					if (!gridUnclustered[z].removeObject(closest, this._map.project(closest.getLatLng(), z))) {
						break;
					}
				}

				return;
			}

			//Didn't manage to cluster in at this zoom, record us as a marker here and continue upwards
			gridUnclustered[zoom].addObject(layer, markerPoint);
		}

		//Didn't get in anything, add us to the top
		this._topClusterLevel._addChild(layer);
		layer.__parent = this._topClusterLevel;
		return;
	},

	//Merge and split any existing clusters that are too big or small
	_mergeSplitClusters: function () {
		if (this._zoom < this._map._zoom) { //Zoom in, split
			this._animationStart();
			//Remove clusters now off screen
			this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds, this._zoom, this._getExpandedVisibleBounds());

			this._animationZoomIn(this._zoom, this._map._zoom);

		} else if (this._zoom > this._map._zoom) { //Zoom out, merge
			this._animationStart();

			this._animationZoomOut(this._zoom, this._map._zoom);
		} else {
			this._moveEnd();
		}
	},

	//Gets the maps visible bounds expanded in each direction by the size of the screen (so the user cannot see an area we do not cover in one pan)
	_getExpandedVisibleBounds: function () {
        if (!this.options.removeOutsideVisibleBounds) {
            return this.getBounds();
        }

		var map = this._map,
			bounds = map.getBounds(),
			sw = bounds._southWest,
			ne = bounds._northEast,
			latDiff = L.Browser.mobile ? 0 : Math.abs(sw.lat - ne.lat),
			lngDiff = L.Browser.mobile ? 0 : Math.abs(sw.lng - ne.lng);

		return new L.LatLngBounds(
			new L.LatLng(sw.lat - latDiff, sw.lng - lngDiff, true),
			new L.LatLng(ne.lat + latDiff, ne.lng + lngDiff, true));
	},

	//Shared animation code
	_animationAddLayerNonAnimated: function (layer, newCluster) {
		if (newCluster === layer) {
			L.FeatureGroup.prototype.addLayer.call(this, layer);
		} else if (newCluster._childCount === 2) {
			newCluster._addToMap();

			var markers = newCluster.getAllChildMarkers();
			L.FeatureGroup.prototype.removeLayer.call(this, markers[0]);
			L.FeatureGroup.prototype.removeLayer.call(this, markers[1]);
		} else {
			newCluster._updateIcon();
		}
	}
});

L.MarkerClusterGroup.include(!L.DomUtil.TRANSITION ? {

	//Non Animated versions of everything
	_animationStart: function () {
		//Do nothing...
	},
	_animationZoomIn: function (previousZoomLevel, newZoomLevel) {
		this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds, previousZoomLevel);
		this._topClusterLevel._recursivelyAddChildrenToMap(null, newZoomLevel, this._getExpandedVisibleBounds());
	},
	_animationZoomOut: function (previousZoomLevel, newZoomLevel) {
		this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds, previousZoomLevel);
		this._topClusterLevel._recursivelyAddChildrenToMap(null, newZoomLevel, this._getExpandedVisibleBounds());
	},
	_animationAddLayer: function (layer, newCluster) {
		this._animationAddLayerNonAnimated(layer, newCluster);
	}
} : {

	//Animated versions here
	_animationStart: function () {
		this._map._mapPane.className += ' leaflet-cluster-anim';
		this._inZoomAnimation++;
	},
	_animationEnd: function () {
		if (this._map) {
			this._map._mapPane.className = this._map._mapPane.className.replace(' leaflet-cluster-anim', '');
		}
		this._inZoomAnimation--;
		this.fire('animationend');
	},
	_animationZoomIn: function (previousZoomLevel, newZoomLevel) {
		var me = this,
		    bounds = this._getExpandedVisibleBounds(),
		    i;

		//Add all children of current clusters to map and remove those clusters from map
		this._topClusterLevel._recursively(bounds, previousZoomLevel, 0, function (c) {
			var startPos = c._latlng,
				markers = c._markers,
				m;

			if (c._isSingleParent() && previousZoomLevel + 1 === newZoomLevel) { //Immediately add the new child and remove us
				L.FeatureGroup.prototype.removeLayer.call(me, c);
				c._recursivelyAddChildrenToMap(null, newZoomLevel, bounds);
			} else {
				//Fade out old cluster
				c.setOpacity(0);
				c._recursivelyAddChildrenToMap(startPos, newZoomLevel, bounds);
			}

			//Remove all markers that aren't visible any more
			//TODO: Do we actually need to do this on the higher levels too?
			for (i = markers.length - 1; i >= 0; i--) {
				m = markers[i];
				if (!bounds.contains(m._latlng)) {
					L.FeatureGroup.prototype.removeLayer.call(me, m);
				}
			}

		});

		this._forceLayout();
		var j, n;

		//Update opacities
		me._topClusterLevel._recursivelyBecomeVisible(bounds, newZoomLevel);
		//TODO Maybe? Update markers in _recursivelyBecomeVisible
		for (j in me._layers) {
			n = me._layers[j];

			if (!(n instanceof L.MarkerCluster) && n._icon) {
				n.setOpacity(1);
			}
		}

		//update the positions of the just added clusters/markers
		me._topClusterLevel._recursively(bounds, previousZoomLevel, newZoomLevel, function (c) {
			c._recursivelyRestoreChildPositions(newZoomLevel);
		});

		//Remove the old clusters and close the zoom animation

		setTimeout(function () {
			//update the positions of the just added clusters/markers
			me._topClusterLevel._recursively(bounds, previousZoomLevel, 0, function (c) {
				L.FeatureGroup.prototype.removeLayer.call(me, c);
				c.setOpacity(1);
			});

			me._animationEnd();
		}, 200);
	},

	_animationZoomOut: function (previousZoomLevel, newZoomLevel) {
		this._animationZoomOutSingle(this._topClusterLevel, previousZoomLevel - 1, newZoomLevel);

		//Need to add markers for those that weren't on the map before but are now
		this._topClusterLevel._recursivelyAddChildrenToMap(null, newZoomLevel, this._getExpandedVisibleBounds());
		//Remove markers that were on the map before but won't be now
		this._topClusterLevel._recursivelyRemoveChildrenFromMap(this._currentShownBounds, previousZoomLevel, this._getExpandedVisibleBounds());
	},
	_animationZoomOutSingle: function (cluster, previousZoomLevel, newZoomLevel) {
		var bounds = this._getExpandedVisibleBounds();

		//Animate all of the markers in the clusters to move to their cluster center point
		cluster._recursivelyAnimateChildrenInAndAddSelfToMap(bounds, previousZoomLevel + 1, newZoomLevel);

		var me = this;

		//Update the opacity (If we immediately set it they won't animate)
		this._forceLayout();
		cluster._recursivelyBecomeVisible(bounds, newZoomLevel);

		//TODO: Maybe use the transition timing stuff to make this more reliable
		//When the animations are done, tidy up
		setTimeout(function () {

			//This cluster stopped being a cluster before the timeout fired
			if (cluster._childCount === 1) {
				var m = cluster._markers[0];
				//If we were in a cluster animation at the time then the opacity and position of our child could be wrong now, so fix it
				m.setLatLng(m.getLatLng());
				m.setOpacity(1);
			} else {
				cluster._recursively(bounds, newZoomLevel, 0, function (c) {
					c._recursivelyRemoveChildrenFromMap(bounds, previousZoomLevel + 1);
				});
			}
			me._animationEnd();
		}, 200);
	},
	_animationAddLayer: function (layer, newCluster) {
		var me = this;

		L.FeatureGroup.prototype.addLayer.call(this, layer);
		if (newCluster !== layer) {
			if (newCluster._childCount > 2) { //Was already a cluster

				newCluster._updateIcon();
				this._forceLayout();
				this._animationStart();

				layer._setPos(this._map.latLngToLayerPoint(newCluster.getLatLng()));
				layer.setOpacity(0);

				setTimeout(function () {
					L.FeatureGroup.prototype.removeLayer.call(me, layer);
					layer.setOpacity(1);

					me._animationEnd();
				}, 200);

			} else { //Just became a cluster
				this._forceLayout();

				me._animationStart();
				me._animationZoomOutSingle(newCluster, this._map.getMaxZoom(), this._map.getZoom());
			}
		}
	},

	//Force a browser layout of stuff in the map
	// Should apply the current opacity and location to all elements so we can update them again for an animation
	_forceLayout: function () {
		//In my testing this works, infact offsetWidth of any element seems to work.
		//Could loop all this._layers and do this for each _icon if it stops working

		L.Util.falseFn(document.body.offsetWidth);
	}
});


L.MarkerCluster = L.Marker.extend({
	initialize: function (group, zoom, a, b) {

		L.Marker.prototype.initialize.call(this, a ? (a._cLatLng || a.getLatLng()) : new L.LatLng(0, 0), { icon: this });


		this._group = group;
		this._zoom = zoom;

		this._markers = [];
		this._childClusters = [];
		this._childCount = 0;
		this._iconNeedsUpdate = true;

		this._bounds = new L.LatLngBounds();

		if (a) {
			this._addChild(a);
		}
		if (b) {
			this._addChild(b);
		}
	},

	//Recursively retrieve all child markers of this cluster
	getAllChildMarkers: function (storageArray) {
		storageArray = storageArray || [];

		for (var i = this._childClusters.length - 1; i >= 0; i--) {
			this._childClusters[i].getAllChildMarkers(storageArray);
		}

		for (var j = this._markers.length - 1; j >= 0; j--) {
			storageArray.push(this._markers[j]);
		}

		return storageArray;
	},

	//Returns the count of how many child markers we have
	getChildCount: function () {
		return this._childCount;
	},

	//Zoom to the extents of this cluster
	zoomToBounds: function () {
		this._group._map.fitBounds(this._bounds);
	},

	getBounds: function () {
		var bounds = new L.LatLngBounds();
		bounds.extend(this._bounds);
		return bounds;
	},

	_updateIcon: function () {
		this._iconNeedsUpdate = true;
		if (this._icon) {
			this.setIcon(this);
		}
	},

	//Cludge for Icon, we pretend to be an icon for performance
	createIcon: function () {
		if (this._iconNeedsUpdate) {
			this._iconObj = this._group.options.iconCreateFunction(this);
			this._iconNeedsUpdate = false;
		}
		return this._iconObj.createIcon();
	},
	createShadow: function () {
		return this._iconObj.createShadow();
	},


	_addChild: function (new1, isNotificationFromChild) {

		this._iconNeedsUpdate = true;
		this._expandBounds(new1);

		if (new1 instanceof L.MarkerCluster) {
			if (!isNotificationFromChild) {
				this._childClusters.push(new1);
				new1.__parent = this;
			}
			this._childCount += new1._childCount;
		} else {
			if (!isNotificationFromChild) {
				this._markers.push(new1);
			}
			this._childCount++;
		}

		if (this.__parent) {
			this.__parent._addChild(new1, true);
		}
	},

	//Expand our bounds and tell our parent to
	_expandBounds: function (marker) {
		var addedCount,
		    addedLatLng = marker._wLatLng || marker._latlng;

		if (marker instanceof L.MarkerCluster) {
			this._bounds.extend(marker._bounds);
			addedCount = marker._childCount;
		} else {
			this._bounds.extend(addedLatLng);
			addedCount = 1;
		}

		if (!this._cLatLng) {
			// when clustering, take position of the first point as the cluster center
			this._cLatLng = marker._cLatLng || addedLatLng;
		}

		// when showing clusters, take weighted average of all points as cluster center
		var totalCount = this._childCount + addedCount;

		//Calculate weighted latlng for display
		if (!this._wLatLng) {
			this._latlng = this._wLatLng = new L.LatLng(addedLatLng.lat, addedLatLng.lng);
		} else {
			this._wLatLng.lat = (addedLatLng.lat * addedCount + this._wLatLng.lat * this._childCount) / totalCount;
			this._wLatLng.lng = (addedLatLng.lng * addedCount + this._wLatLng.lng * this._childCount) / totalCount;
		}
	},

	//Set our markers position as given and add it to the map
	_addToMap: function (startPos) {
		if (startPos) {
			this._backupLatlng = this._latlng;
			this.setLatLng(startPos);
		}
		this._noHas = true;
		L.FeatureGroup.prototype.addLayer.call(this._group, this);
		delete this._noHas;
	},

	_recursivelyAnimateChildrenIn: function (bounds, center, maxZoom) {
		this._recursively(bounds, 0, maxZoom - 1,
			function (c) {
				var markers = c._markers,
					i, m;
				for (i = markers.length - 1; i >= 0; i--) {
					m = markers[i];

					//Only do it if the icon is still on the map
					if (m._icon) {
						m._setPos(center);
						m.setOpacity(0);
					}
				}
			},
			function (c) {
				var childClusters = c._childClusters,
					j, cm;
				for (j = childClusters.length - 1; j >= 0; j--) {
					cm = childClusters[j];
					if (cm._icon) {
						cm._setPos(center);
						cm.setOpacity(0);
					}
				}
			}
		);
	},

	_recursivelyAnimateChildrenInAndAddSelfToMap: function (bounds, previousZoomLevel, newZoomLevel) {
		this._recursively(bounds, newZoomLevel, 0,
			function (c) {
				c._recursivelyAnimateChildrenIn(bounds, c._group._map.latLngToLayerPoint(c.getLatLng()).round(), previousZoomLevel);

				//TODO: depthToAnimateIn affects _isSingleParent, if there is a multizoom we may/may not be.
				//As a hack we only do a animation free zoom on a single level zoom, if someone does multiple levels then we always animate
				if (c._isSingleParent() && previousZoomLevel - 1 === newZoomLevel) {
					c.setOpacity(1);
					c._recursivelyRemoveChildrenFromMap(bounds, previousZoomLevel); //Immediately remove our children as we are replacing them. TODO previousBounds not bounds
				} else {
					c.setOpacity(0);
				}

				c._addToMap();
			}
		);
	},

	_recursivelyBecomeVisible: function (bounds, zoomLevel) {
		this._recursively(bounds, 0, zoomLevel, null, function (c) {
			c.setOpacity(1);
		});
	},

	_recursivelyAddChildrenToMap: function (startPos, zoomLevel, bounds) {
		this._recursively(bounds, -1, zoomLevel,
			function (c) {
				if (zoomLevel === c._zoom) {
					return;
				}

				//Add our child markers at startPos (so they can be animated out)
				for (var i = c._markers.length - 1; i >= 0; i--) {
					var nm = c._markers[i];

					if (!bounds.contains(nm._latlng)) {
						continue;
					}

					if (startPos) {
						nm._backupLatlng = nm.getLatLng();

						nm.setLatLng(startPos);
						nm.setOpacity(0);
					}

					nm._noHas = true;
					L.FeatureGroup.prototype.addLayer.call(c._group, nm);
					delete nm._noHas;
				}
			},
			function (c) {
				c._addToMap(startPos);
			}
		);
	},

	_recursivelyRestoreChildPositions: function (zoomLevel) {
		//Fix positions of child markers
		for (var i = this._markers.length - 1; i >= 0; i--) {
			var nm = this._markers[i];
			if (nm._backupLatlng) {
				nm.setLatLng(nm._backupLatlng);
				delete nm._backupLatlng;
			}
		}

		if (zoomLevel - 1 === this._zoom) {
			//Reposition child clusters
			for (var j = this._childClusters.length - 1; j >= 0; j--) {
				this._childClusters[j]._restorePosition();
			}
		} else {
			for (var k = this._childClusters.length - 1; k >= 0; k--) {
				this._childClusters[k]._recursivelyRestoreChildPositions(zoomLevel);
			}
		}
	},

	_restorePosition: function () {
		if (this._backupLatlng) {
			this.setLatLng(this._backupLatlng);
			delete this._backupLatlng;
		}
	},

	//exceptBounds: If set, don't remove any markers/clusters in it
	_recursivelyRemoveChildrenFromMap: function (previousBounds, zoomLevel, exceptBounds) {
		var m, i;
		this._recursively(previousBounds, -1, zoomLevel - 1,
			function (c) {
				//Remove markers at every level
				for (i = c._markers.length - 1; i >= 0; i--) {
					m = c._markers[i];
					if (!exceptBounds || !exceptBounds.contains(m._latlng)) {
						L.FeatureGroup.prototype.removeLayer.call(c._group, m);
						m.setOpacity(1);
					}
				}
			},
			function (c) {
				//Remove child clusters at just the bottom level
				for (i = c._childClusters.length - 1; i >= 0; i--) {
					m = c._childClusters[i];
					if (!exceptBounds || !exceptBounds.contains(m._latlng)) {
						if (!L.FeatureGroup.prototype.hasLayer || L.FeatureGroup.prototype.hasLayer.call(c._group, m)) {
							L.FeatureGroup.prototype.removeLayer.call(c._group, m);
						}
						m.setOpacity(1);
					}
				}
			}
		);
	},

	//Run the given functions recursively to this and child clusters
	// boundsToApplyTo: a L.LatLngBounds representing the bounds of what clusters to recurse in to
	// zoomLevelToStart: zoom level to start running functions (inclusive)
	// zoomLevelToStop: zoom level to stop running functions (inclusive)
	// runAtEveryLevel: function that takes an L.MarkerCluster as an argument that should be applied on every level
	// runAtBottomLevel: function that takes an L.MarkerCluster as an argument that should be applied at only the bottom level
	_recursively: function (boundsToApplyTo, zoomLevelToStart, zoomLevelToStop, runAtEveryLevel, runAtBottomLevel) {
		var childClusters = this._childClusters,
		    zoom = this._zoom,
			i, c;

		if (zoomLevelToStart > zoom) { //Still going down to required depth, just recurse to child clusters
			for (i = childClusters.length - 1; i >= 0; i--) {
				c = childClusters[i];
				if (boundsToApplyTo.intersects(c._bounds)) {
					c._recursively(boundsToApplyTo, zoomLevelToStart, zoomLevelToStop, runAtEveryLevel, runAtBottomLevel);
				}
			}
		} else { //In required depth

			if (runAtEveryLevel) {
				runAtEveryLevel(this);
			}
			if (runAtBottomLevel && this._zoom === zoomLevelToStop) {
				runAtBottomLevel(this);
			}

			//TODO: This loop is almost the same as above
			if (zoomLevelToStop > zoom) {
				for (i = childClusters.length - 1; i >= 0; i--) {
					c = childClusters[i];
					if (boundsToApplyTo.intersects(c._bounds)) {
						c._recursively(boundsToApplyTo, zoomLevelToStart, zoomLevelToStop, runAtEveryLevel, runAtBottomLevel);
					}
				}
			}
		}
	},

	_recalculateBounds: function () {
		var markers = this._markers,
			childClusters = this._childClusters,
			i;

		this._bounds = new L.LatLngBounds();
		delete this._wLatLng;

		for (i = markers.length - 1; i >= 0; i--) {
			this._expandBounds(markers[i]);
		}
		for (i = childClusters.length - 1; i >= 0; i--) {
			this._expandBounds(childClusters[i]);
		}
	},


	//Returns true if we are the parent of only one cluster and that cluster is the same as us
	_isSingleParent: function () {
		//Don't need to check this._markers as the rest won't work if there are any
		return this._childClusters.length > 0 && this._childClusters[0]._childCount === this._childCount;
	}
});



L.DistanceGrid = function (cellSize) {
	this._cellSize = cellSize;
	this._sqCellSize = cellSize * cellSize;
	this._grid = {};
	this._objectPoint = { };
};

L.DistanceGrid.prototype = {

	addObject: function (obj, point) {
		var x = this._getCoord(point.x),
		    y = this._getCoord(point.y),
		    grid = this._grid,
		    row = grid[y] = grid[y] || {},
		    cell = row[x] = row[x] || [],
		    stamp = L.Util.stamp(obj);

		this._objectPoint[stamp] = point;

		cell.push(obj);
	},

	updateObject: function (obj, point) {
		this.removeObject(obj);
		this.addObject(obj, point);
	},

	//Returns true if the object was found
	removeObject: function (obj, point) {
		var x = this._getCoord(point.x),
		    y = this._getCoord(point.y),
		    grid = this._grid,
		    row = grid[y] = grid[y] || {},
		    cell = row[x] = row[x] || [],
		    i, len;

		delete this._objectPoint[L.Util.stamp(obj)];

		for (i = 0, len = cell.length; i < len; i++) {
			if (cell[i] === obj) {

				cell.splice(i, 1);

				if (len === 1) {
					delete row[x];
				}

				return true;
			}
		}

	},

	eachObject: function (fn, context) {
		var i, j, k, len, row, cell, removed,
		    grid = this._grid;

		for (i in grid) {
			row = grid[i];

			for (j in row) {
				cell = row[j];

				for (k = 0, len = cell.length; k < len; k++) {
					removed = fn.call(context, cell[k]);
					if (removed) {
						k--;
						len--;
					}
				}
			}
		}
	},

	getNearObject: function (point) {
		var x = this._getCoord(point.x),
		    y = this._getCoord(point.y),
		    i, j, k, row, cell, len, obj, dist,
		    objectPoint = this._objectPoint,
		    closestDistSq = this._sqCellSize,
		    closest = null;

		for (i = y - 1; i <= y + 1; i++) {
			row = this._grid[i];
			if (row) {

				for (j = x - 1; j <= x + 1; j++) {
					cell = row[j];
					if (cell) {

						for (k = 0, len = cell.length; k < len; k++) {
							obj = cell[k];
							dist = this._sqDist(objectPoint[L.Util.stamp(obj)], point);
							if (dist < closestDistSq) {
								closestDistSq = dist;
								closest = obj;
							}
						}
					}
				}
			}
		}
		return closest;
	},

	_getCoord: function (x) {
		return Math.floor(x / this._cellSize);
	},

	_sqDist: function (p, p2) {
		var dx = p2.x - p.x,
		    dy = p2.y - p.y;
		return dx * dx + dy * dy;
	}
};


/* Copyright (c) 2012 the authors listed at the following URL, and/or
the authors of referenced articles or incorporated external code:
http://en.literateprograms.org/Quickhull_(Javascript)?action=history&offset=20120410175256

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Retrieved from: http://en.literateprograms.org/Quickhull_(Javascript)?oldid=18434
*/

(function () {
	L.QuickHull = {
		getDistant: function (cpt, bl) {
			var vY = bl[1].lat - bl[0].lat,
				vX = bl[0].lng - bl[1].lng;
			return (vX * (cpt.lat - bl[0].lat) + vY * (cpt.lng - bl[0].lng));
		},


		findMostDistantPointFromBaseLine: function (baseLine, latLngs) {
			var maxD = 0,
				maxPt = null,
				newPoints = [],
				i, pt, d;

			for (i = latLngs.length - 1; i >= 0; i--) {
				pt = latLngs[i];
				d = this.getDistant(pt, baseLine);

				if (d > 0) {
					newPoints.push(pt);
				} else {
					continue;
				}

				if (d > maxD) {
					maxD = d;
					maxPt = pt;
				}

			}
			return { 'maxPoint': maxPt, 'newPoints': newPoints };
		},

		buildConvexHull: function (baseLine, latLngs) {
			var convexHullBaseLines = [],
				t = this.findMostDistantPointFromBaseLine(baseLine, latLngs);

			if (t.maxPoint) { // if there is still a point "outside" the base line
				convexHullBaseLines =
					convexHullBaseLines.concat(
						this.buildConvexHull([baseLine[0], t.maxPoint], t.newPoints)
					);
				convexHullBaseLines =
					convexHullBaseLines.concat(
						this.buildConvexHull([t.maxPoint, baseLine[1]], t.newPoints)
					);
				return convexHullBaseLines;
			} else {  // if there is no more point "outside" the base line, the current base line is part of the convex hull
				return [baseLine];
			}
		},

		getConvexHull: function (latLngs) {
			//find first baseline
			var maxLat = false, minLat = false,
				maxPt = null, minPt = null,
				i;

			for (i = latLngs.length - 1; i >= 0; i--) {
				var pt = latLngs[i];
				if (maxLat === false || pt.lat > maxLat) {
					maxPt = pt;
					maxLat = pt.lat;
				}
				if (minLat === false || pt.lat < minLat) {
					minPt = pt;
					minLat = pt.lat;
				}
			}
			var ch = [].concat(this.buildConvexHull([minPt, maxPt], latLngs),
								this.buildConvexHull([maxPt, minPt], latLngs));
			return ch;
		}
	};
}());

L.MarkerCluster.include({
	getConvexHull: function () {
		var childMarkers = this.getAllChildMarkers(),
			points = [],
			hullLatLng = [],
			hull, p, i;

		for (i = childMarkers.length - 1; i >= 0; i--) {
			p = childMarkers[i].getLatLng();
			points.push(p);
		}

		hull = L.QuickHull.getConvexHull(points);

		for (i = hull.length - 1; i >= 0; i--) {
			hullLatLng.push(hull[i][0]);
		}

		return hullLatLng;
	}
});

//This code is 100% based on https://github.com/jawj/OverlappingMarkerSpiderfier-Leaflet
//Huge thanks to jawj for implementing it first to make my job easy :-)

L.MarkerCluster.include({

	_2PI: Math.PI * 2,
	_circleFootSeparation: 25, //related to circumference of circle
	_circleStartAngle: Math.PI / 6,

	_spiralFootSeparation:  28, //related to size of spiral (experiment!)
	_spiralLengthStart: 11,
	_spiralLengthFactor: 5,

	_circleSpiralSwitchover: 9, //show spiral instead of circle from this marker count upwards.
								// 0 -> always spiral; Infinity -> always circle

	spiderfy: function () {
		if (this._group._spiderfied === this || this._group._inZoomAnimation) {
			return;
		}

		var childMarkers = this.getAllChildMarkers(),
			group = this._group,
			map = group._map,
			center = map.latLngToLayerPoint(this._latlng),
			positions;

		this._group._unspiderfy();
		this._group._spiderfied = this;

		//TODO Maybe: childMarkers order by distance to center

		if (childMarkers.length >= this._circleSpiralSwitchover) {
			positions = this._generatePointsSpiral(childMarkers.length, center);
		} else {
			center.y += 10; //Otherwise circles look wrong
			positions = this._generatePointsCircle(childMarkers.length, center);
		}

		this._animationSpiderfy(childMarkers, positions);
	},

	unspiderfy: function (zoomDetails) {
		/// <param Name="zoomDetails">Argument from zoomanim if being called in a zoom animation or null otherwise</param>
		if (this._group._inZoomAnimation) {
			return;
		}
		this._animationUnspiderfy(zoomDetails);

		this._group._spiderfied = null;
	},

	_generatePointsCircle: function (count, centerPt) {
		var circumference = this._group.options.spiderfyDistanceMultiplier * this._circleFootSeparation * (2 + count),
			legLength = circumference / this._2PI,  //radius from circumference
			angleStep = this._2PI / count,
			res = [],
			i, angle;

		res.length = count;

		for (i = count - 1; i >= 0; i--) {
			angle = this._circleStartAngle + i * angleStep;
			res[i] = new L.Point(centerPt.x + legLength * Math.cos(angle), centerPt.y + legLength * Math.sin(angle))._round();
		}

		return res;
	},

	_generatePointsSpiral: function (count, centerPt) {
		var legLength = this._group.options.spiderfyDistanceMultiplier * this._spiralLengthStart,
			separation = this._group.options.spiderfyDistanceMultiplier * this._spiralFootSeparation,
			lengthFactor = this._group.options.spiderfyDistanceMultiplier * this._spiralLengthFactor,
			angle = 0,
			res = [],
			i;

		res.length = count;

		for (i = count - 1; i >= 0; i--) {
			angle += separation / legLength + i * 0.0005;
			res[i] = new L.Point(centerPt.x + legLength * Math.cos(angle), centerPt.y + legLength * Math.sin(angle))._round();
			legLength += this._2PI * lengthFactor / angle;
		}
		return res;
	},

	_noanimationUnspiderfy: function () {
		var group = this._group,
			map = group._map,
			childMarkers = this.getAllChildMarkers(),
			m, i;

		this.setOpacity(1);
		for (i = childMarkers.length - 1; i >= 0; i--) {
			m = childMarkers[i];

			L.FeatureGroup.prototype.removeLayer.call(group, m);

			if (m._preSpiderfyLatlng) {
				m.setLatLng(m._preSpiderfyLatlng);
				delete m._preSpiderfyLatlng;
			}
			m.setZIndexOffset(0);

			if (m._spiderLeg) {
				map.removeLayer(m._spiderLeg);
				delete m._spiderLeg;
			}
		}
	}
});

L.MarkerCluster.include(!L.DomUtil.TRANSITION ? {
	//Non Animated versions of everything
	_animationSpiderfy: function (childMarkers, positions) {
		var group = this._group,
			map = group._map,
			i, m, leg, newPos;

		for (i = childMarkers.length - 1; i >= 0; i--) {
			newPos = map.layerPointToLatLng(positions[i]);
			m = childMarkers[i];

			m._preSpiderfyLatlng = m._latlng;
			m.setLatLng(newPos);
			m.setZIndexOffset(1000000); //Make these appear on top of EVERYTHING

			L.FeatureGroup.prototype.addLayer.call(group, m);


			leg = new L.Polyline([this._latlng, newPos], { weight: 1.5, color: '#222' });
			map.addLayer(leg);
			m._spiderLeg = leg;
		}
		this.setOpacity(0.3);
		group.fire('spiderfied');
	},

	_animationUnspiderfy: function () {
		this._noanimationUnspiderfy();
	}
} : {
	//Animated versions here
	SVG_ANIMATION: (function () {
		return document.createElementNS('http://www.w3.org/2000/svg', 'animate').toString().indexOf('SVGAnimate') > -1;
	}()),

	_animationSpiderfy: function (childMarkers, positions) {
		var me = this,
			group = this._group,
			map = group._map,
			thisLayerPos = map.latLngToLayerPoint(this._latlng),
			i, m, leg, newPos;

		//Add markers to map hidden at our center point
		for (i = childMarkers.length - 1; i >= 0; i--) {
			m = childMarkers[i];

			m.setZIndexOffset(1000000); //Make these appear on top of EVERYTHING
			m.setOpacity(0);

			m._noHas = true;
			L.FeatureGroup.prototype.addLayer.call(group, m);
			delete m._noHas;

			m._setPos(thisLayerPos);
		}

		group._forceLayout();
		group._animationStart();

		var initialLegOpacity = L.Path.SVG ? 0 : 0.3,
			xmlns = L.Path.SVG_NS;


		for (i = childMarkers.length - 1; i >= 0; i--) {
			newPos = map.layerPointToLatLng(positions[i]);
			m = childMarkers[i];

			//Move marker to new position
			m._preSpiderfyLatlng = m._latlng;
			m.setLatLng(newPos);
			m.setOpacity(1);


			//Add Legs.
			leg = new L.Polyline([me._latlng, newPos], { weight: 1.5, color: '#222', opacity: initialLegOpacity });
			map.addLayer(leg);
			m._spiderLeg = leg;

			//Following animations don't work for canvas
			if (!L.Path.SVG || !this.SVG_ANIMATION) {
				continue;
			}

			//How this works:
			//http://stackoverflow.com/questions/5924238/how-do-you-animate-an-svg-path-in-ios
			//http://dev.opera.com/articles/view/advanced-svg-animation-techniques/

			//Animate length
			var length = leg._path.getTotalLength();
			leg._path.setAttribute("stroke-dasharray", length + "," + length);

			var anim = document.createElementNS(xmlns, "animate");
			anim.setAttribute("attributeName", "stroke-dashoffset");
			anim.setAttribute("begin", "indefinite");
			anim.setAttribute("from", length);
			anim.setAttribute("to", 0);
			anim.setAttribute("dur", 0.25);
			leg._path.appendChild(anim);
			anim.beginElement();

			//Animate opacity
			anim = document.createElementNS(xmlns, "animate");
			anim.setAttribute("attributeName", "stroke-opacity");
			anim.setAttribute("attributeName", "stroke-opacity");
			anim.setAttribute("begin", "indefinite");
			anim.setAttribute("from", 0);
			anim.setAttribute("to", 0.5);
			anim.setAttribute("dur", 0.25);
			leg._path.appendChild(anim);
			anim.beginElement();
		}
		me.setOpacity(0.3);

		//Set the opacity of the spiderLegs back to their correct value
		// The animations above override this until they complete.
		// If the initial opacity of the spiderlegs isn't 0 then they appear before the animation starts.
		if (L.Path.SVG) {
			this._group._forceLayout();

			for (i = childMarkers.length - 1; i >= 0; i--) {
				m = childMarkers[i]._spiderLeg;

				m.options.opacity = 0.5;
				m._path.setAttribute('stroke-opacity', 0.5);
			}
		}

		setTimeout(function () {
			group._animationEnd();
			group.fire('spiderfied');
		}, 200);
	},

	_animationUnspiderfy: function (zoomDetails) {
		var group = this._group,
			map = group._map,
			thisLayerPos = zoomDetails ? map._latLngToNewLayerPoint(this._latlng, zoomDetails.zoom, zoomDetails.center) : map.latLngToLayerPoint(this._latlng),
			childMarkers = this.getAllChildMarkers(),
			svg = L.Path.SVG && this.SVG_ANIMATION,
			m, i, a;

		group._animationStart();

		//Make us visible and bring the child markers back in
		this.setOpacity(1);
		for (i = childMarkers.length - 1; i >= 0; i--) {
			m = childMarkers[i];

			//Marker was added to us after we were spidified
			if (!m._preSpiderfyLatlng) {
				continue;
			}

			//Fix up the location to the real one
			m.setLatLng(m._preSpiderfyLatlng);
			delete m._preSpiderfyLatlng;
			//Hack override the location to be our center
			m._setPos(thisLayerPos);

			m.setOpacity(0);

			//Animate the spider legs back in
			if (svg) {
				a = m._spiderLeg._path.childNodes[0];
				a.setAttribute('to', a.getAttribute('from'));
				a.setAttribute('from', 0);
				a.beginElement();

				a = m._spiderLeg._path.childNodes[1];
				a.setAttribute('from', 0.5);
				a.setAttribute('to', 0);
				a.setAttribute('stroke-opacity', 0);
				a.beginElement();

				m._spiderLeg._path.setAttribute('stroke-opacity', 0);
			}
		}

		setTimeout(function () {
			//If we have only <= one child left then that marker will be shown on the map so don't remove it!
			var stillThereChildCount = 0;
			for (i = childMarkers.length - 1; i >= 0; i--) {
				m = childMarkers[i];
				if (m._spiderLeg) {
					stillThereChildCount++;
				}
			}


			for (i = childMarkers.length - 1; i >= 0; i--) {
				m = childMarkers[i];

				if (!m._spiderLeg) { //Has already been unspiderfied
					continue;
				}


				m.setOpacity(1);
				m.setZIndexOffset(0);

				if (stillThereChildCount > 1) {
					L.FeatureGroup.prototype.removeLayer.call(group, m);
				}

				map.removeLayer(m._spiderLeg);
				delete m._spiderLeg;
			}
			group._animationEnd();
		}, 200);
	}
});


L.MarkerClusterGroup.include({
	//The MarkerCluster currently spiderfied (if any)
	_spiderfied: null,

	_spiderfierOnAdd: function () {
		this._map.on('click', this._unspiderfyWrapper, this);

		if (this._map.options.zoomAnimation) {
			this._map.on('zoomstart', this._unspiderfyZoomStart, this);
		} else {
			//Browsers without zoomAnimation don't fire zoomstart
			this._map.on('zoomend', this._unspiderfyWrapper, this);
		}

		if (L.Path.SVG && !L.Browser.touch) {
			this._map._initPathRoot();
			//Needs to happen in the pageload, not after, or animations don't work in webkit
			//  http://stackoverflow.com/questions/8455200/svg-animate-with-dynamically-added-elements
			//Disable on touch browsers as the animation messes up on a touch zoom and isn't very noticable
		}
	},

	_spiderfierOnRemove: function () {
		this._map.off('click', this._unspiderfyWrapper, this);
		this._map.off('zoomstart', this._unspiderfyZoomStart, this);
		this._map.off('zoomanim', this._unspiderfyZoomAnim, this);

		this._unspiderfy(); //Ensure that markers are back where they should be
	},


	//On zoom start we add a zoomanim handler so that we are guaranteed to be last (after markers are animated)
	//This means we can define the animation they do rather than Markers doing an animation to their actual location
	_unspiderfyZoomStart: function () {
		if (!this._map) { //May have been removed from the map by a zoomEnd handler
			return;
		}

		this._map.on('zoomanim', this._unspiderfyZoomAnim, this);
	},
	_unspiderfyZoomAnim: function (zoomDetails) {
		//Wait until the first zoomanim after the user has finished touch-zooming before running the animation
		if (L.DomUtil.hasClass(this._map._mapPane, 'leaflet-touching')) {
			return;
		}

		this._map.off('zoomanim', this._unspiderfyZoomAnim, this);
		this._unspiderfy(zoomDetails);
	},


	_unspiderfyWrapper: function () {
		/// <summary>_unspiderfy but passes no arguments</summary>
		this._unspiderfy();
	},

	_unspiderfy: function (zoomDetails) {
		if (this._spiderfied) {
			this._spiderfied.unspiderfy(zoomDetails);
		}
	},

	_noanimationUnspiderfy: function () {
		if (this._spiderfied) {
			this._spiderfied._noanimationUnspiderfy();
		}
	},

	//If the given layer is currently being spiderfied then we unspiderfy it so it isn't on the map anymore etc
	_unspiderfyLayer: function (layer) {
		if (layer._spiderLeg) {
			L.FeatureGroup.prototype.removeLayer.call(this, layer);

			layer.setOpacity(1);
			//Position will be fixed up immediately in _animationUnspiderfy
			layer.setZIndexOffset(0);

			this._map.removeLayer(layer._spiderLeg);
			delete layer._spiderLeg;
		}
	}
});




}(this));