/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.github.wolfie.refresher.Refresher;
import com.vaadin.annotations.JavaScript;
import com.vaadin.annotations.StyleSheet;
import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.server.Extension;
import com.vaadin.server.Page;
import com.vaadin.server.Sizeable;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.AbsoluteLayout;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.Table;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.VerticalSplitPanel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opennms.features.topology.api.HasExtraComponents;
import org.opennms.features.topology.api.VerticesUpdateManager;
import org.opennms.features.topology.api.topo.DefaultVertexRef;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.topology.plugins.browsers.AlarmTable;
import org.opennms.features.topology.plugins.browsers.NodeTable;
import org.opennms.features.topology.plugins.browsers.SelectionAwareTable;
import org.opennms.features.vaadin.nodemaps.internal.HttpServletRequestVaadinImpl;
import org.opennms.features.vaadin.nodemaps.internal.MapWidgetComponent;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.VaadinApplicationContextImpl;
import org.opennms.web.api.OnmsHeaderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Title(value="OpenNMS Node Maps")
@Theme(value="opennms")
@JavaScript(value={"//maps.google.com/maps/api/js?sensor=false", "gwt/public/leaflet-0.5.1/leaflet-src.js", "gwt/public/openlayers/OpenLayers.js", "gwt/public/markercluster/leaflet.markercluster-src.js"})
@StyleSheet(value={"gwt/public/markercluster/MarkerCluster.css", "gwt/public/markercluster/MarkerCluster.Default.css", "gwt/public/node-maps.css"})
public class NodeMapsApplication
extends UI {
    private static final Logger LOG = LoggerFactory.getLogger(NodeMapsApplication.class);
    private static final int REFRESH_INTERVAL = 10000;
    private VerticalLayout m_rootLayout;
    private VerticalLayout m_layout;
    private MapWidgetComponent m_mapWidgetComponent;
    private OnmsHeaderProvider m_headerProvider;
    private String m_headerHtml;
    private VaadinRequest m_request;
    private AlarmTable m_alarmTable;
    private NodeTable m_nodeTable;

    public void setHeaderProvider(OnmsHeaderProvider headerProvider) {
        this.m_headerProvider = headerProvider;
    }

    public void setMapWidgetComponent(MapWidgetComponent mapWidgetComponent) {
        this.m_mapWidgetComponent = mapWidgetComponent;
    }

    public void setHeaderHtml(String headerHtml) {
        this.m_headerHtml = headerHtml;
    }

    public void setAlarmTable(AlarmTable table) {
        this.m_alarmTable = table;
    }

    public void setNodeTable(NodeTable table) {
        this.m_nodeTable = table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWidgetView() {
        if (this.m_layout != null) {
            VerticalLayout verticalLayout = this.m_layout;
            synchronized (verticalLayout) {
                this.m_layout.removeAllComponents();
                VerticalSplitPanel bottomLayoutBar = new VerticalSplitPanel();
                bottomLayoutBar.setFirstComponent((Component)this.m_mapWidgetComponent);
                bottomLayoutBar.setSplitPosition(70.0f, Sizeable.Unit.PERCENTAGE);
                bottomLayoutBar.setSizeFull();
                bottomLayoutBar.setSecondComponent(this.getTabSheet());
                this.m_layout.addComponent((Component)bottomLayoutBar);
                this.m_layout.markAsDirty();
            }
        } else {
            LOG.warn("updateWidgetView() called, but there's no layout yet!");
        }
    }

    private Component getTabSheet() {
        AbsoluteLayout bottomLayout = new AbsoluteLayout();
        bottomLayout.setSizeFull();
        final TabSheet tabSheet = new TabSheet();
        tabSheet.setSizeFull();
        for (final SelectionAwareTable view : new SelectionAwareTable[]{this.m_alarmTable, this.m_nodeTable}) {
            tabSheet.addTab((Component)view, view == this.m_alarmTable ? "Alarms" : "Nodes", null);
            try {
                Component[] extras = ((HasExtraComponents)view).getExtraComponents();
                if (extras != null && extras.length > 0) {
                    final HorizontalLayout extraControls = new HorizontalLayout();
                    extraControls.setHeight(32.0f, Sizeable.Unit.PIXELS);
                    extraControls.setSpacing(true);
                    for (Component component : extras) {
                        extraControls.addComponent(component);
                        extraControls.setComponentAlignment(component, Alignment.MIDDLE_RIGHT);
                    }
                    tabSheet.addSelectedTabChangeListener(new TabSheet.SelectedTabChangeListener(){

                        public void selectedTabChange(TabSheet.SelectedTabChangeEvent event) {
                            TabSheet source = (TabSheet)event.getSource();
                            if (source == tabSheet) {
                                if (source.getSelectedTab() == view) {
                                    extraControls.setVisible(true);
                                } else {
                                    extraControls.setVisible(false);
                                }
                            }
                        }
                    });
                    bottomLayout.addComponent((Component)extraControls, "top:0px;right:5px;z-index:100");
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            view.setSizeFull();
        }
        bottomLayout.addComponent((Component)tabSheet, "top: 0; left: 0; bottom: 0; right: 0;");
        return bottomLayout;
    }

    protected void init(VaadinRequest vaadinRequest) {
        this.m_request = vaadinRequest;
        LOG.debug("initializing");
        VaadinApplicationContextImpl context = new VaadinApplicationContextImpl();
        UI currentUI = UI.getCurrent();
        context.setSessionId(currentUI.getSession().getSession().getId());
        context.setUiId(currentUI.getUIId());
        context.setUsername(vaadinRequest.getRemoteUser());
        Assert.notNull((Object)this.m_alarmTable);
        Assert.notNull((Object)this.m_nodeTable);
        this.m_alarmTable.setVaadinApplicationContext((VaadinApplicationContext)context);
        EventProxy eventProxy = new EventProxy(){

            public <T> void fireEvent(T eventObject) {
                LOG.debug("got event: {}", eventObject);
                if (eventObject instanceof VerticesUpdateManager.VerticesUpdateEvent) {
                    VerticesUpdateManager.VerticesUpdateEvent event = (VerticesUpdateManager.VerticesUpdateEvent)eventObject;
                    ArrayList<Integer> nodeIds = new ArrayList<Integer>();
                    for (VertexRef ref : event.getVertexRefs()) {
                        if (!"nodes".equals(ref.getNamespace()) || ref.getId() == null) continue;
                        nodeIds.add(Integer.valueOf(ref.getId()));
                    }
                    NodeMapsApplication.this.m_mapWidgetComponent.setSelectedNodes(nodeIds);
                    return;
                }
                LOG.warn("Unsure how to deal with event: {}", eventObject);
            }

            public <T> void addPossibleEventConsumer(T possibleEventConsumer) {
                LOG.debug("(ignoring) add consumer: {}", possibleEventConsumer);
            }
        };
        this.m_alarmTable.setEventProxy(eventProxy);
        this.m_nodeTable.setEventProxy(eventProxy);
        this.createMapPanel(vaadinRequest.getParameter("search"));
        this.createRootLayout();
        this.addRefresher();
    }

    private void createMapPanel(String searchString) {
        this.m_mapWidgetComponent.setSearchString(searchString);
        this.m_mapWidgetComponent.setSizeFull();
    }

    private void createRootLayout() {
        this.m_rootLayout = new VerticalLayout();
        this.m_rootLayout.setSizeFull();
        this.m_rootLayout.addStyleName("root-layout");
        this.setContent((Component)this.m_rootLayout);
        this.addHeader();
        this.addContentLayout();
    }

    private void addContentLayout() {
        this.m_layout = new VerticalLayout();
        this.m_layout.setSizeFull();
        this.m_rootLayout.addComponent((Component)this.m_layout);
        this.m_rootLayout.setExpandRatio((Component)this.m_layout, 1.0f);
        this.updateWidgetView();
    }

    private void addHeader() {
        if (this.m_headerProvider != null) {
            try {
                URL pageUrl = Page.getCurrent().getLocation().toURL();
                this.setHeaderHtml(this.m_headerProvider.getHeaderHtml((HttpServletRequest)new HttpServletRequestVaadinImpl(this.m_request, pageUrl)));
            }
            catch (Exception e) {
                LOG.error("failed to get header HTML for request " + this.m_request.getPathInfo(), e.getCause());
            }
        }
        if (this.m_headerHtml != null) {
            ByteArrayInputStream is = null;
            try {
                is = new ByteArrayInputStream(this.m_headerHtml.getBytes());
                CustomLayout headerLayout = new CustomLayout((InputStream)is);
                headerLayout.setWidth("100%");
                headerLayout.addStyleName("onmsheader");
                this.m_rootLayout.addComponent((Component)headerLayout);
            }
            catch (IOException e) {
                this.closeQuietly(is);
                LOG.debug("failed to get header layout data", (Throwable)e);
            }
        }
    }

    private void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException closeE) {
                LOG.debug("failed to close HTML input stream", (Throwable)closeE);
            }
        }
    }

    private void addRefresher() {
        Refresher refresher = new Refresher();
        refresher.setRefreshInterval(10000);
        this.addExtension((Extension)refresher);
    }

    public void refresh() {
        this.m_mapWidgetComponent.refresh();
    }

    public void setFocusedNodes(List<Integer> nodeIds) {
        for (SelectionAwareTable view : new SelectionAwareTable[]{this.m_alarmTable, this.m_nodeTable}) {
            if (view instanceof VerticesUpdateManager.VerticesUpdateListener) {
                SelectionAwareTable listener = view;
                HashSet<DefaultVertexRef> nodeSet = new HashSet<DefaultVertexRef>();
                for (Integer nodeId : nodeIds) {
                    nodeSet.add(new DefaultVertexRef("nodes", nodeId.toString(), null));
                }
                listener.verticesUpdated(new VerticesUpdateManager.VerticesUpdateEvent(nodeSet));
                if (view instanceof Table) {
                    SelectionAwareTable table = view;
                    table.refreshRowCache();
                    continue;
                }
                LOG.error("View {} is not a table!  I can't refresh it.", (Object)view);
                continue;
            }
            LOG.error("View {} is not a vertices update listener!", (Object)view);
        }
    }

    public String toString() {
        return "NodeMapsApplication@" + ((Object)((Object)this)).hashCode();
    }
}

