/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.geocoder.GeocoderException;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.geocoder.TemporaryGeocoderException;
import org.opennms.features.topology.api.geo.GeoAssetProvider;
import org.opennms.features.topology.api.topo.AbstractVertex;
import org.opennms.features.topology.api.topo.VertexRef;
import org.opennms.features.vaadin.nodemaps.internal.NodeMapComponent;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

public class MapWidgetComponent
extends NodeMapComponent
implements GeoAssetProvider {
    private static final long serialVersionUID = -6364929103619363239L;
    private static final Logger LOG = LoggerFactory.getLogger(MapWidgetComponent.class);
    private final ScheduledExecutorService m_executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, "NodeMapUpdater-Thread");
        }
    });
    private NodeDao m_nodeDao;
    private AssetRecordDao m_assetDao;
    private AlarmDao m_alarmDao;
    private GeocoderService m_geocoderService;
    private TransactionOperations m_transaction;
    private Map<Integer, NodeMapComponent.NodeEntry> m_activeNodes = new HashMap<Integer, NodeMapComponent.NodeEntry>();

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public AssetRecordDao getAssetRecordDao() {
        return this.m_assetDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetDao) {
        this.m_assetDao = assetDao;
    }

    public AlarmDao getAlarmDao() {
        return this.m_alarmDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public GeocoderService getGeocoderService() {
        return this.m_geocoderService;
    }

    public void setGeocoderService(GeocoderService geocoderService) {
        this.m_geocoderService = geocoderService;
    }

    public void setTransactionOperations(TransactionOperations tx) {
        this.m_transaction = tx;
    }

    public void init() {
        this.m_executor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                MapWidgetComponent.this.refreshNodeData();
            }
        }, 0L, 5L, TimeUnit.MINUTES);
    }

    public void refresh() {
        this.m_executor.schedule(new Runnable(){

            @Override
            public void run() {
                MapWidgetComponent.this.refreshNodeData();
            }
        }, 0L, TimeUnit.MINUTES);
    }

    public Collection<VertexRef> getNodesWithCoordinates() {
        ArrayList<VertexRef> nodes = new ArrayList<VertexRef>();
        for (Map.Entry<Integer, NodeMapComponent.NodeEntry> entry : this.m_activeNodes.entrySet()) {
            nodes.add((VertexRef)new AbstractVertex("nodes", entry.getKey().toString(), entry.getValue().getNodeLabel()));
        }
        return nodes;
    }

    private void refreshNodeData() {
        if (this.getNodeDao() == null) {
            LOG.warn("No node DAO!  Can't refresh node data.");
            return;
        }
        LOG.debug("Refreshing node data.");
        final CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        cb.alias("assetRecord", "asset");
        cb.orderBy("id").asc();
        final ArrayList updatedAssets = new ArrayList();
        final HashMap<Integer, NodeMapComponent.NodeEntry> nodes = new HashMap<Integer, NodeMapComponent.NodeEntry>();
        this.m_transaction.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                for (OnmsNode node : MapWidgetComponent.this.getNodeDao().findMatching(cb.toCriteria())) {
                    LOG.trace("processing node {}", (Object)node.getId());
                    OnmsAssetRecord assets = node.getAssetRecord();
                    if (assets == null || assets.getGeolocation() == null) continue;
                    OnmsGeolocation geolocation = assets.getGeolocation();
                    String addressString = geolocation.asAddressString();
                    Float longitude = geolocation.getLongitude();
                    Float latitude = geolocation.getLatitude();
                    if (longitude != null && latitude != null) {
                        if (longitude.floatValue() == Float.NEGATIVE_INFINITY || latitude.floatValue() == Float.NEGATIVE_INFINITY) continue;
                        nodes.put(node.getId(), new NodeMapComponent.NodeEntry(node));
                        continue;
                    }
                    if (addressString == null || "".equals(addressString)) continue;
                    LOG.debug("Node {} has an asset record with address \"{}\", but no coordinates.", new Object[]{node.getId(), addressString});
                    Coordinates coordinates = MapWidgetComponent.this.getCoordinates(addressString);
                    if (coordinates == null) {
                        LOG.debug("Node {} has an asset record with address, but we were unable to find valid coordinates.", (Object)node.getId());
                        continue;
                    }
                    geolocation.setLongitude(Float.valueOf(coordinates.getLongitude()));
                    geolocation.setLatitude(Float.valueOf(coordinates.getLatitude()));
                    updatedAssets.add(assets);
                    if (coordinates.getLongitude() == Float.NEGATIVE_INFINITY || coordinates.getLatitude() == Float.NEGATIVE_INFINITY) {
                        LOG.debug("Node {} has an asset record with address, but we were unable to find valid coordinates.", (Object)node.getId());
                        continue;
                    }
                    nodes.put(node.getId(), new NodeMapComponent.NodeEntry(node));
                }
                int lastId = -1;
                int unackedCount = 0;
                if (!nodes.isEmpty()) {
                    LOG.debug("getting alarms for nodes");
                    CriteriaBuilder ab = new CriteriaBuilder(OnmsAlarm.class);
                    ab.alias("node", "node");
                    ab.ge("severity", (Object)OnmsSeverity.WARNING);
                    ab.in("node.id", nodes.keySet());
                    ab.orderBy("node.id").asc();
                    ab.orderBy("severity").desc();
                    for (OnmsAlarm alarm : MapWidgetComponent.this.getAlarmDao().findMatching(ab.toCriteria())) {
                        int nodeId = alarm.getNodeId();
                        LOG.debug("nodeId = {}, lastId = {}, unackedCount = {}", new Object[]{nodeId, lastId, unackedCount});
                        if (nodeId != lastId) {
                            LOG.debug("  setting severity for node {} to {}", new Object[]{nodeId, alarm.getSeverity().getLabel()});
                            NodeMapComponent.NodeEntry nodeEntry = (NodeMapComponent.NodeEntry)nodes.get(nodeId);
                            nodeEntry.setSeverity(alarm.getSeverity());
                            if (lastId != -1) {
                                nodeEntry.setUnackedCount(unackedCount);
                                unackedCount = 0;
                            }
                        }
                        if (alarm.getAckUser() == null) {
                            ++unackedCount;
                        }
                        lastId = nodeId;
                    }
                }
                if (lastId != -1) {
                    ((NodeMapComponent.NodeEntry)nodes.get(lastId)).setUnackedCount(unackedCount);
                }
                LOG.debug("saving {} updated asset records to the database", (Object)updatedAssets.size());
                for (OnmsAssetRecord asset : updatedAssets) {
                    MapWidgetComponent.this.getAssetRecordDao().saveOrUpdate((Object)asset);
                }
            }
        });
        this.m_activeNodes = nodes;
        this.showNodes(nodes);
    }

    private Coordinates getCoordinates(String address) {
        Coordinates coordinates = null;
        try {
            coordinates = this.getGeocoderService().getCoordinates(address);
            if (coordinates == null) {
                coordinates = new Coordinates(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
            }
        }
        catch (TemporaryGeocoderException e) {
            LOG.debug("Failed to find coordinates for address '{}' due to a temporary failure.", (Object)address);
        }
        catch (GeocoderException e) {
            LOG.debug("Failed to find coordinates for address '{}'.", (Object)address);
            coordinates = new Coordinates(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        }
        return coordinates;
    }

    @Override
    public void setSearchString(String searchString) {
        this.getState().searchString = searchString;
    }
}

