/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui;

import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import com.vaadin.terminal.gwt.client.VConsole;
import java.util.List;
import java.util.ListIterator;
import org.discotools.gwt.leaflet.client.Options;
import org.discotools.gwt.leaflet.client.controls.IControl;
import org.discotools.gwt.leaflet.client.controls.zoom.Zoom;
import org.discotools.gwt.leaflet.client.crs.epsg.EPSG3857;
import org.discotools.gwt.leaflet.client.jsobject.JSObjectWrapper;
import org.discotools.gwt.leaflet.client.layers.ILayer;
import org.discotools.gwt.leaflet.client.layers.raster.TileLayer;
import org.discotools.gwt.leaflet.client.map.MapOptions;
import org.discotools.gwt.leaflet.client.types.LatLng;
import org.discotools.gwt.leaflet.client.types.LatLngBounds;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.Map;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.MarkerProvider;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.SearchConsumer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.IconCreateCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.NodeMarkerClusterCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.GoogleLayer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerClusterGroup;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerContainer;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerFilter;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControl;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.alarm.AlarmControlOptions;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.controls.search.SearchControl;

public class GWTMapWidget
extends Widget
implements MarkerProvider,
SearchConsumer {
    private final DivElement m_div = Document.get().createDivElement();
    private Map m_map;
    private ILayer m_layer;
    private MarkerContainer m_markers;
    private MarkerClusterGroup m_markerClusterGroup;
    private boolean m_firstUpdate = true;
    private int m_minimumSeverity = 0;
    private String m_searchString = "";
    private SearchControl m_searchControl;
    private MarkerFilter m_filter;

    public GWTMapWidget() {
        this.m_div.setId("gwt-map");
        this.m_div.getStyle().setWidth(100.0, Style.Unit.PCT);
        this.m_div.getStyle().setHeight(100.0, Style.Unit.PCT);
        this.setElement((Element)this.m_div);
        this.m_filter = new MarkerFilter(){

            @Override
            public boolean matches(NodeMarker marker) {
                String searchStringWithoutPrefix;
                if (marker.getSeverity() < GWTMapWidget.this.m_minimumSeverity) {
                    return false;
                }
                if (GWTMapWidget.this.m_searchString == null || "".equals(GWTMapWidget.this.m_searchString)) {
                    return true;
                }
                String searchString = GWTMapWidget.this.m_searchString.toLowerCase();
                for (String propertyName : marker.getTextPropertyNames()) {
                    String lowerPropertyName = propertyName.toLowerCase();
                    if (searchString.startsWith(lowerPropertyName + ":")) {
                        String searchStringWithoutPrefix2 = searchString.replaceFirst(lowerPropertyName + ":\\s*", "");
                        String propertyValue = marker.getProperty(propertyName);
                        return propertyValue != null && propertyValue.toLowerCase().contains(searchStringWithoutPrefix2);
                    }
                    if (!searchString.startsWith(lowerPropertyName + "=")) continue;
                    String searchStringWithoutPrefix3 = searchString.replaceFirst(lowerPropertyName + "=\\s*", "");
                    String propertyValue = marker.getProperty(propertyName);
                    return propertyValue != null && propertyValue.toLowerCase().equals(searchStringWithoutPrefix3);
                }
                if (searchString.startsWith("category:") || searchString.startsWith("categories:")) {
                    searchStringWithoutPrefix = searchString.replaceFirst("categor(ies|y):\\s*", "");
                    MatchType match = this.matchCategories(marker, searchStringWithoutPrefix);
                    return match != MatchType.NONE;
                }
                if (searchString.startsWith("category=") || searchString.startsWith("categories=")) {
                    searchStringWithoutPrefix = searchString.replaceFirst("categor(ies|y)=\\s*", "");
                    MatchType match = this.matchCategories(marker, searchStringWithoutPrefix);
                    return match == MatchType.EXACT;
                }
                for (String propertyName : marker.getTextPropertyNames()) {
                    String propertyValue;
                    String value = marker.getProperty(propertyName);
                    if (value == null || !(propertyValue = value.toLowerCase()).contains(searchString)) continue;
                    return true;
                }
                return this.matchCategories(marker, searchString) != MatchType.NONE;
            }

            private MatchType matchCategories(NodeMarker marker, String searchString) {
                JsArrayString categories = marker.getCategories();
                for (int i = 0; i < categories.length(); ++i) {
                    String category = categories.get(i).toLowerCase();
                    if (category.equals(searchString)) {
                        return MatchType.EXACT;
                    }
                    if (!category.contains(searchString)) continue;
                    return MatchType.SUBSTRING;
                }
                return MatchType.NONE;
            }
        };
        this.m_markers = new MarkerContainer(this.m_filter);
        VConsole.log((String)"GWTMapWidget initialized");
    }

    protected void onLoad() {
        super.onLoad();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new Command(){

            public void execute() {
                GWTMapWidget.this.initializeMap(GWTMapWidget.this.m_div.getId());
            }
        });
    }

    protected void onUnload() {
        this.destroyMap();
        super.onUnload();
    }

    private void initializeMap(String divId) {
        VConsole.log((String)"initializing map");
        this.createMap(divId);
        this.addTileLayer();
        this.addMarkerLayer();
        this.addSearchControl();
        this.addAlarmControl();
        this.addZoomControl();
        this.m_searchControl.focus();
        VConsole.log((String)"finished initializing map");
    }

    private void createGoogleLayer() {
        EPSG3857 projection = new EPSG3857();
        Options googleOptions = new Options();
        googleOptions.setProperty("crs", (JSObjectWrapper)projection);
        VConsole.log((String)"adding Google layer");
        this.m_layer = new GoogleLayer("SATELLITE", googleOptions);
        this.m_map.addLayer(this.m_layer, true);
    }

    private void createMap(String divId) {
        MapOptions options = new MapOptions();
        options.setCenter(new LatLng(0.0, 0.0));
        options.setProperty("zoomControl", false);
        options.setZoom(1);
        options.setMaxZoom(15);
        this.m_map = new Map(divId, options);
    }

    private void addTileLayer() {
        VConsole.log((String)"adding tile layer");
        String attribution = "Map data &copy; <a tabindex=\"-1\" href=\"http://openstreetmap.org\">OpenStreetMap</a> contributors, <a tabindex=\"-1\" href=\"http://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>, Tiles &copy; <a tabindex=\"-1\" href=\"http://www.mapquest.com/\" target=\"_blank\">MapQuest</a> <img src=\"http://developer.mapquest.com/content/osm/mq_logo.png\" />";
        String url = "http://otile{s}.mqcdn.com/tiles/1.0.0/{type}/{z}/{x}/{y}.png";
        Options tileOptions = new Options();
        tileOptions.setProperty("attribution", "Map data &copy; <a tabindex=\"-1\" href=\"http://openstreetmap.org\">OpenStreetMap</a> contributors, <a tabindex=\"-1\" href=\"http://creativecommons.org/licenses/by-sa/2.0/\">CC-BY-SA</a>, Tiles &copy; <a tabindex=\"-1\" href=\"http://www.mapquest.com/\" target=\"_blank\">MapQuest</a> <img src=\"http://developer.mapquest.com/content/osm/mq_logo.png\" />");
        tileOptions.setProperty("subdomains", "1234");
        tileOptions.setProperty("type", "osm");
        this.m_layer = new TileLayer("http://otile{s}.mqcdn.com/tiles/1.0.0/{type}/{z}/{x}/{y}.png", tileOptions);
        this.m_map.addLayer(this.m_layer, true);
    }

    private void addMarkerLayer() {
        VConsole.log((String)"adding marker cluster layer");
        Options markerClusterOptions = new Options();
        markerClusterOptions.setProperty("zoomToBoundsOnClick", false);
        markerClusterOptions.setProperty("iconCreateFunction", (JSObjectWrapper)new IconCreateCallback());
        this.m_markerClusterGroup = new MarkerClusterGroup(markerClusterOptions);
        NodeMarkerClusterCallback callback = new NodeMarkerClusterCallback();
        this.m_markerClusterGroup.on("clusterclick", callback);
        this.m_markerClusterGroup.on("clustertouchend", callback);
        this.m_map.addLayer((ILayer)this.m_markerClusterGroup);
    }

    private void addSearchControl() {
        VConsole.log((String)"adding search control");
        this.m_searchControl = new SearchControl(this, this.m_markers);
        this.m_map.addControl((IControl)this.m_searchControl);
    }

    private void addAlarmControl() {
        VConsole.log((String)"adding alarm control");
        AlarmControlOptions options = new AlarmControlOptions();
        options.setPosition("topleft");
        AlarmControl alarmControl = new AlarmControl(this, options);
        this.m_map.addControl((IControl)alarmControl);
    }

    private void addZoomControl() {
        VConsole.log((String)"adding zoom control");
        this.m_map.addControl((IControl)new Zoom(new Options()));
    }

    public boolean markerShouldBeVisible(NodeMarker marker) {
        return this.m_filter.matches(marker);
    }

    @Override
    public boolean isSearching() {
        return this.m_searchString != null && !"".equals(this.m_searchString);
    }

    @Override
    public void refresh() {
        if (this.m_markers == null) {
            VConsole.log((String)"markers not initialized yet, skipping update");
            return;
        }
        if (this.m_markerClusterGroup == null) {
            VConsole.log((String)"marker cluster not initialized yet, skipping update");
            return;
        }
        this.m_markers.refresh();
        VConsole.log((String)("processing " + this.m_markers.size() + " markers for the node layer"));
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                GWTMapWidget.this.m_searchControl.refresh();
            }
        });
        Scheduler.get().scheduleIncremental(new Scheduler.RepeatingCommand(){
            final ListIterator<NodeMarker> m_markerIterator;
            {
                this.m_markerIterator = GWTMapWidget.this.m_markers.listIterator();
            }

            public boolean execute() {
                if (this.m_markerIterator.hasNext()) {
                    NodeMarker marker = this.m_markerIterator.next();
                    if (!GWTMapWidget.this.m_markerClusterGroup.hasLayer((ILayer)marker)) {
                        GWTMapWidget.this.m_markerClusterGroup.addLayer((ILayer)marker);
                    }
                    return true;
                }
                VConsole.log((String)"finished adding visible markers");
                return false;
            }
        });
        Scheduler.get().scheduleIncremental(new Scheduler.RepeatingCommand(){
            final ListIterator<NodeMarker> m_markerIterator;
            {
                this.m_markerIterator = GWTMapWidget.this.m_markers.getDisabledMarkers().listIterator();
            }

            public boolean execute() {
                if (this.m_markerIterator.hasNext()) {
                    NodeMarker marker = this.m_markerIterator.next();
                    marker.closePopup();
                    GWTMapWidget.this.m_markerClusterGroup.removeLayer((ILayer)marker);
                    return true;
                }
                VConsole.log((String)"finished removing filtered markers");
                return false;
            }
        });
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                if (GWTMapWidget.this.m_firstUpdate) {
                    LatLngBounds bounds = new LatLngBounds();
                    for (NodeMarker marker : GWTMapWidget.this.m_markers.getMarkers()) {
                        bounds.extend(marker.getLatLng());
                    }
                    for (NodeMarker marker : GWTMapWidget.this.m_markers.getDisabledMarkers()) {
                        bounds.extend(marker.getLatLng());
                    }
                    VConsole.log((String)("first update, zooming to " + bounds.toBBoxString()));
                    GWTMapWidget.this.m_map.fitBounds(bounds);
                    GWTMapWidget.this.m_firstUpdate = false;
                }
                VConsole.log((String)"finished updating marker cluster layer");
            }
        });
    }

    public void updateMarkerClusterLayer() {
        if (this.m_markerClusterGroup == null) {
            VConsole.log((String)"marker cluster not initialized yet, skipping update");
            return;
        }
        VConsole.log((String)"clearing existing markers");
        this.m_markerClusterGroup.clearLayers();
        this.refresh();
    }

    @Override
    public List<NodeMarker> getMarkers() {
        return this.m_markers.getMarkers();
    }

    public void setMarkers(List<NodeMarker> markers) {
        this.m_markers.setMarkers(markers);
    }

    @Override
    public int getMinimumSeverity() {
        return this.m_minimumSeverity;
    }

    @Override
    public void setMinimumSeverity(int minSeverity) {
        this.m_minimumSeverity = minSeverity;
    }

    @Override
    public String getSearchString() {
        return this.m_searchString;
    }

    @Override
    public void setSearchString(String searchString) {
        this.m_searchString = searchString;
    }

    @Override
    public void clearSearch() {
        this.m_minimumSeverity = 0;
        this.m_searchString = "";
    }

    private final void destroyMap() {
        this.m_markerClusterGroup.clearLayers();
        this.m_map.removeLayer((ILayer)this.m_markerClusterGroup);
        this.m_map.removeLayer(this.m_layer);
        this.m_map = null;
    }

    private static enum MatchType {
        NONE,
        SUBSTRING,
        EXACT;

    }
}

