/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client;

import com.google.gwt.core.client.JsArrayString;
import org.discotools.gwt.leaflet.client.Options;
import org.discotools.gwt.leaflet.client.jsobject.JSObject;
import org.discotools.gwt.leaflet.client.marker.Marker;
import org.discotools.gwt.leaflet.client.types.LatLng;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.SearchResult;

public class NodeMarker
extends Marker {
    public NodeMarker(LatLng latLng) {
        super(latLng, new Options());
    }

    public NodeMarker(JSObject element) {
        super(element);
    }

    public void putProperty(String key, String value) {
        this.getJSObject().setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.getJSObject().getPropertyAsString(key);
    }

    public String[] getTextPropertyNames() {
        JsArrayString nativeNames = this.getNativePropertyNames(this.getJSObject());
        String[] names = new String[nativeNames.length()];
        for (int i = 0; i < nativeNames.length(); ++i) {
            names[i] = nativeNames.get(i);
        }
        return names;
    }

    private native JsArrayString getNativePropertyNames(JSObject var1);

    public JsArrayString getCategories() {
        JSObject property = this.getJSObject().getProperty("categories");
        if (property == null) {
            return (JsArrayString)JsArrayString.createArray().cast();
        }
        return (JsArrayString)property.cast();
    }

    public String getCategoriesAsString() {
        StringBuilder catBuilder = new StringBuilder();
        JsArrayString categories = this.getCategories();
        if (categories.length() > 0) {
            if (categories.length() == 1) {
                catBuilder.append("Category: ");
            } else {
                catBuilder.append("Categories: ");
            }
            for (int i = 0; i < categories.length(); ++i) {
                catBuilder.append(categories.get(i));
                if (i == categories.length() - 1) continue;
                catBuilder.append(", ");
            }
        }
        return catBuilder.toString();
    }

    public void setCategories(String[] categories) {
        JsArrayString array = (JsArrayString)JsArrayString.createArray().cast();
        for (String category : categories) {
            array.push(category);
        }
        JSObject jsObject = (JSObject)array.cast();
        this.getJSObject().setProperty("categories", jsObject);
    }

    public Integer getNodeId() {
        String id = this.getProperty("nodeId");
        return id == null ? null : Integer.valueOf(id);
    }

    public String getNodeLabel() {
        return this.getProperty("nodeLabel");
    }

    public String getForeignSource() {
        return this.getProperty("foreignSource");
    }

    public String getForeignId() {
        return this.getProperty("foreignId");
    }

    public String getIpAddress() {
        return this.getProperty("ipAddress");
    }

    public String getSeverityLabel() {
        return this.getProperty("severityLabel");
    }

    public String getDescription() {
        return this.getProperty("description");
    }

    public String getMaintContract() {
        return this.getProperty("maintcontract");
    }

    public int getSeverity() {
        String severity = this.getProperty("severity");
        return severity == null ? 0 : Integer.valueOf(severity);
    }

    public Integer getUnackedCount() {
        String count = this.getProperty("unackedCount");
        return count == null ? 0 : Integer.valueOf(count);
    }

    public final String toString() {
        return "Feature[lat=" + this.getLatLng().lat() + ",lon=" + this.getLatLng().lng() + ",label=" + this.getNodeLabel() + "]";
    }

    public JSObject toSearchResult() {
        return SearchResult.create(this.getNodeLabel(), this.getLatLng());
    }
}

