/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal.gwt.client.event;

import com.vaadin.terminal.gwt.client.VConsole;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.discotools.gwt.leaflet.client.jsobject.JSObject;
import org.discotools.gwt.leaflet.client.popup.Popup;
import org.discotools.gwt.leaflet.client.popup.PopupImpl;
import org.discotools.gwt.leaflet.client.popup.PopupOptions;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.Map;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.NodeMarker;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.MarkerClusterEvent;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.event.MarkerClusterEventCallback;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.MarkerCluster;

public class NodeMarkerClusterCallback
implements MarkerClusterEventCallback {
    private static final String TARGET_NONE = "";
    private static final String TARGET_BLANK = "target=\"_blank\"";

    @Override
    public final void run(MarkerClusterEvent event) {
        StringBuilder sb = new StringBuilder();
        MarkerCluster cluster = event.getMarkerCluster();
        List<NodeMarker> markers = cluster.getAllChildMarkers();
        VConsole.log((String)("Clicked, processing " + markers.size() + " markers."));
        Collections.sort(markers, new NodeMarkerComparator());
        if (markers.size() == 1) {
            NodeMarker marker = markers.get(0);
            sb.append("<div class=\"node-marker-single\">");
            sb.append(NodeMarkerClusterCallback.getPopupTextForMarker(marker));
            sb.append("</div>");
        } else {
            StringBuilder nodeBuilder = new StringBuilder();
            int unacked = 0;
            for (NodeMarker marker : markers) {
                unacked += marker.getUnackedCount().intValue();
                nodeBuilder.append("<tr class=\"node-marker-" + marker.getSeverityLabel() + "\">");
                nodeBuilder.append("<td class=\"node-marker-label\">");
                nodeBuilder.append("<a class=\"node\" href=\"element/node.jsp?node=").append(marker.getNodeId()).append("\" >").append(marker.getNodeLabel()).append("</a>");
                nodeBuilder.append("</td>");
                nodeBuilder.append("<td class=\"node-marker-ipaddress\">");
                nodeBuilder.append(marker.getIpAddress());
                nodeBuilder.append("</td>");
                nodeBuilder.append("<td class=\"node-marker-severity severity " + marker.getSeverityLabel() + "\">");
                nodeBuilder.append("<a href=\"alarm/list.htm?sortby=id&acktype=unack&limit=20&filter=node%3D").append(marker.getNodeId()).append("\" target=\"_blank\">").append(marker.getSeverityLabel()).append("</a>");
                nodeBuilder.append("</td>");
                nodeBuilder.append("</tr>");
            }
            sb.append("<div class=\"node-marker-multiple\">");
            sb.append("<h2># of nodes: ").append(markers.size()).append(" ");
            sb.append("(").append(unacked).append(" Unacknowledged Alarms)");
            sb.append("</h2>");
            sb.append("<table class=\"node-marker-list\">").append((CharSequence)nodeBuilder).append("</table>");
            sb.append("</div>");
        }
        PopupOptions options = new PopupOptions();
        options.setMaxWidth(500);
        options.setProperty("maxHeight", 250);
        options.setProperty("className", "node-marker-popup");
        Popup popup = new Popup(options);
        popup.setContent(sb.toString());
        popup.setLatLng(cluster.getLatLng());
        Map map = new Map(cluster.getGroup().getMapObject());
        VConsole.log((String)("current zoom: " + map.getZoom() + ", max zoom: " + map.getMaxZoom()));
        if (map.getZoom() == map.getMaxZoom()) {
            VConsole.log((String)"at max zoom, skipping popup");
        } else {
            PopupImpl.openOn((JSObject)popup.getJSObject(), (JSObject)cluster.getGroup().getMapObject());
        }
    }

    public static String getPopupTextForMarker(NodeMarker marker) {
        StringBuilder sb = new StringBuilder();
        sb.append("<h2>Node <a class=\"node\" href=\"element/node.jsp?node=").append(marker.getNodeId()).append("\" >").append(marker.getNodeLabel()).append("</a></h2>");
        sb.append("<p>");
        sb.append("Description: ").append(marker.getDescription()).append("<br/>");
        sb.append("Maint.&nbsp;Contract: ").append(marker.getMaintContract()).append("<br/>");
        sb.append("IP Address: ").append(marker.getIpAddress()).append("<br/>");
        sb.append("Severity: ").append("<a class=\"severity " + marker.getSeverityLabel() + "\" href=\"alarm/list.htm?sortby=id&acktype=unack&limit=20&filter=node%3D").append(marker.getNodeId()).append("\" target=\"_blank\">").append(marker.getSeverityLabel()).append("</a>");
        String categoryString = marker.getCategoriesAsString();
        if (categoryString.length() > 0) {
            sb.append("<br/>");
            sb.append(categoryString);
        }
        sb.append("</p>");
        return sb.toString();
    }

    private static final class NodeMarkerComparator
    implements Comparator<NodeMarker> {
        static final int BEFORE = -1;
        static final int EQUAL = 0;
        static final int AFTER = 1;

        private NodeMarkerComparator() {
        }

        @Override
        public int compare(NodeMarker left, NodeMarker right) {
            if (left == right) {
                return 0;
            }
            if (left.getSeverity() != right.getSeverity()) {
                return left.getSeverity() > right.getSeverity() ? -1 : 1;
            }
            if (left.getNodeLabel() != right.getNodeLabel()) {
                if (left.getNodeLabel() == null) {
                    return 1;
                }
                if (right.getNodeLabel() == null) {
                    return -1;
                }
                return left.getNodeLabel().toLowerCase().compareTo(right.getNodeLabel().toLowerCase());
            }
            if (left.getNodeId() != right.getNodeId()) {
                if (left.getNodeId() == null) {
                    return 1;
                }
                if (right.getNodeId() == null) {
                    return -1;
                }
                return left.getNodeId().compareTo(right.getNodeId());
            }
            return 0;
        }
    }
}

