/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.nodemaps.internal;

import com.vaadin.terminal.PaintException;
import com.vaadin.terminal.PaintTarget;
import com.vaadin.ui.ClientWidget;
import com.vaadin.ui.VerticalLayout;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.geocoder.Coordinates;
import org.opennms.features.geocoder.GeocoderException;
import org.opennms.features.geocoder.GeocoderService;
import org.opennms.features.vaadin.nodemaps.internal.gwt.client.ui.VMapWidget;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.AssetRecordDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionOperations;

@ClientWidget(value=VMapWidget.class)
public class MapWidgetComponent
extends VerticalLayout {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final long serialVersionUID = 2L;
    private NodeDao m_nodeDao;
    private AssetRecordDao m_assetDao;
    private AlarmDao m_alarmDao;
    private GeocoderService m_geocoderService;
    private Logger m_log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TransactionOperations m_transactionOperations;
    private String m_searchString;

    public MapWidgetComponent() {
    }

    public MapWidgetComponent(NodeDao nodeDao, AssetRecordDao assetDao, AlarmDao alarmDao, GeocoderService geocoder) {
        this.m_nodeDao = nodeDao;
        this.m_assetDao = assetDao;
        this.m_alarmDao = alarmDao;
        this.m_geocoderService = geocoder;
    }

    public void paintContent(PaintTarget target) throws PaintException {
        super.paintContent(target);
        if (this.m_nodeDao == null) {
            return;
        }
        this.m_log.debug("getting nodes");
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        cb.alias("assetRecord", "asset");
        cb.orderBy("id").asc();
        HashMap<Integer, NodeEntry> nodes = new HashMap<Integer, NodeEntry>();
        final ArrayList<OnmsAssetRecord> updatedAssets = new ArrayList<OnmsAssetRecord>();
        for (OnmsNode node : this.m_nodeDao.findMatching(cb.toCriteria())) {
            this.m_log.trace("processing node {}", (Object)node.getId());
            OnmsAssetRecord assets = node.getAssetRecord();
            if (assets == null || assets.getGeolocation() == null) continue;
            OnmsGeolocation geolocation = assets.getGeolocation();
            String addressString = geolocation.asAddressString();
            Float longitude = geolocation.getLongitude();
            Float latitude = geolocation.getLatitude();
            if (longitude != null && latitude != null) {
                if (longitude.floatValue() == Float.NEGATIVE_INFINITY || latitude.floatValue() == Float.NEGATIVE_INFINITY) continue;
                nodes.put(node.getId(), new NodeEntry(node));
                continue;
            }
            if (addressString == null || "".equals(addressString)) continue;
            this.m_log.debug("Node {} has an asset record with address \"{}\", but no coordinates.", new Object[]{node.getId(), addressString});
            Coordinates coordinates = this.getCoordinates(addressString);
            geolocation.setLongitude(Float.valueOf(coordinates.getLongitude()));
            geolocation.setLatitude(Float.valueOf(coordinates.getLatitude()));
            updatedAssets.add(assets);
            if (coordinates.getLongitude() == Float.NEGATIVE_INFINITY || coordinates.getLatitude() == Float.NEGATIVE_INFINITY) {
                this.m_log.debug("Node {} has an asset record with address, but we were unable to find valid coordinates.", (Object)node.getId());
                continue;
            }
            nodes.put(node.getId(), new NodeEntry(node));
        }
        int lastId = -1;
        int unackedCount = 0;
        if (!nodes.isEmpty()) {
            this.m_log.debug("getting alarms for nodes");
            CriteriaBuilder ab = new CriteriaBuilder(OnmsAlarm.class);
            ab.alias("node", "node");
            ab.ge("severity", (Object)OnmsSeverity.WARNING);
            ab.in("node.id", nodes.keySet());
            ab.orderBy("node.id").asc();
            ab.orderBy("severity").desc();
            for (OnmsAlarm alarm : this.m_alarmDao.findMatching(ab.toCriteria())) {
                int nodeId = alarm.getNodeId();
                this.m_log.debug("nodeId = {}, lastId = {}, unackedCount = {}", new Object[]{nodeId, lastId, unackedCount});
                if (nodeId != lastId) {
                    this.m_log.debug("  setting severity for node {} to {}", new Object[]{nodeId, alarm.getSeverity().getLabel()});
                    ((NodeEntry)nodes.get(nodeId)).setSeverity(alarm.getSeverity());
                    if (lastId != -1) {
                        ((NodeEntry)nodes.get(nodeId)).setUnackedCount(unackedCount);
                        unackedCount = 0;
                    }
                }
                if (alarm.getAckUser() == null) {
                    ++unackedCount;
                }
                lastId = nodeId;
            }
        }
        if (lastId != -1) {
            ((NodeEntry)nodes.get(lastId)).setUnackedCount(unackedCount);
        }
        this.m_log.debug("pushing nodes to the UI");
        if (this.m_searchString != null) {
            target.addAttribute("initialSearchString", this.m_searchString);
        }
        target.startTag("nodes");
        for (NodeEntry node : nodes.values()) {
            node.visit(target);
        }
        target.endTag("nodes");
        this.m_log.debug("saving {} updated asset records to the database", (Object)updatedAssets.size());
        this.m_transactionOperations.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                for (OnmsAssetRecord asset : updatedAssets) {
                    MapWidgetComponent.this.m_assetDao.saveOrUpdate((Object)asset);
                }
            }
        });
    }

    private Coordinates getCoordinates(String address) {
        Coordinates coordinates = null;
        try {
            coordinates = this.m_geocoderService.getCoordinates(address);
        }
        catch (GeocoderException e) {
            this.m_log.debug("Failed to find coordinates for address {}", (Object)address);
        }
        if (coordinates == null) {
            coordinates = new Coordinates(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        }
        return coordinates;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetDao) {
        this.m_assetDao = assetDao;
    }

    public void setAlarmDao(AlarmDao alarmDao) {
        this.m_alarmDao = alarmDao;
    }

    public void setGeocoderService(GeocoderService geocoderService) {
        this.m_geocoderService = geocoderService;
    }

    public void setTransactionOperation(TransactionOperations tx) {
        this.m_transactionOperations = tx;
    }

    public void setSearchString(String searchString) {
        this.m_searchString = searchString;
    }

    public static final class NodeEntry {
        private Float m_longitude;
        private Float m_latitude;
        private Integer m_nodeId;
        private String m_nodeLabel;
        private String m_foreignSource;
        private String m_foreignId;
        private String m_description;
        private String m_maintcontract;
        private String m_ipAddress;
        private OnmsSeverity m_severity = OnmsSeverity.NORMAL;
        private List<String> m_categories = new ArrayList<String>();
        private int m_unackedCount = 0;

        public NodeEntry(OnmsNode node) {
            OnmsAssetRecord assetRecord = node.getAssetRecord();
            if (assetRecord != null && assetRecord.getGeolocation() != null) {
                OnmsGeolocation geolocation = assetRecord.getGeolocation();
                this.m_longitude = geolocation.getLongitude();
                this.m_latitude = geolocation.getLatitude();
            }
            this.m_nodeId = node.getId();
            this.m_nodeLabel = node.getLabel();
            this.m_foreignSource = node.getForeignSource();
            this.m_foreignId = node.getForeignId();
            if (assetRecord != null) {
                this.m_maintcontract = assetRecord.getMaintcontract();
                this.m_description = assetRecord.getDescription();
            }
            if (node.getPrimaryInterface() != null) {
                this.m_ipAddress = InetAddressUtils.str((InetAddress)node.getPrimaryInterface().getIpAddress());
            }
            if (node.getCategories() != null && node.getCategories().size() > 0) {
                for (OnmsCategory category : node.getCategories()) {
                    this.m_categories.add(category.getName());
                }
            }
        }

        public void setSeverity(OnmsSeverity severity) {
            this.m_severity = severity;
        }

        public void visit(PaintTarget target) throws PaintException {
            target.startTag("node");
            target.addAttribute("longitude", this.m_longitude.floatValue());
            target.addAttribute("latitude", this.m_latitude.floatValue());
            if (this.m_nodeId != null) {
                target.addAttribute("nodeId", this.m_nodeId.toString());
            }
            if (this.m_nodeLabel != null) {
                target.addAttribute("nodeLabel", this.m_nodeLabel);
            }
            if (this.m_foreignSource != null) {
                target.addAttribute("foreignSource", this.m_foreignSource);
            }
            if (this.m_foreignId != null) {
                target.addAttribute("foreignId", this.m_foreignId);
            }
            if (this.m_ipAddress != null) {
                target.addAttribute("ipAddress", this.m_ipAddress);
            }
            if (this.m_description != null) {
                target.addAttribute("description", this.m_description);
            }
            if (this.m_maintcontract != null) {
                target.addAttribute("maintcontract", this.m_maintcontract);
            }
            target.addAttribute("severityLabel", this.m_severity.getLabel());
            target.addAttribute("severity", this.m_severity.getId());
            target.addAttribute("unackedCount", String.valueOf(this.m_unackedCount));
            if (this.m_categories.size() > 0) {
                target.addAttribute("categories", (Object[])this.m_categories.toArray(EMPTY_STRING_ARRAY));
            }
            target.endTag("node");
        }

        public void setUnackedCount(int unackedCount) {
            this.m_unackedCount = unackedCount;
        }
    }
}

