/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Window;
import com.vaadin.v7.shared.ui.label.ContentMode;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.ProgressBar;
import com.vaadin.v7.ui.VerticalLayout;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.JobManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class ProgressWindow
extends Window {
    private final ProgressBar progress = new ProgressBar();
    private final VerticalLayout layout = new VerticalLayout();
    private final Label label = new Label("Long running process", ContentMode.HTML);

    public ProgressWindow(final JobManager jobManager) {
        this.setCaption("processing...");
        this.setModal(true);
        this.setResizable(false);
        this.setClosable(false);
        this.setWidth(400.0f, Sizeable.Unit.PIXELS);
        this.setHeight(150.0f, Sizeable.Unit.PIXELS);
        Button cancelButton = UIHelper.createButton((String)"cancel", (String)"Cancels the current process", null, (Button.ClickListener)new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                jobManager.cancelAllJobs();
                ((JmxConfigGeneratorUI)UIHelper.getCurrent(JmxConfigGeneratorUI.class)).updateView(UiState.ServiceConfigurationView);
            }
        });
        this.progress.setIndeterminate(true);
        HorizontalLayout contentLayout = new HorizontalLayout(new Component[]{this.progress, this.label});
        contentLayout.setSpacing(true);
        this.layout.addComponent((Component)contentLayout);
        this.layout.addComponent((Component)cancelButton);
        this.layout.setComponentAlignment((Component)cancelButton, Alignment.BOTTOM_RIGHT);
        this.layout.setSpacing(true);
        this.layout.setMargin(true);
        this.setContent((Component)this.layout);
        this.center();
        this.addCloseListener(new Window.CloseListener(){

            public void windowClose(Window.CloseEvent e) {
                ((JmxConfigGeneratorUI)UIHelper.getCurrent(JmxConfigGeneratorUI.class)).setPollInterval(-1);
            }
        });
    }

    public void attach() {
        super.attach();
        ((JmxConfigGeneratorUI)UIHelper.getCurrent(JmxConfigGeneratorUI.class)).setPollInterval(250);
    }

    public void setLabelText(String label) {
        label = String.format("%s. This may take a while ...", label);
        this.label.setValue(label);
    }
}

