/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.vaadin.v7.data.Item;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectableBeanItemContainer;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectableItem;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectionChangedListener;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectionValueChangedListener;
import org.opennms.features.vaadin.jmxconfiggenerator.data.UiModel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.AttributesContainerCache;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.DefaultNameProvider;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.IconUpdater;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansContentPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansTree;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MbeansHierarchicalContainer;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.NameProvider;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.SelectionManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.ValidationManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.ValidationResult;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.vaadin.core.ConfirmationDialog;

public class MBeansController
implements SelectionManager,
NameProvider,
SelectionValueChangedListener {
    private final IconUpdater iconUpdater = new IconUpdater();
    private final MbeansHierarchicalContainer mbeansContainer = new MbeansHierarchicalContainer();
    private final ValidationManager validationManager = new ValidationManager(this, this);
    private final Selection currentSelection = new Selection();
    private final List<SelectionChangedListener> selectionChangedListener = new ArrayList<SelectionChangedListener>();
    private final List<SelectionValueChangedListener> selectionValueChangedListeners = new ArrayList<SelectionValueChangedListener>();
    private final Map<Class<?>, AttributesContainerCache> attributesContainerCacheMap = new HashMap();
    private final DefaultNameProvider defaultNameProvider = new DefaultNameProvider(this);
    private MBeansContentPanel mbeansContentPanel;
    private MBeansTree mbeansTree;

    public MBeansController() {
        this.attributesContainerCacheMap.put(Attrib.class, new AttributesContainerCache<Attrib, Mbean>(Attrib.class, new AttributesContainerCache.AttributeCollector<Attrib, Mbean>(){

            @Override
            public List<Attrib> getAttributes(Mbean outer) {
                return outer.getAttribList();
            }
        }));
        this.attributesContainerCacheMap.put(CompAttrib.class, new AttributesContainerCache<CompAttrib, Mbean>(CompAttrib.class, new AttributesContainerCache.AttributeCollector<CompAttrib, Mbean>(){

            @Override
            public List<CompAttrib> getAttributes(Mbean outer) {
                return outer.getCompAttribList();
            }
        }));
        this.attributesContainerCacheMap.put(CompMember.class, new AttributesContainerCache<CompMember, CompAttrib>(CompMember.class, new AttributesContainerCache.AttributeCollector<CompMember, CompAttrib>(){

            @Override
            public List<CompMember> getAttributes(CompAttrib outer) {
                return outer.getCompMemberList();
            }
        }));
        this.registerSelectionValueChangedListener(this);
    }

    public void registerSelectionChangedListener(SelectionChangedListener listener) {
        if (!this.selectionChangedListener.contains(listener)) {
            this.selectionChangedListener.add(listener);
        }
    }

    public void registerSelectionValueChangedListener(SelectionValueChangedListener listener) {
        if (!this.selectionValueChangedListeners.contains(listener)) {
            this.selectionValueChangedListeners.add(listener);
        }
    }

    private void fireTreeSelectionChanged(Selection currentSelection) {
        SelectionChangedListener.SelectionChangedEvent<Object> changeEvent = new SelectionChangedListener.SelectionChangedEvent<Object>(currentSelection.getItem(), currentSelection.getItemId(), currentSelection.getBean());
        for (SelectionChangedListener eachListener : this.selectionChangedListener) {
            eachListener.selectionChanged(changeEvent);
        }
    }

    public void fireSelectionValueChanged(Object bean, Object itemId, boolean selected) {
        SelectionValueChangedListener.SelectionValueChangedEvent event = new SelectionValueChangedListener.SelectionValueChangedEvent();
        event.setItemId(itemId);
        event.setNewValue(selected);
        event.setBean(bean);
        for (SelectionValueChangedListener eachListener : this.selectionValueChangedListeners) {
            eachListener.selectionValueChanged(event);
        }
    }

    public void setMbeansTree(MBeansTree mbeansTree) {
        this.mbeansTree = mbeansTree;
    }

    public void setMbeansContentPanel(MBeansContentPanel mbeansContentPanel) {
        this.mbeansContentPanel = mbeansContentPanel;
    }

    protected void selectItemInTree(final String itemId) {
        if (this.currentSelection.getItemId() != itemId) {
            if (this.mbeansContentPanel.isDirty()) {
                new ConfirmationDialog().withOkAction(new ConfirmationDialog.Action(){

                    public void execute(ConfirmationDialog window) {
                        MBeansController.this.mbeansContentPanel.discard();
                        MBeansController.this.currentSelection.update(itemId, MBeansController.this.mbeansContainer.getItem(itemId), MBeansController.this.mbeansContainer.getDataFor(itemId));
                        MBeansController.this.fireTreeSelectionChanged(MBeansController.this.currentSelection);
                    }
                }).withCancelAction(new ConfirmationDialog.Action(){

                    public void execute(ConfirmationDialog window) {
                        MBeansController.this.mbeansTree.select(MBeansController.this.currentSelection.getItemId());
                    }
                }).withOkLabel("yes").withCancelLabel("no").withCaption("Validation errors").withDescription("The current view contains validation errors.<br/>The values cannot be saved.<br/>If you continue, they are lost.<br/><br/>Do you want to switch selection?").open();
            } else {
                this.currentSelection.update(itemId, this.mbeansContainer.getItem(itemId), this.mbeansContainer.getDataFor(itemId));
                this.fireTreeSelectionChanged(this.currentSelection);
            }
        }
    }

    private void updateValidState(ValidationResult result) {
        Mbean parent;
        Collection<ValidationResult.ValidationError> validationErrors = result.getValidationErrors(Mbean.class);
        for (ValidationResult.ValidationError eachError : validationErrors) {
            this.updateValidState(eachError.getErrorObject(), false);
        }
        validationErrors = result.getValidationErrors(Attrib.class);
        for (ValidationResult.ValidationError eachError : validationErrors) {
            parent = (Mbean)this.attributesContainerCacheMap.get(Attrib.class).getParentFor(eachError.getErrorObject());
            this.updateValidState(parent, false);
        }
        validationErrors = result.getValidationErrors(CompMember.class);
        for (ValidationResult.ValidationError eachError : validationErrors) {
            parent = (CompAttrib)this.attributesContainerCacheMap.get(CompMember.class).getParentFor(eachError.getErrorObject());
            this.updateValidState(parent, false);
        }
        this.mbeansTree.markAsDirtyRecursive();
    }

    private void updateValidState(Object data, boolean valid) {
        String itemId = this.mbeansContainer.getItemIdFor(data);
        Item theItem = this.mbeansContainer.getItem(itemId);
        this.updateValidState(theItem, valid);
        if (!valid) {
            this.mbeansTree.expandItemsUpToParent(itemId);
        }
    }

    private void updateValidState(Item item, boolean valid) {
        if (item != null && !Objects.equals(item.getItemProperty((Object)"valid").getValue(), valid)) {
            item.getItemProperty((Object)"valid").setValue((Object)valid);
        }
    }

    protected void validateCurrentSelection() {
        this.updateValidState(this.currentSelection.bean, this.mbeansContentPanel.isValid());
        this.mbeansTree.markAsDirtyRecursive();
    }

    protected void handleSelectDeselect(Item item, Object itemId, boolean select) {
        this.handleSelectDeselect(item, select);
        this.handleSelectDeselectForSelectableBeanItemContainer(itemId, select);
        if (!this.mbeansContainer.hasChildren(itemId)) {
            return;
        }
        for (Object childItemId : this.mbeansContainer.getChildren(itemId)) {
            this.handleSelectDeselect(this.mbeansContainer.getItem(childItemId), childItemId, select);
        }
        this.validate();
    }

    void handleSelectDeselect(Item item, boolean selected) {
        item.getItemProperty((Object)"selected").setValue((Object)selected);
        this.iconUpdater.updateIcon(item, selected);
        if (!selected && item.getItemProperty((Object)"valid") != null) {
            this.updateValidState(item, true);
        }
    }

    private void handleSelectDeselectForSelectableBeanItemContainer(Object itemId, boolean select) {
        Object data = this.mbeansContainer.getDataFor((String)itemId);
        if (data instanceof Mbean) {
            SelectableBeanItemContainer<Attrib> attribContainer = this.getContainer(Attrib.class, data);
            attribContainer.selectAllItems(select);
        }
        if (data instanceof CompAttrib) {
            SelectableBeanItemContainer<CompMember> compMemberContainer = this.getContainer(CompMember.class, data);
            compMemberContainer.selectAllItems(select);
            this.forwardSelectionToCompAttribute(itemId, data, select);
        }
    }

    private void forwardSelectionToCompAttribute(Object itemId, Object data, boolean select) {
        if (data instanceof CompAttrib) {
            String parentItemId = (String)this.getMBeansHierarchicalContainer().getParent(itemId);
            Mbean parent = (Mbean)this.getMBeansHierarchicalContainer().getDataFor(parentItemId);
            ((SelectableItem)this.getContainer(CompAttrib.class, parent).getItem(data)).setSelected(select);
        }
    }

    protected <T, X> SelectableBeanItemContainer<T> getContainer(Class<T> type, X bean) {
        AttributesContainerCache containerCache = this.attributesContainerCacheMap.get(type);
        Objects.requireNonNull(containerCache);
        return containerCache.getContainer(bean);
    }

    protected MbeansHierarchicalContainer getMBeansHierarchicalContainer() {
        return this.mbeansContainer;
    }

    private <T, X> Collection<T> getSelectedAttributes(Class<T> type, X bean) {
        SelectableBeanItemContainer<T> container = this.getContainer(type, bean);
        return container.getSelectedAttributes();
    }

    @Override
    public void selectionValueChanged(SelectionValueChangedListener.SelectionValueChangedEvent selectionValueChangedEvent) {
        Object itemId = selectionValueChangedEvent.getItemId();
        Item item = this.mbeansContainer.getItem(itemId);
        if (item != null) {
            this.handleSelectDeselect(item, selectionValueChangedEvent.getNewValue());
            Object data = this.mbeansContainer.getDataFor((String)itemId);
            this.forwardSelectionToCompAttribute(itemId, data, selectionValueChangedEvent.getNewValue());
            this.validateCurrentSelection();
        }
    }

    @Override
    public Collection<Attrib> getSelectedAttributes(Mbean mbean) {
        return this.getSelectedAttributes(Attrib.class, mbean);
    }

    @Override
    public Collection<CompMember> getSelectedCompositeMembers(CompAttrib compAttrib) {
        return this.getSelectedAttributes(CompMember.class, compAttrib);
    }

    @Override
    public Collection<CompAttrib> getSelectedCompositeAttributes(Mbean mbean) {
        return this.getSelectedAttributes(CompAttrib.class, mbean);
    }

    @Override
    public Collection<Mbean> getSelectedMbeans() {
        return this.getMBeansHierarchicalContainer().getSelectedMbeans();
    }

    public void updateDataSource(UiModel newModel) {
        this.reset();
        this.mbeansContainer.updateDataSource(((JmxCollection)newModel.getRawModel().getJmxCollectionList().get(0)).getMbeans());
        this.mbeansTree.expandAllItems();
        this.mbeansTree.select(this.mbeansContainer.firstItemId());
        this.validate();
    }

    private void reset() {
        this.mbeansTree.setComponentError(null);
        this.currentSelection.reset();
        this.mbeansContentPanel.reset();
        for (AttributesContainerCache eachCache : this.attributesContainerCacheMap.values()) {
            eachCache.clear();
        }
    }

    private ValidationResult validate() {
        ValidationResult result = this.validationManager.validate(this.mbeansContainer);
        this.updateValidState(result);
        return result;
    }

    protected boolean isValid() {
        return this.validate().isValid();
    }

    @Override
    public Map<Object, String> getNamesMap() {
        return this.defaultNameProvider.getNamesMap();
    }

    private static class Selection {
        private Item item;
        private String itemId;
        private Object bean;

        private Selection() {
        }

        public String getItemId() {
            return this.itemId;
        }

        private Item getItem() {
            return this.item;
        }

        private void update(String itemId, Item item, Object bean) {
            this.itemId = itemId;
            this.item = item;
            this.bean = bean;
        }

        private void reset() {
            this.update(null, null, null);
        }

        private Object getBean() {
            return this.bean;
        }
    }
}

