/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.ButtonPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class ConfigView
extends VerticalLayout
implements View,
Button.ClickListener {
    private static final long serialVersionUID = -9179098093927051983L;
    private final ConfigForm configForm;
    private final JmxConfigGeneratorUI app;
    private final ButtonPanel buttonPanel;

    public ConfigView(JmxConfigGeneratorUI app) {
        this.app = app;
        this.configForm = new ConfigForm();
        this.buttonPanel = new ButtonPanel(this);
        this.buttonPanel.getPrevious().setVisible(false);
        this.addComponent((Component)this.configForm);
        this.addComponent((Component)this.buttonPanel);
        this.setExpandRatio((Component)this.configForm, 1.0f);
        this.setSizeFull();
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    public void buttonClick(Button.ClickEvent event) {
        if (this.buttonPanel.getNext().equals(event.getButton())) {
            if (!this.configForm.configFieldGroup.isValid()) {
                UIHelper.showValidationError((String)"There are still errors on this page. You cannot continue. Please check if all required fields have been filled.");
                return;
            }
            try {
                this.configForm.configFieldGroup.commit();
                this.app.updateView(UiState.MbeansDetection);
            }
            catch (FieldGroup.CommitException e) {
                UIHelper.showNotification((String)"An unexpected error occurred.");
            }
        }
    }

    private class ConfigForm
    extends FormLayout {
        private FieldGroup configFieldGroup = new FieldGroup();

        public ConfigForm() {
            this.configFieldGroup.setItemDataSource((Item)new BeanItem((Object)((JmxConfigGeneratorUI)((Object)UIHelper.getCurrent(JmxConfigGeneratorUI.class))).getUiModel().getServiceConfig()));
            this.initFields();
            this.updateAuthenticationFields(false);
            this.setImmediate(true);
            this.setMargin(true);
            this.setSpacing(true);
        }

        private void updateAuthenticationFields(boolean visible) throws Property.ReadOnlyException, Converter.ConversionException {
            this.configFieldGroup.getField((Object)"authenticate").setValue((Object)visible);
            this.configFieldGroup.getField((Object)"user").setVisible(visible);
            this.configFieldGroup.getField((Object)"password").setVisible(visible);
            if (!visible) {
                this.configFieldGroup.getField((Object)"user").setValue(null);
                this.configFieldGroup.getField((Object)"password").setValue(null);
            }
        }

        private void initFields() {
            CheckBox authenticateField = new CheckBox();
            authenticateField.setCaption("Authentication");
            authenticateField.setId("authenticate");
            authenticateField.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent event) {
                    ConfigForm.this.updateAuthenticationFields((Boolean)event.getProperty().getValue());
                }
            });
            authenticateField.setDescription("Connection requires authentication");
            TextField userField = new TextField();
            userField.setId("authenticateUser");
            userField.setCaption("User");
            userField.setNullRepresentation("");
            userField.setDescription("Username for JMX-RMI Authentication");
            PasswordField passwordField = new PasswordField();
            passwordField.setId("authenticatePassword");
            passwordField.setCaption("Password");
            passwordField.setNullRepresentation("");
            passwordField.setDescription("Password for JMX-RMI Authentication");
            TextField serviceNameField = new TextField();
            serviceNameField.setWidth(400.0f, Sizeable.Unit.PIXELS);
            serviceNameField.setCaption("Service name");
            serviceNameField.setNullRepresentation("");
            serviceNameField.setRequired(true);
            serviceNameField.setRequiredError("required");
            serviceNameField.addValidator((Validator)new RegexpValidator("^[A-Za-z0-9_-]+$", "You must specify a valid name. Allowed characters: (A-Za-z0-9_-)"));
            serviceNameField.setDescription("The service name of the JMX data collection config, e.g. cassandra, jboss, tomcat");
            TextField connectionTextField = new TextField();
            connectionTextField.setWidth(400.0f, Sizeable.Unit.PIXELS);
            connectionTextField.setCaption("Connection");
            connectionTextField.setRequired(true);
            connectionTextField.setRequiredError("required");
            connectionTextField.setDescription("The JMX connection string, e.g.: <hostname>:<port> OR service:jmx:<protocol>:<sap>");
            this.addComponent((Component)serviceNameField);
            this.addComponent((Component)connectionTextField);
            this.addComponent((Component)authenticateField);
            this.addComponent((Component)userField);
            this.addComponent((Component)passwordField);
            Field skipDefaultVMField = this.configFieldGroup.buildAndBind((Object)"skipDefaultVM");
            skipDefaultVMField.setCaption("Skip JVM MBeans");
            skipDefaultVMField.setId("skipDefaultVM");
            ((AbstractComponent)skipDefaultVMField).setDescription("Set to include/exclude default JavaVM MBeans");
            this.addComponent((Component)skipDefaultVMField);
            Field skipNonNumberField = this.configFieldGroup.buildAndBind((Object)"skipNonNumber");
            skipNonNumberField.setCaption("Skip non-number values");
            ((AbstractComponent)skipNonNumberField).setDescription("Set to include/exclude non-number values");
            this.addComponent((Component)skipNonNumberField);
            this.configFieldGroup.bind((Field)serviceNameField, (Object)"serviceName");
            this.configFieldGroup.bind((Field)connectionTextField, (Object)"connection");
            this.configFieldGroup.bind((Field)passwordField, (Object)"password");
            this.configFieldGroup.bind((Field)authenticateField, (Object)"authenticate");
            this.configFieldGroup.bind((Field)userField, (Object)"user");
        }
    }
}

