/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator;

import com.vaadin.annotations.Theme;
import com.vaadin.annotations.Title;
import com.vaadin.navigator.Navigator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.VaadinRequest;
import com.vaadin.ui.Component;
import com.vaadin.ui.Panel;
import com.vaadin.ui.SingleComponentContainer;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.jmxconfiggenerator.data.UiModel;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.DetectMBeansJob;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.GenerateConfigsJob;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.JobManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.ConfigView;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.HeaderPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.ProgressWindow;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.ResultView;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansView;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;

@Theme(value="jmxconfiggenerator")
@Title(value="JMX Configuration Generator")
public class JmxConfigGeneratorUI
extends UI {
    private HeaderPanel headerPanel;
    private Panel contentPanel;
    private ProgressWindow progressWindow;
    private UiModel model = new UiModel();
    private Navigator navigator;
    private final JobManager jobManager = new JobManager();

    protected void init(VaadinRequest request) {
        this.initHeaderPanel();
        this.initContentPanel();
        this.initMainLayout();
        this.initNavigator();
        this.updateView(UiState.ServiceConfigurationView);
    }

    private void initNavigator() {
        this.navigator = new Navigator((UI)this, (SingleComponentContainer)this.contentPanel);
        this.navigator.addView(UiState.ServiceConfigurationView.name(), (View)new ConfigView(this));
        this.navigator.addView(UiState.MbeansView.name(), (View)new MBeansView(this));
        this.navigator.addView(UiState.ResultView.name(), (View)new ResultView());
        this.navigator.addView(UiState.MbeansDetection.name(), (View)new Navigator.EmptyView());
        this.navigator.addView(UiState.ResultConfigGeneration.name(), (View)new Navigator.EmptyView());
        this.navigator.addViewChangeListener(new ViewChangeListener(){

            public boolean beforeViewChange(ViewChangeListener.ViewChangeEvent event) {
                JmxConfigGeneratorUI.this.hideProgressWindow();
                JmxConfigGeneratorUI.this.headerPanel.enter(event);
                UiState uiState = UiState.valueOf(event.getViewName());
                if (UiState.ServiceConfigurationView == uiState) {
                    UiModel newModel = new UiModel();
                    if (JmxConfigGeneratorUI.this.model != null) {
                        newModel.setServiceConfig(JmxConfigGeneratorUI.this.model.getServiceConfig());
                    }
                    JmxConfigGeneratorUI.this.model = newModel;
                }
                if (UiState.MbeansDetection == uiState) {
                    JmxConfigGeneratorUI.this.showProgressWindow(uiState.getDescription());
                    JmxConfigGeneratorUI.this.enqueue(new DetectMBeansJob(JmxConfigGeneratorUI.this.getUiModel().getServiceConfig()));
                    return false;
                }
                if (UiState.ResultConfigGeneration == uiState) {
                    JmxConfigGeneratorUI.this.showProgressWindow(uiState.getDescription());
                    JmxConfigGeneratorUI.this.enqueue(new GenerateConfigsJob(JmxConfigGeneratorUI.this.getUiModel()));
                    return false;
                }
                return true;
            }

            public void afterViewChange(ViewChangeListener.ViewChangeEvent event) {
            }
        });
    }

    private void enqueue(JobManager.Task task) {
        this.jobManager.enqueue(task);
    }

    private void initHeaderPanel() {
        this.headerPanel = new HeaderPanel();
    }

    private void initContentPanel() {
        this.contentPanel = new Panel();
        this.contentPanel.setSizeFull();
    }

    private void initMainLayout() {
        VerticalLayout layout = new VerticalLayout();
        layout.addComponent((Component)this.headerPanel);
        layout.addComponent((Component)this.contentPanel);
        layout.setSizeFull();
        layout.setExpandRatio((Component)this.contentPanel, 1.0f);
        this.setContent((Component)layout);
    }

    public void updateView(UiState uiState) {
        this.navigator.navigateTo(uiState.name());
    }

    private ProgressWindow getProgressWindow() {
        if (this.progressWindow == null) {
            this.progressWindow = new ProgressWindow(this.jobManager);
        }
        return this.progressWindow;
    }

    public void hideProgressWindow() {
        this.removeWindow(this.getProgressWindow());
        this.getProgressWindow().markAsDirtyRecursive();
    }

    private void showProgressWindow(String label) {
        this.getProgressWindow().setLabelText(label);
        this.addWindow(this.getProgressWindow());
        this.getProgressWindow().setVisible(true);
    }

    public void setRawModel(JmxDatacollectionConfig newModel) {
        this.model.setRawModel(newModel);
    }

    public UiModel getUiModel() {
        return this.model;
    }
}

