/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.jobs;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxDatacollectionConfiggenerator;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxHelper;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQueryException;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.opennms.features.jmxconfiggenerator.log.Slf4jLogAdapter;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.data.ServiceConfig;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.JobManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfig;
import org.opennms.netmgt.jmx.connection.JmxConnectionConfigBuilder;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.DefaultJmxConnector;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class DetectMBeansJob
implements JobManager.Task<JmxDatacollectionConfig> {
    private final Map<Class<?>, Filter<?>> filterMap;
    private final ServiceConfig config;

    public DetectMBeansJob(ServiceConfig config) {
        this.config = config;
        this.filterMap = new HashMap();
        this.filterMap.put(Mbean.class, new Filter<Mbean>(){

            @Override
            public void apply(Mbean input) {
                if (input.getName().contains("com.mchange.v2.c3p0.PooledDataSource")) {
                    input.setName("com.mchange.v2.c3p0.PooledDataSource");
                }
            }
        });
        this.filterMap.put(Attrib.class, new Filter<Attrib>(){

            @Override
            public void apply(Attrib input) {
                if ("0numFailedCheckinsDfltUsr_NAME_CRASH_AS_19_CHAR_VALUE".equals(input.getAlias()) && "numFailedCheckinsDefaultUser".equals(input.getName())) {
                    input.setAlias("1numFailChecDfltUsr");
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JmxDatacollectionConfig execute() throws JobManager.TaskRunException {
        JmxConnectionConfig connectionConfig = new JmxConnectionConfigBuilder().withUrl(this.config.getConnection()).withUsername(this.config.getUser()).withPassword(this.config.getPassword()).build();
        try (JmxServerConnectionWrapper connector = new DefaultJmxConnector().createConnection(connectionConfig);){
            JmxDatacollectionConfiggenerator jmxConfigGenerator = new JmxDatacollectionConfiggenerator((LogAdapter)new Slf4jLogAdapter(JmxDatacollectionConfiggenerator.class));
            JmxDatacollectionConfig generatedJmxConfigModel = jmxConfigGenerator.generateJmxConfigModel(connector.getMBeanServerConnection(), "anyservice", Boolean.valueOf(!this.config.isSkipDefaultVM()), Boolean.valueOf(this.config.isSkipNonNumber()), JmxHelper.loadInternalDictionary());
            this.applyFilters(generatedJmxConfigModel);
            JmxDatacollectionConfig jmxDatacollectionConfig = generatedJmxConfigModel;
            return jmxDatacollectionConfig;
        }
        catch (IOException | JMException | MBeanServerQueryException | JmxServerConnectionException e) {
            if (e instanceof UnknownHostException || e.getCause() instanceof UnknownHostException) {
                throw new JobManager.TaskRunException(String.format("Unknown host: %s", this.config.getConnection()), e);
            }
            if (!(e instanceof MalformedURLException)) {
                if (!(e.getCause() instanceof MalformedURLException)) throw new JobManager.TaskRunException("Error while retrieving MBeans from server.", e);
            }
            throw new JobManager.TaskRunException(String.format("Cannot create valid JMX Connection URL. Connection: '%s'", this.config.getConnection()), e);
        }
    }

    @Override
    public void onSuccess(JmxDatacollectionConfig generatedJmxConfigModel) {
        ((JmxConfigGeneratorUI)((Object)UIHelper.getCurrent(JmxConfigGeneratorUI.class))).setRawModel(generatedJmxConfigModel);
        ((JmxConfigGeneratorUI)((Object)UIHelper.getCurrent(JmxConfigGeneratorUI.class))).updateView(UiState.MbeansView);
    }

    @Override
    public void onError() {
    }

    private <T> void applyFilters(T input) {
        Filter<?> filter = this.filterMap.get(input.getClass());
        if (filter != null) {
            filter.apply(input);
        }
    }

    private void applyFilters(JmxDatacollectionConfig config) {
        for (Mbean eachMbean : ((JmxCollection)config.getJmxCollectionList().get(0)).getMbeans()) {
            this.applyFilters(eachMbean);
            for (Attrib eachAttrib : eachMbean.getAttribList()) {
                this.applyFilters(eachAttrib);
            }
            for (CompAttrib eachCompAttrib : eachMbean.getCompAttribList()) {
                this.applyFilters(eachCompAttrib);
                for (CompMember eachCompMember : eachCompAttrib.getCompMemberList()) {
                    this.applyFilters(eachCompMember);
                }
            }
        }
    }

    private static interface Filter<X> {
        public void apply(X var1);
    }
}

