/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation;

import com.vaadin.data.Validator;
import java.util.Collection;
import java.util.Objects;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MbeansHierarchicalContainer;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.NameProvider;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.SelectionManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.AttributeNameValidator;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.MaximumLengthValidator;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.NameValidator;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.UniqueAttributeNameValidator;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.ValidationResult;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.Mbean;

public class ValidationManager {
    protected final AttributeNameValidator attributeNameValidator;
    protected final MaximumLengthValidator attributeLengthValidator;
    protected final Validator attributeUniqueNameValidator;
    protected final NameProvider nameProvider;
    protected final SelectionManager selectionManager;

    public ValidationManager(NameProvider nameProvider, SelectionManager selectionManager) {
        Objects.requireNonNull(nameProvider);
        Objects.requireNonNull(selectionManager);
        this.nameProvider = nameProvider;
        this.selectionManager = selectionManager;
        this.attributeNameValidator = new AttributeNameValidator();
        this.attributeLengthValidator = new MaximumLengthValidator();
        this.attributeUniqueNameValidator = new UniqueAttributeNameValidator(nameProvider);
    }

    public ValidationResult validate(MbeansHierarchicalContainer container) {
        return this.validate(container.getSelectedMbeans());
    }

    private ValidationResult validate(Collection<Mbean> objectsToValidate) {
        ValidationResult result = new ValidationResult();
        for (Mbean eachMbean : objectsToValidate) {
            this.validate(eachMbean, result);
        }
        return result;
    }

    protected void validateInternal(Validator validator, Object itemId, Object value, ValidationResult result) {
        try {
            validator.validate(value);
        }
        catch (Validator.InvalidValueException ex) {
            result.add(itemId, ex);
        }
    }

    public void validate(Mbean mbean, ValidationResult validationResult) {
        this.validateInternal((Validator)new NameValidator(), mbean, mbean.getName(), validationResult);
        for (CompAttrib eachCompositeAttribute : this.selectionManager.getSelectedCompositeAttributes(mbean)) {
            this.validate(eachCompositeAttribute, validationResult);
        }
        for (Attrib eachAttribute : this.selectionManager.getSelectedAttributes(mbean)) {
            this.validate(eachAttribute, validationResult);
        }
    }

    public void validate(CompAttrib compAttrib, ValidationResult validationResult) {
        this.validateInternal((Validator)new NameValidator(), compAttrib, compAttrib.getName(), validationResult);
        for (CompMember eachCompMember : this.selectionManager.getSelectedCompositeMembers(compAttrib)) {
            this.validate(eachCompMember, validationResult);
        }
    }

    protected void validate(CompMember compMember, ValidationResult validationResult) {
        this.validateInternal((Validator)this.attributeNameValidator, compMember, compMember.getAlias(), validationResult);
        this.validateInternal((Validator)this.attributeLengthValidator, compMember, compMember.getAlias(), validationResult);
        this.validateInternal(this.attributeUniqueNameValidator, compMember, compMember.getAlias(), validationResult);
    }

    protected void validate(Attrib attrib, ValidationResult validationResult) {
        this.validateInternal((Validator)this.attributeNameValidator, attrib, attrib.getAlias(), validationResult);
        this.validateInternal((Validator)this.attributeLengthValidator, attrib, attrib.getAlias(), validationResult);
        this.validateInternal(this.attributeUniqueNameValidator, attrib, attrib.getAlias(), validationResult);
    }
}

