/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.vaadin.data.Validator;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectionChangedListener;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.AttributesTable;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.FormParameter;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansController;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.NameEditForm;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.Mbean;

public class MBeansContentPanel
extends VerticalLayout
implements SelectionChangedListener {
    private static final FormParameter MBEAN_FORM_PARAMETER = new FormParameter(){

        @Override
        public String getCaption() {
            return "MBean details";
        }

        @Override
        public String getEditablePropertyName() {
            return "name";
        }

        @Override
        public String getNonEditablePropertyName() {
            return "objectname";
        }

        @Override
        public String getEditablePropertyCaption() {
            return "Name";
        }

        @Override
        public String getNonEditablePropertyCaption() {
            return "Objectname";
        }
    };
    private static final FormParameter COMPOSITE_FORM_PARAMETER = new FormParameter(){

        @Override
        public String getCaption() {
            return "Composite details";
        }

        @Override
        public String getEditablePropertyName() {
            return "alias";
        }

        @Override
        public String getNonEditablePropertyName() {
            return "name";
        }

        @Override
        public String getEditablePropertyCaption() {
            return "Alias";
        }

        @Override
        public String getNonEditablePropertyCaption() {
            return "Name";
        }
    };
    private static final String CAPTION_FORMAT = "<b>%s</b>";
    private final AttributesTable attributesTable;
    private final NameEditForm nameEditForm;
    private final MBeansController controller;
    private final VerticalLayout contentLayout;
    private final VerticalLayout emptyLayout;
    private final Label captionLabel;

    public MBeansContentPanel(MBeansController controller) {
        this.controller = controller;
        this.attributesTable = new AttributesTable(controller, controller);
        this.emptyLayout = new VerticalLayout();
        this.emptyLayout.setSpacing(true);
        this.emptyLayout.setMargin(true);
        this.emptyLayout.addComponent((Component)new Label("No MBean or Composite selected. Please select one to modify data."));
        this.nameEditForm = new NameEditForm(controller);
        this.captionLabel = new Label();
        this.captionLabel.setContentMode(ContentMode.HTML);
        VerticalLayout attributeLayout = new VerticalLayout();
        attributeLayout.addComponent((Component)this.captionLabel);
        attributeLayout.addComponent((Component)this.attributesTable);
        attributeLayout.setSizeFull();
        attributeLayout.setExpandRatio((Component)this.attributesTable, 1.0f);
        this.contentLayout = new VerticalLayout();
        this.contentLayout.setSpacing(true);
        this.contentLayout.setMargin(true);
        this.contentLayout.addComponent((Component)this.nameEditForm);
        this.contentLayout.addComponent((Component)attributeLayout);
        this.contentLayout.setSizeFull();
        this.contentLayout.setExpandRatio((Component)attributeLayout, 1.0f);
        this.addComponent((Component)this.emptyLayout);
        this.addComponent((Component)this.contentLayout);
        this.setSizeFull();
        controller.registerSelectionValueChangedListener(this.nameEditForm);
        controller.registerSelectionValueChangedListener(this.attributesTable);
    }

    public void selectionChanged(SelectionChangedListener.SelectionChangedEvent event) {
        Object selectedBean = event.getSelectedBean();
        if (selectedBean instanceof Mbean) {
            this.captionLabel.setValue(String.format(CAPTION_FORMAT, "MBean Attributes"));
            this.nameEditForm.setParameter(MBEAN_FORM_PARAMETER);
            this.nameEditForm.selectionChanged(event);
            this.attributesTable.modelChanged(event.getSelectedItem(), event.getSelectedBean(), this.controller.getContainer(Attrib.class, selectedBean));
            this.setContent((Component)this.contentLayout);
            return;
        }
        if (selectedBean instanceof CompAttrib) {
            this.captionLabel.setValue(String.format(CAPTION_FORMAT, "Composite Members"));
            this.nameEditForm.setParameter(COMPOSITE_FORM_PARAMETER);
            this.nameEditForm.selectionChanged(event);
            this.attributesTable.modelChanged(event.getSelectedItem(), event.getSelectedBean(), this.controller.getContainer(CompMember.class, selectedBean));
            this.setContent((Component)this.contentLayout);
            return;
        }
        this.setContent((Component)this.emptyLayout);
    }

    private void setContent(Component component) {
        this.emptyLayout.setVisible(false);
        this.contentLayout.setVisible(false);
        component.setVisible(true);
    }

    boolean isDirty() {
        if (this.contentLayout.isVisible()) {
            boolean dirtyFlag = this.nameEditForm.isDirty() || this.attributesTable.isDirty();
            return dirtyFlag;
        }
        return false;
    }

    private void validate() throws Validator.InvalidValueException {
        if (this.contentLayout.isVisible()) {
            this.nameEditForm.validate();
            this.attributesTable.validate();
        }
    }

    boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (Validator.InvalidValueException ex) {
            return false;
        }
    }

    void reset() {
        this.setContent((Component)this.emptyLayout);
    }

    void discard() {
        if (this.contentLayout.isVisible()) {
            this.nameEditForm.discard();
            this.attributesTable.discard();
        }
    }
}

