/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.vaadin.data.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ValidationResult {
    private final Map<Object, Set<Validator.InvalidValueException>> errorMap = new HashMap<Object, Set<Validator.InvalidValueException>>();

    public <T> void add(T itemId, Validator.InvalidValueException validationException) {
        if (this.errorMap.get(itemId) == null) {
            this.errorMap.put(itemId, new HashSet());
        }
        this.errorMap.get(itemId).add(validationException);
    }

    public void merge(ValidationResult resultToMerge) {
        if (resultToMerge != null && !resultToMerge.isValid()) {
            for (Map.Entry<Object, Set<Validator.InvalidValueException>> eachEntry : resultToMerge.errorMap.entrySet()) {
                if (!this.errorMap.containsKey(eachEntry.getKey())) {
                    this.errorMap.put(eachEntry.getKey(), eachEntry.getValue());
                    continue;
                }
                this.errorMap.get(eachEntry.getKey()).addAll((Collection<Validator.InvalidValueException>)eachEntry.getValue());
            }
        }
    }

    public boolean isValid() {
        return this.errorMap.isEmpty();
    }

    protected <T> ValidationError getValidationError(T object) {
        Set<Validator.InvalidValueException> exceptionList = this.errorMap.get(object);
        exceptionList = exceptionList == null ? Collections.emptySet() : exceptionList;
        return new ValidationError(object, exceptionList);
    }

    public Collection<ValidationError> getValidationErrors(final Class<?> clazz) {
        return Collections2.filter(this.getValidationErrors(), (Predicate)new Predicate<ValidationError>(){

            public boolean apply(ValidationError input) {
                return input.errorObject.getClass() == clazz;
            }
        });
    }

    public List<ValidationError> getValidationErrors() {
        ArrayList<ValidationError> errorList = new ArrayList<ValidationError>();
        for (Map.Entry<Object, Set<Validator.InvalidValueException>> eachEntry : this.errorMap.entrySet()) {
            errorList.add(new ValidationError(eachEntry.getKey(), eachEntry.getValue()));
        }
        return errorList;
    }

    public int getErrorCount() {
        int counter = 0;
        for (Set<Validator.InvalidValueException> values : this.errorMap.values()) {
            counter += values.size();
        }
        return counter;
    }

    public static class ValidationError {
        private final List<Validator.InvalidValueException> exceptionList;
        private final Object errorObject;

        public ValidationError(Object errorObject, Set<Validator.InvalidValueException> exceptionList) {
            this.errorObject = errorObject;
            this.exceptionList = new ArrayList<Validator.InvalidValueException>(exceptionList);
        }

        public Object getErrorObject() {
            return this.errorObject;
        }

        public List<Validator.InvalidValueException> getExceptionList() {
            return this.exceptionList;
        }
    }
}

