/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.vaadin.data.Item;
import com.vaadin.data.util.HierarchicalContainer;
import com.vaadin.server.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.jmxconfiggenerator.data.StringRenderer;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.IconUpdater;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansHelper;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansItemStrategyHandler;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MbeansHierarchicalContainer
extends HierarchicalContainer {
    private static final Logger LOG = LoggerFactory.getLogger(MbeansHierarchicalContainer.class);
    private final MBeansItemStrategyHandler itemStrategyHandler = new MBeansItemStrategyHandler();
    private final IconUpdater iconUpdater = new IconUpdater();
    private Map<String, Object> itemIdToDataMapping = new HashMap<String, Object>();
    private Map<Object, String> dataToItemIdMapping = new HashMap<Object, String>();
    private Collection<Mbean> mbeans = new ArrayList<Mbean>();

    public MbeansHierarchicalContainer() {
        this.addContainerProperty("valid", Boolean.class, Boolean.TRUE);
        this.addContainerProperty("icon", Resource.class, null);
        this.addContainerProperty("caption", String.class, "");
        this.addContainerProperty("selected", Boolean.class, Boolean.FALSE);
        this.addContainerProperty("label", String.class, "");
    }

    private void clearContainer() {
        this.mbeans.clear();
        this.itemIdToDataMapping.clear();
        this.dataToItemIdMapping.clear();
        this.removeAllItems();
    }

    protected void updateDataSource(List<Mbean> mbeanList) {
        this.clearContainer();
        for (Mbean eachMbean : mbeanList) {
            this.add(eachMbean);
        }
        this.sort(new Object[]{"label"}, new boolean[]{true});
    }

    public Object firstItemId() {
        if (this.size() > 0) {
            ArrayList rootItemIds = new ArrayList(this.rootItemIds());
            Collections.sort(rootItemIds, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((String)o1).compareTo((String)o2);
                }
            });
            return rootItemIds.get(0);
        }
        return null;
    }

    public Collection<Mbean> getMBeans() {
        return this.mbeans;
    }

    private void add(Mbean bean) {
        String objectName = bean.getObjectname();
        if (Strings.isNullOrEmpty((String)objectName)) {
            return;
        }
        if (!objectName.contains(":")) {
            return;
        }
        this.addNodes(bean);
        this.mbeans.add(bean);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(((Object)((Object)this)).getClass().getName() + ":\n");
        for (Object eachRootItemId : this.rootItemIds()) {
            string.append(this.printInternalTree(eachRootItemId, 0));
            string.append("\n");
        }
        return string.toString().trim();
    }

    public boolean isSelected(Object itemId) {
        return (Boolean)this.getItem(itemId).getItemProperty((Object)"selected").getValue();
    }

    public Collection<Mbean> getSelectedMbeans() {
        return Collections2.filter(this.getMBeans(), (Predicate)new Predicate<Mbean>(){

            public boolean apply(Mbean input) {
                return MbeansHierarchicalContainer.this.isSelected(MbeansHierarchicalContainer.this.dataToItemIdMapping.get(input));
            }
        });
    }

    private String addNodes(List nodesToAdd) {
        String rootItemId = null;
        Iterator it = nodesToAdd.iterator();
        while (it.hasNext()) {
            Object eachNode = it.next();
            boolean hasChildren = it.hasNext();
            if (eachNode instanceof Mbean) {
                hasChildren |= ((Mbean)eachNode).getCompAttribList() != null && !((Mbean)eachNode).getCompAttribList().isEmpty();
            }
            rootItemId = this.addNode(rootItemId, eachNode, hasChildren);
        }
        return rootItemId;
    }

    private String addNode(String rootItemId, Object node, boolean hasChildren) {
        String itemId = this.buildItemId(node);
        if (rootItemId != null) {
            itemId = rootItemId + "." + itemId;
        }
        this.addItem(rootItemId, itemId, node, hasChildren);
        return itemId;
    }

    private void addNodes(Mbean mbean) {
        List newNodeList = MBeansHelper.getMBeansTreeElements(mbean);
        newNodeList.add(mbean);
        String rootItemId = this.addNodes(newNodeList);
        if (mbean.getCompAttribList() != null && !mbean.getCompAttribList().isEmpty()) {
            for (CompAttrib eachCompAttrib : mbean.getCompAttribList()) {
                this.addNode(rootItemId, eachCompAttrib, false);
            }
        }
    }

    private String printInternalTree(Object itemId, int depth) {
        String tabs = "";
        String ret = "";
        for (int i = 0; i < depth; ++i) {
            tabs = tabs + "    ";
        }
        Object data = this.itemIdToDataMapping.get(itemId);
        String nodeDataAsString = data.toString();
        if (data instanceof Mbean) {
            nodeDataAsString = ((Mbean)data).getObjectname();
        }
        if (data instanceof CompAttrib) {
            nodeDataAsString = ((CompAttrib)data).getName();
        }
        ret = ret + tabs + nodeDataAsString + "\n";
        if (this.hasChildren(itemId)) {
            for (Object eachChildItemId : this.getChildren(itemId)) {
                ret = ret + this.printInternalTree(eachChildItemId, depth + 1);
            }
        }
        return ret;
    }

    private void addItem(String parentItemId, String childItemId, Object childData, boolean hasChildren) {
        if (!this.containsId(childItemId)) {
            LOG.debug("Adding child {} to parent {}.", (Object)childItemId, (Object)parentItemId);
            Item item = this.addItem(childItemId);
            if (item == null) {
                LOG.error("Could not add item with item id {}.", (Object)childItemId);
            } else {
                this.itemIdToDataMapping.put(childItemId, childData);
                this.dataToItemIdMapping.put(childData, childItemId);
                this.setItemProperties(item, childData);
                this.setParent(childItemId, parentItemId);
                this.setChildrenAllowed(childItemId, hasChildren);
            }
        } else {
            LOG.debug("Child with id {} already added.", (Object)childItemId);
        }
    }

    private String buildItemId(Object data) {
        StringRenderer renderer = this.getStringRenderer(data.getClass());
        String itemId = renderer.render(data);
        return itemId;
    }

    private void setItemProperties(Item item, Object itemData) {
        this.itemStrategyHandler.setItemProperties(item, itemData);
        this.iconUpdater.updateIcon(item, (Boolean)item.getItemProperty((Object)"selected").getValue());
    }

    private StringRenderer getStringRenderer(Class<?> clazz) {
        return this.itemStrategyHandler.getStringRenderer(clazz);
    }

    public Object getDataFor(String itemId) {
        return this.itemIdToDataMapping.get(itemId);
    }

    public String getItemIdFor(Object data) {
        return this.dataToItemIdMapping.get(data);
    }
}

