/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.opennms.netmgt.config.collectd.jmx.Mbean;

abstract class MBeansHelper {
    MBeansHelper() {
    }

    public static List getMBeansTreeElements(Mbean input) {
        return MBeansHelper.getMBeansTreeElements(input, true);
    }

    public static String getLeafLabel(Mbean input) {
        List labels = MBeansHelper.getMBeansTreeElements(input, false);
        if (labels.isEmpty()) {
            return input.getName();
        }
        Object label = labels.get(labels.size() - 1);
        if (label instanceof Map.Entry) {
            return ((Map.Entry)label).getValue().toString();
        }
        return label.toString();
    }

    private static List getMBeansTreeElements(Mbean input, boolean removeLastElement) {
        ArrayList<Object> names = new ArrayList<Object>();
        try {
            ObjectName objectname = ObjectName.getInstance(input.getObjectname());
            Map<String, String> keyProperty = MBeansHelper.buildKeyPropertyList(objectname);
            names.add(objectname.getDomain());
            names.addAll(keyProperty.entrySet());
            if (removeLastElement) {
                names.remove(names.size() - 1);
            }
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
        return names;
    }

    private static Map<String, String> buildKeyPropertyList(ObjectName objectName) {
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        String keyPropertyListString = objectName.getKeyPropertyListString();
        if (keyPropertyListString != null && !keyPropertyListString.isEmpty()) {
            String[] keyValuePairs;
            for (String eachKeyValue : keyValuePairs = keyPropertyListString.split(",")) {
                String value;
                String key = eachKeyValue.substring(0, eachKeyValue.indexOf("="));
                String string = value = eachKeyValue.length() > key.length() ? eachKeyValue.substring(key.length() + 1) : "undefined";
                if (key.isEmpty() || value.isEmpty()) continue;
                keyValueMap.put(key, value);
            }
        }
        return keyValueMap;
    }
}

