/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.event.FieldEvents;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import java.util.Objects;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectionChangedListener;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectionValueChangedListener;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.FormParameter;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansController;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.NameValidator;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class NameEditForm
extends VerticalLayout
implements SelectionChangedListener,
SelectionValueChangedListener {
    private final Validator nameValidator = new NameValidator();
    private final Label captionLabel;
    private FormParameter parameter;
    private FieldGroup fieldGroup;
    private FormLayout contentLayout = new FormLayout();
    private TextField editableField;
    private TextField nonEditableField;
    private CheckBox selectedField;
    private MBeansController controller;
    private boolean blockListenerOrValidators;
    private String itemId;

    public NameEditForm(MBeansController controller) {
        this.initFields();
        this.controller = controller;
        this.captionLabel = new Label();
        this.captionLabel.setContentMode(ContentMode.HTML);
        this.addComponent((Component)this.captionLabel);
        this.addComponent((Component)this.contentLayout);
        this.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.setImmediate(true);
    }

    protected void setParameter(FormParameter parameter) {
        this.parameter = parameter;
    }

    public void selectionChanged(SelectionChangedListener.SelectionChangedEvent changeEvent) {
        if (this.parameter != null) {
            try {
                this.blockListenerOrValidators = true;
                this.setData(changeEvent.getSelectedBean());
                this.setItemId(changeEvent.getSelectedItemId());
                BeanItem beanItem = new BeanItem(changeEvent.getSelectedBean(), new String[]{this.parameter.getEditablePropertyName(), this.parameter.getNonEditablePropertyName()});
                beanItem.addItemProperty((Object)"selected", changeEvent.getSelectedItem().getItemProperty((Object)"selected"));
                this.captionLabel.setValue(String.format("<b>%s</b>", this.parameter.getCaption()));
                this.fieldGroup = new FieldGroup();
                this.fieldGroup.setBuffered(false);
                this.fieldGroup.bind((Field)this.selectedField, (Object)"selected");
                this.fieldGroup.bind((Field)this.editableField, (Object)this.parameter.getEditablePropertyName());
                this.fieldGroup.bind((Field)this.nonEditableField, (Object)this.parameter.getNonEditablePropertyName());
                this.fieldGroup.setItemDataSource((Item)beanItem);
                this.fieldGroup.getField((Object)this.parameter.getNonEditablePropertyName()).setCaption(this.parameter.getNonEditablePropertyCaption());
                this.fieldGroup.getField((Object)this.parameter.getNonEditablePropertyName()).setReadOnly(true);
                this.fieldGroup.getField((Object)this.parameter.getEditablePropertyName()).setCaption(this.parameter.getEditablePropertyCaption());
                this.fieldGroup.getField((Object)this.parameter.getEditablePropertyName()).setReadOnly(false);
                this.updateEnabledState();
                UIHelper.validateField((Field)this.editableField, (boolean)true);
            }
            finally {
                this.blockListenerOrValidators = false;
            }
        }
    }

    @Override
    public void selectionValueChanged(SelectionValueChangedListener.SelectionValueChangedEvent selectionValueChangedEvent) {
        if (selectionValueChangedEvent.getBean() == this.getData()) {
            this.selectedField.setValue((Object)selectionValueChangedEvent.getNewValue());
        }
    }

    private void setItemId(String itemId) {
        this.itemId = itemId;
    }

    private String getItemId() {
        return this.itemId;
    }

    private void initFields() {
        this.nonEditableField = new TextField();
        this.nonEditableField.setWidth(400.0f, Sizeable.Unit.PIXELS);
        this.nonEditableField.setReadOnly(true);
        this.nonEditableField.setEnabled(false);
        this.editableField = new TextField();
        this.editableField.setWidth(400.0f, Sizeable.Unit.PIXELS);
        this.editableField.setRequired(true);
        this.editableField.setRequiredError("You must provide a value.");
        this.editableField.setValidationVisible(false);
        this.editableField.setBuffered(false);
        this.editableField.setImmediate(true);
        this.editableField.addValidator(this.nameValidator);
        this.editableField.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                if (!NameEditForm.this.blockListenerOrValidators) {
                    NameEditForm.this.controller.validateCurrentSelection();
                }
            }
        });
        this.editableField.setTextChangeTimeout(200);
        this.editableField.addTextChangeListener(new FieldEvents.TextChangeListener(){

            public void textChange(FieldEvents.TextChangeEvent event) {
                NameEditForm.this.editableField.setComponentError(null);
                NameEditForm.this.editableField.setValue(event.getText());
                NameEditForm.this.editableField.validate();
            }
        });
        this.selectedField = new CheckBox();
        this.selectedField.setCaption("selected");
        this.selectedField.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent event) {
                NameEditForm.this.updateEnabledState();
                if (!((Boolean)NameEditForm.this.selectedField.getValue()).booleanValue()) {
                    NameEditForm.this.editableField.discard();
                }
                if (!NameEditForm.this.blockListenerOrValidators) {
                    try {
                        NameEditForm.this.blockListenerOrValidators = true;
                        NameEditForm.this.controller.fireSelectionValueChanged(NameEditForm.this.getData(), NameEditForm.this.getItemId(), (Boolean)NameEditForm.this.selectedField.getValue());
                    }
                    finally {
                        NameEditForm.this.blockListenerOrValidators = false;
                    }
                }
            }
        });
        this.contentLayout.addComponent((Component)this.selectedField);
        this.contentLayout.addComponent((Component)this.editableField);
        this.contentLayout.addComponent((Component)this.nonEditableField);
    }

    void validate() throws Validator.InvalidValueException {
        if (this.fieldGroup != null && this.fieldGroup.getItemDataSource() != null && this.fieldGroup.getItemDataSource().getItemProperty((Object)"selected") != null && this.fieldGroup.getItemDataSource().getItemProperty((Object)"selected").getValue() != null && Objects.equals(true, this.fieldGroup.getItemDataSource().getItemProperty((Object)"selected").getValue())) {
            UIHelper.validateFields((Collection)this.fieldGroup.getFields(), (boolean)false);
        }
    }

    boolean isDirty() {
        return this.fieldGroup.isModified();
    }

    void discard() {
        this.fieldGroup.discard();
    }

    private void updateEnabledState() {
        this.nonEditableField.setEnabled(((Boolean)this.selectedField.getValue()).booleanValue());
        this.editableField.setEnabled(((Boolean)this.selectedField.getValue()).booleanValue());
        this.editableField.setComponentError(null);
    }
}

