/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.data;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXB;
import org.opennms.features.vaadin.jmxconfiggenerator.data.ServiceConfig;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.collectd.Collector;
import org.opennms.netmgt.config.collectd.Package;
import org.opennms.netmgt.config.collectd.Parameter;
import org.opennms.netmgt.config.collectd.Service;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;

public class UiModel {
    private JmxDatacollectionConfig rawModel;
    private ServiceConfig configModel = new ServiceConfig();
    private final Map<OutputDataKey, String> outputMap = new HashMap<OutputDataKey, String>();
    private JmxDatacollectionConfig outputConfig;
    private String snmpGraphProperties;

    public UiModel setRawModel(JmxDatacollectionConfig rawModel) {
        if (!this.isValid(rawModel)) {
            throw new IllegalArgumentException("Model is not valid.");
        }
        this.rawModel = rawModel;
        return this;
    }

    private boolean isValid(JmxDatacollectionConfig rawModel) {
        return !rawModel.getJmxCollection().isEmpty() && rawModel.getJmxCollection().get(0) != null && ((JmxCollection)rawModel.getJmxCollection().get(0)).getMbeans() != null;
    }

    public JmxDatacollectionConfig getRawModel() {
        return this.rawModel;
    }

    public String getServiceName() {
        return this.configModel.getServiceName();
    }

    public void setOutput(OutputDataKey output, String value) {
        this.outputMap.put(output, value);
    }

    public Map<OutputDataKey, String> getOutputMap() {
        return this.outputMap;
    }

    public ServiceConfig getServiceConfig() {
        return this.configModel;
    }

    public void setJmxDataCollectionAccordingToSelection(JmxDatacollectionConfig outputConfig) {
        this.outputConfig = outputConfig;
    }

    public JmxDatacollectionConfig getOutputConfig() {
        return this.outputConfig;
    }

    public void updateOutput() {
        this.setOutput(OutputDataKey.JmxDataCollectionConfig, UiModel.marshal(this.getOutputConfig()));
        this.setOutput(OutputDataKey.SnmpGraphProperties, this.snmpGraphProperties);
        this.setOutput(OutputDataKey.CollectdConfigSnippet, UiModel.marshal(this.getCollectdConfiguration()));
    }

    public void setSnmpGraphProperties(String generatedSnmpGraphProperties) {
        this.snmpGraphProperties = generatedSnmpGraphProperties;
    }

    public void setServiceConfig(ServiceConfig serviceConfig) {
        this.configModel = serviceConfig;
    }

    public CollectdConfiguration getCollectdConfiguration() {
        CollectdConfiguration config = new CollectdConfiguration();
        Package defaultPackage = new Package();
        defaultPackage.setName("default");
        Service service = new Service();
        service.setName(this.getServiceName());
        service.setInterval(Long.valueOf(300000L));
        service.setUserDefined(Boolean.TRUE.toString());
        service.setStatus("on");
        service.addParameter(UiModel.createParameter("url", this.getServiceConfig().getConnection()));
        service.addParameter(UiModel.createParameter("retry", "2"));
        service.addParameter(UiModel.createParameter("timeout", "3000"));
        service.addParameter(UiModel.createParameter("rrd-base-name", "java"));
        service.addParameter(UiModel.createParameter("ds-name", this.getServiceName()));
        service.addParameter(UiModel.createParameter("friendly-name", this.getServiceName()));
        service.addParameter(UiModel.createParameter("collection", this.getServiceName()));
        service.addParameter(UiModel.createParameter("thresholding-enabled", Boolean.TRUE.toString()));
        if (this.getServiceConfig().isAuthenticate()) {
            service.addParameter(UiModel.createParameter("factory", "PASSWORD-CLEAR"));
            service.addParameter(UiModel.createParameter("username", this.getServiceConfig().getUser()));
            service.addParameter(UiModel.createParameter("password", this.getServiceConfig().getPassword()));
        }
        Collector collector = new Collector();
        collector.setService(this.getServiceName());
        collector.setClassName("org.opennms.netmgt.collectd.Jsr160Collector");
        config.addPackage(defaultPackage);
        config.addCollector(collector);
        defaultPackage.addService(service);
        return config;
    }

    private static Parameter createParameter(String key, String value) {
        Parameter parameter = new Parameter();
        parameter.setKey(key);
        parameter.setValue(value);
        return parameter;
    }

    private static String marshal(Object anyObject) {
        StringWriter stringWriter = new StringWriter();
        JAXB.marshal((Object)anyObject, (Writer)stringWriter);
        return stringWriter.getBuffer().toString();
    }

    public static enum OutputDataKey {
        JmxDataCollectionConfig("jmx-datacollection-config.xml"),
        SnmpGraphProperties("snmp-graph.properties"),
        CollectdConfigSnippet("collectd-configuration.xml");

        private final String title;

        private OutputDataKey(String title) {
            this.title = title;
        }

        public String getDescriptionFilename() {
            return "/descriptions/" + this.name() + ".html";
        }

        public String getDownloadFilename() {
            return this.title;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

