/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.jobs;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxDatacollectionConfiggenerator;
import org.opennms.features.jmxconfiggenerator.jmxconfig.JmxHelper;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQueryException;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.opennms.features.jmxconfiggenerator.log.Slf4jLogAdapter;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.data.ServiceConfig;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.JobManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionException;
import org.opennms.netmgt.jmx.connection.JmxServerConnectionWrapper;
import org.opennms.netmgt.jmx.impl.connection.connectors.PlatformMBeanServerConnector;
import org.opennms.netmgt.vaadin.core.UIHelper;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Attrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompMember;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbeans;

public class DetectMBeansJob
implements JobManager.Task<JmxDatacollectionConfig> {
    private final Map<Class<?>, Filter<?>> filterMap;
    private final ServiceConfig config;

    public DetectMBeansJob(ServiceConfig config) {
        this.config = config;
        this.filterMap = new HashMap();
        this.filterMap.put(Mbean.class, new Filter<Mbean>(){

            @Override
            public void apply(Mbean input) {
                if (input.getName().contains("com.mchange.v2.c3p0.PooledDataSource")) {
                    input.setName("com.mchange.v2.c3p0.PooledDataSource");
                }
            }
        });
        this.filterMap.put(Attrib.class, new Filter<Attrib>(){

            @Override
            public void apply(Attrib input) {
                if ("0numFailedCheckinsDfltUsr_NAME_CRASH_AS_19_CHAR_VALUE".equals(input.getAlias()) && "numFailedCheckinsDefaultUser".equals(input.getName())) {
                    input.setAlias("1numFailChecDfltUsr");
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JmxDatacollectionConfig execute() throws JobManager.TaskRunException {
        try {
            InetAddress address = InetAddress.getByName(this.config.getHost());
            String jmxPort = System.getProperty("com.sun.management.jmxremote.port");
            if (address != null && address.isLoopbackAddress() && this.config.getPort() != null && (this.config.getPort().equals(jmxPort) || jmxPort == null && "18980".equals(this.config.getPort()))) {
                try (JmxServerConnectionWrapper connector = new PlatformMBeanServerConnector().createConnection(address, Collections.emptyMap());){
                    JmxDatacollectionConfiggenerator jmxConfigGenerator = new JmxDatacollectionConfiggenerator((LogAdapter)new Slf4jLogAdapter(JmxDatacollectionConfiggenerator.class));
                    JmxDatacollectionConfig generatedJmxConfigModel = jmxConfigGenerator.generateJmxConfigModel(connector.getMBeanServerConnection(), "anyservice", Boolean.valueOf(!this.config.isSkipDefaultVM()), Boolean.valueOf(this.config.isSkipNonNumber()), JmxHelper.loadInternalDictionary());
                    this.applyFilters(generatedJmxConfigModel);
                    JmxDatacollectionConfig jmxDatacollectionConfig = generatedJmxConfigModel;
                    return jmxDatacollectionConfig;
                }
                catch (IOException | JMException | MBeanServerQueryException | JmxServerConnectionException e) {
                    throw new JobManager.TaskRunException("Error while retrieving MBeans from server.", e);
                }
            }
            JMXServiceURL jmxServiceURL = JmxHelper.createJmxServiceUrl(null, (String)this.config.getHost(), (String)this.config.getPort(), (boolean)this.config.isJmxmp());
            try (JMXConnector connector = JmxHelper.createJmxConnector((String)this.config.getUser(), (String)this.config.getPassword(), (JMXServiceURL)jmxServiceURL);){
                JmxDatacollectionConfiggenerator jmxConfigGenerator = new JmxDatacollectionConfiggenerator((LogAdapter)new Slf4jLogAdapter(JmxDatacollectionConfiggenerator.class));
                JmxDatacollectionConfig generatedJmxConfigModel = jmxConfigGenerator.generateJmxConfigModel(connector.getMBeanServerConnection(), "anyservice", Boolean.valueOf(!this.config.isSkipDefaultVM()), Boolean.valueOf(this.config.isSkipNonNumber()), JmxHelper.loadInternalDictionary());
                this.applyFilters(generatedJmxConfigModel);
                JmxDatacollectionConfig jmxDatacollectionConfig = generatedJmxConfigModel;
                return jmxDatacollectionConfig;
            }
            catch (IOException | JMException | MBeanServerQueryException e) {
                throw new JobManager.TaskRunException("Error while retrieving MBeans from server.", e);
            }
        }
        catch (MalformedURLException e) {
            throw new JobManager.TaskRunException(String.format("Cannot create valid JMX Connection URL. Host = '%s', Port = '%s', use jmxmp = %s", this.config.getHost(), this.config.getPort(), this.config.isJmxmp()), e);
        }
        catch (UnknownHostException e) {
            throw new JobManager.TaskRunException(String.format("Unknown host: %s", this.config.getHost()), e);
        }
    }

    @Override
    public void onSuccess(JmxDatacollectionConfig generatedJmxConfigModel) {
        ((JmxConfigGeneratorUI)((Object)UIHelper.getCurrent(JmxConfigGeneratorUI.class))).setRawModel(generatedJmxConfigModel);
        ((JmxConfigGeneratorUI)((Object)UIHelper.getCurrent(JmxConfigGeneratorUI.class))).updateView(UiState.MbeansView);
    }

    @Override
    public void onError() {
    }

    private <T> void applyFilters(T input) {
        Filter<?> filter = this.filterMap.get(input.getClass());
        if (filter != null) {
            filter.apply(input);
        }
    }

    private void applyFilters(JmxDatacollectionConfig config) {
        Mbeans mbeans = ((JmxCollection)config.getJmxCollection().get(0)).getMbeans();
        for (Mbean eachMbean : mbeans.getMbean()) {
            this.applyFilters(eachMbean);
            for (Attrib eachAttrib : eachMbean.getAttrib()) {
                this.applyFilters(eachAttrib);
            }
            for (CompAttrib eachCompAttrib : eachMbean.getCompAttrib()) {
                this.applyFilters(eachCompAttrib);
                for (CompMember eachCompMember : eachCompAttrib.getCompMember()) {
                    this.applyFilters(eachCompMember);
                }
            }
        }
    }

    private static interface Filter<X> {
        public void apply(X var1);
    }
}

