/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.jobs;

import java.util.Collection;
import org.opennms.features.jmxconfiggenerator.graphs.GraphConfigGenerator;
import org.opennms.features.jmxconfiggenerator.graphs.JmxConfigReader;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.opennms.features.jmxconfiggenerator.log.Slf4jLogAdapter;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.data.UiModel;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.JobManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class GenerateConfigsJob
implements JobManager.Task {
    private final UiModel model;

    public GenerateConfigsJob(UiModel model) {
        this.model = model;
    }

    public Void execute() throws JobManager.TaskRunException {
        GraphConfigGenerator graphConfigGenerator = new GraphConfigGenerator((LogAdapter)new Slf4jLogAdapter(GraphConfigGenerator.class));
        Collection reports = new JmxConfigReader((LogAdapter)new Slf4jLogAdapter(JmxConfigReader.class)).generateReportsByJmxDatacollectionConfig(this.model.getOutputConfig());
        this.model.setSnmpGraphProperties(graphConfigGenerator.generateSnmpGraph(reports));
        this.model.updateOutput();
        return null;
    }

    public void onSuccess(Object result) {
        ((JmxConfigGeneratorUI)((Object)UIHelper.getCurrent(JmxConfigGeneratorUI.class))).updateView(UiState.ResultView);
    }

    @Override
    public void onError() {
    }
}

