/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.NameProvider;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.SelectionManager;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Attrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompMember;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class DefaultNameProvider
implements NameProvider {
    private final SelectionManager selectionManager;

    public DefaultNameProvider(SelectionManager selectionManager) {
        Objects.requireNonNull(selectionManager);
        this.selectionManager = selectionManager;
    }

    @Override
    public Map<Object, String> getNamesMap() {
        HashMap<Object, String> objectToNameMap = new HashMap<Object, String>();
        for (Mbean bean : this.selectionManager.getSelectedMbeans()) {
            for (Attrib att : this.selectionManager.getSelectedAttributes(bean)) {
                objectToNameMap.put(att, att.getAlias());
            }
            for (CompAttrib compAttrib : this.selectionManager.getSelectedCompositeAttributes(bean)) {
                for (CompMember compMember : this.selectionManager.getSelectedCompositeMembers(compAttrib)) {
                    objectToNameMap.put(compMember, compMember.getAlias());
                }
            }
        }
        return Collections.unmodifiableMap(objectToNameMap);
    }
}

