/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.DownloadStream;
import com.vaadin.server.FileDownloader;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.StreamResource;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Label;
import com.vaadin.ui.TabSheet;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.VerticalLayout;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.vaadin.jmxconfiggenerator.Config;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.data.UiModel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.ButtonPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.netmgt.vaadin.core.UIHelper;

public class ResultView
extends VerticalLayout
implements Button.ClickListener,
View {
    private static String DOWNLOAD_FILE_NAME = "jmx-config-files.zip";
    private TabSheet tabSheet = new TabSheet();
    private Map<UiModel.OutputDataKey, TabContent> tabContentMap = new HashMap<UiModel.OutputDataKey, TabContent>();
    private final ButtonPanel buttonPanel = new ButtonPanel(this);
    private final FileDownloader fileDownloader;

    public ResultView() {
        this.tabContentMap.put(UiModel.OutputDataKey.JmxDataCollectionConfig, new TabContent(UiModel.OutputDataKey.JmxDataCollectionConfig));
        this.tabContentMap.put(UiModel.OutputDataKey.SnmpGraphProperties, new TabContent(UiModel.OutputDataKey.SnmpGraphProperties));
        this.tabContentMap.put(UiModel.OutputDataKey.CollectdConfigSnippet, new TabContent(UiModel.OutputDataKey.CollectdConfigSnippet));
        ArrayList<UiModel.OutputDataKey> keyList = new ArrayList<UiModel.OutputDataKey>(this.tabContentMap.keySet());
        Collections.sort(keyList, new Comparator<UiModel.OutputDataKey>(){

            @Override
            public int compare(UiModel.OutputDataKey o1, UiModel.OutputDataKey o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        for (UiModel.OutputDataKey eachKey : keyList) {
            TabContent eachContent = this.tabContentMap.get((Object)eachKey);
            this.tabSheet.addTab((Component)eachContent, eachContent.getCaption());
        }
        this.tabSheet.setSizeFull();
        this.tabSheet.setSelectedTab(0);
        this.tabSheet.addStyleName("borderless");
        this.buttonPanel.getNext().setCaption("download all");
        this.buttonPanel.getNext().setDescription("Download a zip file containing the JMX datacollection configuration");
        this.buttonPanel.getNext().setIcon(Config.Icons.BUTTON_SAVE);
        this.fileDownloader = new FileDownloader(new Resource(){

            public String getMIMEType() {
                return "application/unknown";
            }
        });
        this.fileDownloader.extend((AbstractComponent)this.buttonPanel.getNext());
        this.setSizeFull();
        this.addComponent((Component)this.tabSheet);
        this.addComponent((Component)this.buttonPanel);
        this.setExpandRatio((Component)this.tabSheet, 1.0f);
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getSource().equals(this.buttonPanel.getPrevious())) {
            ((JmxConfigGeneratorUI)((Object)UIHelper.getCurrent(JmxConfigGeneratorUI.class))).updateView(UiState.MbeansView);
        }
    }

    private Map<String, String> createZipContentMap() {
        HashMap<String, String> zipContentMap = new HashMap<String, String>();
        for (UiModel.OutputDataKey eachKey : this.tabContentMap.keySet()) {
            zipContentMap.put(eachKey.getDownloadFilename(), this.tabContentMap.get((Object)eachKey).getConfigContent());
        }
        return zipContentMap;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        UiModel newValue = ((JmxConfigGeneratorUI)((Object)UIHelper.getCurrent(JmxConfigGeneratorUI.class))).getUiModel();
        if (newValue == null) {
            return;
        }
        for (Map.Entry<UiModel.OutputDataKey, String> eachEntry : newValue.getOutputMap().entrySet()) {
            if (this.tabContentMap.get((Object)eachEntry.getKey()) == null) continue;
            this.tabContentMap.get((Object)eachEntry.getKey()).setConfigContent(eachEntry.getValue());
        }
        this.fileDownloader.setFileDownloadResource((Resource)new DownloadResource(this.createZipContentMap(), DOWNLOAD_FILE_NAME));
    }

    private static class TabContent
    extends HorizontalSplitPanel {
        private final TextArea configTextArea = new TextArea();
        private final Label descriptionLabel;
        private String configContent;

        private TabContent(UiModel.OutputDataKey key) {
            this.configTextArea.setSizeFull();
            this.configTextArea.addStyleName("borderless");
            this.descriptionLabel = new Label(UIHelper.loadContentFromFile(((Object)((Object)this)).getClass(), (String)key.getDescriptionFilename()), ContentMode.HTML);
            VerticalLayout leftLayout = new VerticalLayout(new Component[]{this.descriptionLabel});
            leftLayout.setMargin(true);
            this.addComponent((Component)this.configTextArea);
            this.addComponent((Component)leftLayout);
            this.setSizeFull();
            this.setLocked(false);
            this.setSplitPosition(75.0f, Sizeable.Unit.PERCENTAGE);
            this.setCaption(key.getTitle());
        }

        public void setConfigContent(String newConfigContent) {
            this.configContent = newConfigContent;
            if (newConfigContent.split("\n").length >= 2500) {
                this.configTextArea.setValue("The generated configuration snippet is too long to show here. Please download the files and edit/view with the editor of choice.");
            } else {
                this.configTextArea.setValue(newConfigContent);
            }
        }

        public String getConfigContent() {
            return this.configContent == null ? "" : this.configContent;
        }
    }

    private static class DownloadResource
    extends StreamResource {
        public DownloadResource(final Map<String, String> zipContentMap, String filename) {
            super(new StreamResource.StreamSource(){

                public InputStream getStream() {
                    return new ByteArrayInputStream(DownloadResource.getZipByteArray(zipContentMap));
                }
            }, filename);
            this.setMIMEType("application/unknown");
        }

        public DownloadStream getStream() {
            DownloadStream ds = super.getStream();
            ds.setParameter("Content-Disposition", "attachment; filename=\"" + this.getFilename() + "\"");
            return ds;
        }

        /*
         * Exception decompiling
         */
        private static byte[] getZipByteArray(Map<String, String> zipContentMap) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

