/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractSplitPanel;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalSplitPanel;
import com.vaadin.ui.Tree;
import com.vaadin.ui.VerticalLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.data.JmxCollectionCloner;
import org.opennms.features.vaadin.jmxconfiggenerator.data.UiModel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.ButtonPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UIHelper;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansContentPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansController;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansTree;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.SelectionManager;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Attrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompAttrib;
import org.opennms.xmlns.xsd.config.jmx_datacollection.CompMember;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxCollection;
import org.opennms.xmlns.xsd.config.jmx_datacollection.JmxDatacollectionConfig;
import org.opennms.xmlns.xsd.config.jmx_datacollection.Mbean;

public class MBeansView
extends VerticalLayout
implements Button.ClickListener,
View {
    private final MBeansController controller;
    private UiModel model;
    private final JmxConfigGeneratorUI app;
    private final MBeansTree mbeansTree;
    private final MBeansContentPanel mbeansContentPanel;
    private final ButtonPanel buttonPanel = new ButtonPanel(this);

    public MBeansView(JmxConfigGeneratorUI app) {
        this.app = app;
        this.controller = new MBeansController();
        this.mbeansContentPanel = new MBeansContentPanel(this.controller);
        this.mbeansTree = new MBeansTree(this.controller);
        this.controller.registerSelectionChangedListener(this.mbeansContentPanel);
        this.controller.setMbeansContentPanel(this.mbeansContentPanel);
        this.controller.setMbeansTree(this.mbeansTree);
        AbstractSplitPanel mainPanel = this.initMainPanel(this.mbeansTree, (Component)this.mbeansContentPanel);
        this.addComponent((Component)mainPanel);
        this.addComponent((Component)this.buttonPanel);
        this.setExpandRatio((Component)mainPanel, 1.0f);
        this.setSizeFull();
    }

    public void buttonClick(Button.ClickEvent event) {
        if (event.getButton().equals(this.buttonPanel.getPrevious())) {
            this.app.updateView(UiState.ServiceConfigurationView);
        }
        if (event.getButton().equals(this.buttonPanel.getNext())) {
            if (!this.isValid()) {
                UIHelper.showValidationError("There are errors on this view. Please fix them first");
                return;
            }
            this.model.setJmxDataCollectionAccordingToSelection(MBeansView.createJmxDataCollectionAccordingToSelection(this.model, this.controller));
            this.app.updateView(UiState.ResultConfigGeneration);
        }
    }

    private AbstractSplitPanel initMainPanel(Tree first, Component second) {
        HorizontalSplitPanel splitPanel = new HorizontalSplitPanel();
        splitPanel.setSizeFull();
        splitPanel.setLocked(false);
        splitPanel.setSplitPosition(25.0f, Sizeable.Unit.PERCENTAGE);
        splitPanel.setFirstComponent((Component)first);
        splitPanel.setSecondComponent(second);
        splitPanel.setCaption(first.getCaption());
        return splitPanel;
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        if (this.app.getUiModel() != this.model) {
            UiModel newModel;
            this.model = newModel = this.app.getUiModel();
            this.controller.updateDataSource(this.model);
        }
    }

    private boolean isValid() {
        return this.controller.isValid();
    }

    private static JmxDatacollectionConfig createJmxDataCollectionAccordingToSelection(UiModel uiModel, SelectionManager selectionManager) {
        JmxDatacollectionConfig clone = JmxCollectionCloner.clone(uiModel.getRawModel());
        List exportBeans = ((JmxCollection)clone.getJmxCollection().get(0)).getMbeans().getMbean();
        exportBeans.clear();
        Collection<Mbean> selectedMbeans = selectionManager.getSelectedMbeans();
        for (Mbean mbean : selectedMbeans) {
            Mbean exportBean = JmxCollectionCloner.clone(mbean);
            exportBean.getAttrib().clear();
            for (Attrib att : selectionManager.getSelectedAttributes(mbean)) {
                exportBean.getAttrib().add(JmxCollectionCloner.clone(att));
            }
            if (!exportBean.getAttrib().isEmpty()) {
                exportBeans.add(exportBean);
            }
            exportBean.getCompAttrib().clear();
            for (CompAttrib compAtt : selectionManager.getSelectedCompositeAttributes(mbean)) {
                CompAttrib cloneCompAtt = JmxCollectionCloner.clone(compAtt);
                cloneCompAtt.getCompMember().clear();
                for (CompMember compMember : selectionManager.getSelectedCompositeMembers(compAtt)) {
                    cloneCompAtt.getCompMember().add(JmxCollectionCloner.clone(compMember));
                }
                if (cloneCompAtt.getCompMember().isEmpty()) continue;
                exportBean.getCompAttrib().add(cloneCompAtt);
            }
        }
        MBeansView.sort(exportBeans);
        ((JmxCollection)clone.getJmxCollection().get(0)).setName(uiModel.getServiceName());
        return clone;
    }

    private static void sort(List<Mbean> input) {
        Collections.sort(input, new Comparator<Mbean>(){

            @Override
            public int compare(Mbean o1, Mbean o2) {
                return o1.getObjectname().compareTo(o2.getObjectname());
            }
        });
        for (Mbean eachMbean : input) {
            Collections.sort(eachMbean.getAttrib(), new Comparator<Attrib>(){

                @Override
                public int compare(Attrib o1, Attrib o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            Collections.sort(eachMbean.getCompAttrib(), new Comparator<CompAttrib>(){

                @Override
                public int compare(CompAttrib o1, CompAttrib o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (CompAttrib eachCompAttrib : eachMbean.getCompAttrib()) {
                Collections.sort(eachCompAttrib.getCompMember(), new Comparator<CompMember>(){

                    @Override
                    public int compare(CompMember o1, CompMember o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
        }
    }
}

