/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.vaadin.data.Buffered;
import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.event.FieldEvents;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.ComboBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.Table;
import com.vaadin.ui.TableFieldFactory;
import com.vaadin.ui.TextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.features.vaadin.jmxconfiggenerator.data.MetaAttribItem;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectableBeanItemContainer;
import org.opennms.features.vaadin.jmxconfiggenerator.data.SelectionValueChangedListener;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UIHelper;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansController;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.NameProvider;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.TableTextFieldWrapper;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.AttributeNameValidator;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation.UniqueAttributeNameValidator;

public class AttributesTable<T>
extends Table
implements SelectionValueChangedListener {
    private final Map<Object, Field<String>> aliasFieldsMap = new HashMap<Object, Field<String>>();
    private final Map<Object[], Field<?>> fields = new HashMap();
    private final NameProvider nameProvider;
    private final TableFieldFactory tableFieldFactory;
    private final MBeansController controller;
    private final Property.ValueChangeListener validateOnValueChangeListener = new Property.ValueChangeListener(){

        public void valueChange(Property.ValueChangeEvent event) {
            if (!AttributesTable.this.blockValidation && AttributesTable.this.isVisible()) {
                AttributesTable.this.controller.validateCurrentSelection();
            }
        }
    };
    private Item parentItem;
    private Object parentData;
    private boolean blockValidation;

    private static Object[] computeKey(Object ... input) {
        return input;
    }

    public AttributesTable(NameProvider nameProvider, MBeansController controller) {
        this.nameProvider = nameProvider;
        this.controller = controller;
        this.tableFieldFactory = new AttributesTableFieldFactory();
        this.setSizeFull();
        this.setSelectable(false);
        this.setEditable(true);
        this.setValidationVisible(true);
        this.setReadOnly(true);
        this.setImmediate(true);
        this.setTableFieldFactory(new ReferenceTableFieldFactory());
        this.setValidationVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelChanged(Item parentItem, Object parentData, SelectableBeanItemContainer<T> container) {
        try {
            this.blockValidation = true;
            if (this.getParentItem() == parentItem) {
                return;
            }
            this.setParentItem(parentItem);
            this.setParentData(parentData);
            this.aliasFieldsMap.clear();
            this.fields.clear();
            for (Object eachItemId : container.getItemIds()) {
                for (String eachPropertyId : container.getContainerPropertyIds()) {
                    Field eachField = this.tableFieldFactory.createField(container, eachItemId, (Object)eachPropertyId, (Component)this);
                    if (eachField == null) continue;
                    this.fields.put(AttributesTable.computeKey(eachItemId, eachPropertyId), eachField);
                    if (!"alias".equals(eachPropertyId)) continue;
                    this.aliasFieldsMap.put(eachItemId, (Field<String>)eachField);
                    Item item = container.getItem(eachItemId);
                    Property property = item.getItemProperty((Object)eachPropertyId);
                    eachField.setValue((Object)((String)property.getValue()));
                }
            }
            this.setContainerDataSource((Container)container);
            this.setVisibleColumns(new Object[]{"selected", "name", "alias", "type"});
            Property itemProperty = parentItem.getItemProperty((Object)"selected");
            this.enableFields(this.fields.values(), (Boolean)itemProperty.getValue());
            if (((Boolean)itemProperty.getValue()).booleanValue()) {
                this.updateCheckBoxes();
            }
            this.validateFields(true);
        }
        finally {
            this.blockValidation = false;
        }
    }

    public SelectableBeanItemContainer<T> getContainerDataSource() {
        return (SelectableBeanItemContainer)super.getContainerDataSource();
    }

    private static Field<?> findFieldByKey(Map<Object[], Field<?>> inputMap, Object ... key) {
        for (Object[] eachKey : inputMap.keySet()) {
            if (!Arrays.equals(eachKey, key)) continue;
            return inputMap.get(eachKey);
        }
        return null;
    }

    private void enableFields(Collection<Field<?>> fields, boolean enabled) {
        for (Field<?> eachField : fields) {
            this.enableField(eachField, enabled);
        }
    }

    private void enableField(Field<?> field, boolean enabled) {
        field.setEnabled(enabled);
        if (!enabled) {
            field.discard();
            if (field instanceof AbstractComponent) {
                ((AbstractComponent)field).setComponentError(null);
            }
        }
    }

    @Override
    public void selectionValueChanged(SelectionValueChangedListener.SelectionValueChangedEvent selectionValueChangedEvent) {
        if (selectionValueChangedEvent.getBean() == this.getParentData()) {
            for (Object eachRowId : this.getItemIds()) {
                CheckBox checkBox = this.getCheckBoxForRow(eachRowId);
                this.updateCheckBox(checkBox, eachRowId, selectionValueChangedEvent.getNewValue());
                checkBox.setEnabled(selectionValueChangedEvent.getNewValue());
            }
        }
    }

    private void updateCheckBoxes() {
        for (Object eachRowId : this.getItemIds()) {
            CheckBox checkBox = this.getCheckBoxForRow(eachRowId);
            this.updateCheckBox(checkBox, eachRowId, (Boolean)checkBox.getValue());
        }
    }

    private void updateCheckBox(CheckBox checkBox, Object rowId, boolean enabled) {
        checkBox.setValue((Object)enabled);
        List<Field<?>> columns = this.getFieldsForItemId(rowId);
        columns.remove(checkBox);
        this.enableFields(columns, (Boolean)checkBox.getValue());
    }

    public void validate() throws Validator.InvalidValueException {
        super.validate();
        this.validateFields(false);
    }

    private void validateFields(boolean swallowValidationExceptions) throws Validator.InvalidValueException {
        Map filteredFieldsToValidate = Maps.filterEntries(this.aliasFieldsMap, (Predicate)new Predicate<Map.Entry<Object, Field<String>>>(){

            public boolean apply(Map.Entry<Object, Field<String>> input) {
                return AttributesTable.this.getContainerDataSource().isSelected(input.getKey());
            }
        });
        UIHelper.validateFields(new ArrayList(filteredFieldsToValidate.values()), swallowValidationExceptions);
    }

    public void discard() throws Buffered.SourceException {
        super.discard();
        for (Field<?> eachField : this.fields.values()) {
            eachField.discard();
        }
    }

    public boolean isValid() {
        try {
            this.validate();
            return true;
        }
        catch (Validator.InvalidValueException invex) {
            return false;
        }
    }

    boolean isDirty() {
        for (Field<?> eachField : this.fields.values()) {
            if (!eachField.isModified()) continue;
            return true;
        }
        return false;
    }

    private List<Field<?>> getFieldsForItemId(Object itemId) {
        ArrayList fieldList = new ArrayList();
        for (Map.Entry<Object[], Field<?>> eachEntry : this.fields.entrySet()) {
            if (!Objects.equals(itemId, eachEntry.getKey()[0])) continue;
            fieldList.add(eachEntry.getValue());
        }
        return fieldList;
    }

    private CheckBox getCheckBoxForRow(Object rowId) {
        for (Field<?> eachField : this.getFieldsForItemId(rowId)) {
            if (!(eachField instanceof CheckBox)) continue;
            return (CheckBox)eachField;
        }
        return null;
    }

    private Item getParentItem() {
        return this.parentItem;
    }

    private void setParentItem(Item parentItem) {
        this.parentItem = parentItem;
    }

    private Object getParentData() {
        return this.parentData;
    }

    private void setParentData(Object parentData) {
        this.parentData = parentData;
    }

    static /* synthetic */ NameProvider access$300(AttributesTable x0) {
        return x0.nameProvider;
    }

    private class AttributesTableFieldFactory
    implements TableFieldFactory {
        private final Validator nameValidator = new AttributeNameValidator();
        private final Validator lengthValidator = new StringLengthValidator(String.format("Maximum length is %d", 19), Integer.valueOf(0), Integer.valueOf(19), false);
        private final Validator uniqueAttributeNameValidator = new UniqueAttributeNameValidator(AttributesTable.access$300(AttributesTable.this), new UniqueAttributeNameValidator.FieldProvider(){

            @Override
            public Map<Object, Field<String>> getObjectFieldMap() {
                HashMap<Object, Field<String>> validationMap = new HashMap<Object, Field<String>>();
                for (Object eachSelectedAttribute : AttributesTable.this.getContainerDataSource().getSelectedAttributes()) {
                    validationMap.put(eachSelectedAttribute, (Field<String>)AttributesTable.this.aliasFieldsMap.get(eachSelectedAttribute));
                }
                return validationMap;
            }
        });

        private AttributesTableFieldFactory() {
        }

        public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
            TableTextFieldWrapper field = null;
            if ("alias".equals(propertyId.toString())) {
                field = new TableTextFieldWrapper(this.createAlias(itemId));
            }
            if ("name".equals(propertyId.toString())) {
                field = new TextField();
                field.setReadOnly(true);
            }
            if ("selected".equals(propertyId.toString())) {
                field = this.createSelected(itemId);
            }
            if ("type".equals(propertyId.toString())) {
                field = this.createType(itemId);
            }
            return field;
        }

        private CheckBox createSelected(final Object itemId) {
            final CheckBox c = new CheckBox();
            c.setBuffered(false);
            c.setImmediate(true);
            c.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent event) {
                    Collection fields = Collections2.filter((Collection)AttributesTable.this.getFieldsForItemId(itemId), (Predicate)new Predicate<Field<?>>(){

                        public boolean apply(Field<?> eachField) {
                            return eachField != c;
                        }
                    });
                    AttributesTable.this.enableFields(fields, (Boolean)c.getValue());
                }
            });
            c.addValueChangeListener(AttributesTable.this.validateOnValueChangeListener);
            return c;
        }

        private ComboBox createType(Object itemId) {
            ComboBox select = new ComboBox();
            for (MetaAttribItem.AttribType type : MetaAttribItem.AttribType.values()) {
                select.addItem((Object)type.name());
            }
            select.setValue((Object)MetaAttribItem.AttribType.gauge);
            select.setNullSelectionAllowed(false);
            select.setData(itemId);
            select.setBuffered(false);
            select.setImmediate(true);
            select.addValueChangeListener(AttributesTable.this.validateOnValueChangeListener);
            return select;
        }

        private TextField createAlias(Object itemId) {
            final TextField tf = new TextField();
            tf.setValidationVisible(false);
            tf.setBuffered(false);
            tf.setImmediate(true);
            tf.setRequired(true);
            tf.setWidth(300.0f, Sizeable.Unit.PIXELS);
            tf.setMaxLength(19);
            tf.setRequiredError("You must provide a name.");
            tf.addValidator(this.nameValidator);
            tf.addValidator(this.lengthValidator);
            tf.addValidator(this.uniqueAttributeNameValidator);
            tf.addValueChangeListener(AttributesTable.this.validateOnValueChangeListener);
            tf.setData(itemId);
            tf.setTextChangeTimeout(200);
            tf.addTextChangeListener(new FieldEvents.TextChangeListener(){

                public void textChange(FieldEvents.TextChangeEvent event) {
                    tf.setValue(event.getText());
                    UIHelper.validateField(tf, true);
                }
            });
            return tf;
        }
    }

    private class ReferenceTableFieldFactory
    implements TableFieldFactory {
        private ReferenceTableFieldFactory() {
        }

        public Field<?> createField(Container container, Object itemId, Object propertyId, Component uiContext) {
            Object[] key = AttributesTable.computeKey(new Object[]{itemId, propertyId});
            Field field = AttributesTable.findFieldByKey(AttributesTable.this.fields, key);
            return field;
        }
    }
}

