/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation;

import com.vaadin.data.validator.AbstractStringValidator;
import com.vaadin.ui.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.NameProvider;

public class UniqueAttributeNameValidator
extends AbstractStringValidator {
    private final NameProvider provider;
    private final FieldProvider fieldProvider;

    public UniqueAttributeNameValidator(NameProvider nameProvider, FieldProvider fieldProvider) {
        super("The attribute name must be unique in whole collection!");
        this.provider = nameProvider;
        this.fieldProvider = fieldProvider;
    }

    public UniqueAttributeNameValidator(NameProvider provider) {
        this(provider, null);
    }

    protected List<String> getNames() {
        Map<Object, String> objectToNameMap = this.provider.getNamesMap();
        if (this.fieldProvider == null) {
            return new ArrayList<String>(objectToNameMap.values());
        }
        HashMap<Object, String> clonedMap = new HashMap<Object, String>(objectToNameMap);
        Map<Object, Field<String>> fieldValuesToMerge = this.fieldProvider.getObjectFieldMap();
        for (Map.Entry<Object, Field<String>> eachEntry : fieldValuesToMerge.entrySet()) {
            clonedMap.put(eachEntry.getKey(), (String)eachEntry.getValue().getValue());
        }
        return new ArrayList<String>(clonedMap.values());
    }

    protected boolean isValidValue(String value) {
        if (value != null) {
            List<String> names = this.getNames();
            if (!names.contains(value)) {
                return true;
            }
            names.remove(value);
            return !names.contains(value);
        }
        return false;
    }

    public static interface FieldProvider {
        public Map<Object, Field<String>> getObjectFieldMap();
    }
}

