/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui;

import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.PopupView;
import org.opennms.features.vaadin.jmxconfiggenerator.Config;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.HelpContent;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UIHelper;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;

public class HeaderPanel
extends Panel
implements View {
    private PopupView helpPopupView;
    private Label label = new Label();

    public HeaderPanel() {
        this.label.setContentMode(ContentMode.HTML);
        this.helpPopupView = new PopupView((PopupView.Content)new HelpContent(UiState.ServiceConfigurationView));
        this.helpPopupView.setVisible(false);
        this.helpPopupView.setPopupVisible(false);
        Button popupButton = UIHelper.createButton("", "help", Config.Icons.HELP, new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                HeaderPanel.this.helpPopupView.setPopupVisible(true);
                HeaderPanel.this.helpPopupView.setVisible(true);
            }
        });
        HorizontalLayout layout = new HorizontalLayout();
        layout.setSpacing(true);
        layout.setMargin(true);
        layout.addComponent((Component)popupButton);
        layout.addComponent((Component)this.helpPopupView);
        layout.addComponent((Component)this.label);
        layout.setComponentAlignment((Component)this.label, Alignment.MIDDLE_LEFT);
        this.setContent((Component)layout);
    }

    private void updateLabel(String viewName) {
        this.label.setValue(this.generateLabel(viewName));
        UiState uiState = UiState.valueOf(viewName);
        if (uiState.hasUi()) {
            this.helpPopupView.setContent((PopupView.Content)new HelpContent(UiState.valueOf(viewName)));
        }
    }

    protected String generateLabel(String viewName) {
        String selected = "<a href=\"#!%s\">%d. %s</a>";
        String notSelected = "%d. %s";
        StringBuilder labelString = new StringBuilder(100);
        int i = 1;
        for (UiState eachState : UiState.values()) {
            String labelSegment;
            if (!eachState.hasUi()) continue;
            String string = labelSegment = eachState.name().equals(viewName) ? String.format("<a href=\"#!%s\">%d. %s</a>", eachState.name(), i, eachState.getDescription()) : String.format("%d. %s", i, eachState.getDescription());
            if (labelString.length() > 0) {
                labelString.append(" / ");
            }
            labelString.append(labelSegment);
            ++i;
        }
        return labelString.toString().trim();
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
        this.updateLabel(event.getViewName());
    }
}

