/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.jobs;

import com.vaadin.ui.Notification;
import com.vaadin.ui.UI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UIHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    private static final Logger LOG = LoggerFactory.getLogger(JobManager.class);
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private Future<?> runningJob;

    public void enqueue(Task task) {
        if (this.runningJob != null && !this.runningJob.isDone()) {
            LOG.warn("A job is already running. Try cancelling...");
            boolean success = this.runningJob.cancel(true);
            LOG.warn("Job was cancelled: {}", (Object)success);
        }
        this.runningJob = this.executorService.submit(new TaskRunnable(task));
    }

    public void cancelAllJobs() {
        if (this.runningJob != null) {
            this.runningJob.cancel(true);
            if (!this.runningJob.isDone()) {
                LOG.error("The currently running Job could not be stopped.", this.runningJob);
            }
        }
    }

    public static interface Task<T> {
        public T execute() throws TaskRunException;

        public void onSuccess(T var1);

        public void onError();
    }

    public static class TaskRunException
    extends Exception {
        private String shortDescription;

        public TaskRunException(String shortDescription, String message, Throwable cause) {
            super(message, cause);
            this.shortDescription = shortDescription;
        }

        public String getShortDescription() {
            return this.shortDescription;
        }

        public TaskRunException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class TaskRunnable
    implements Runnable {
        private final Task taskToRun;

        private TaskRunnable(Task taskToRun) {
            this.taskToRun = taskToRun;
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            try {
                final Object result = this.taskToRun.execute();
                UI.getCurrent().access(new Runnable(){

                    @Override
                    public void run() {
                        UIHelper.getCurrent().hideProgressWindow();
                        taskToRun.onSuccess(result);
                    }
                });
            }
            catch (TaskRunException trex) {
                this.handleError(trex);
                UI.getCurrent().access(new Runnable(this){
                    final /* synthetic */ TaskRunnable this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        UIHelper.getCurrent().hideProgressWindow();
                    }
                });
            }
            catch (Exception ex) {
                this.handleError(ex);
                {
                    catch (Throwable throwable) {
                        UI.getCurrent().access(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                UI.getCurrent().access(new /* invalid duplicate definition of identical inner class */);
            }
            UI.getCurrent().access(new /* invalid duplicate definition of identical inner class */);
        }

        private void handleError(final TaskRunException trex) {
            UI.getCurrent().access(new Runnable(){

                @Override
                public void run() {
                    LOG.error(trex.getMessage(), trex.getCause());
                    StringBuilder errorMessage = new StringBuilder(100);
                    errorMessage.append(trex.getMessage());
                    if (trex.getCause() != null) {
                        errorMessage.append("<br/><br/>").append(trex.getCause().getMessage());
                    }
                    UIHelper.showNotification(trex.getShortDescription() != null ? trex.getShortDescription() : "Error", errorMessage.toString().trim(), Notification.Type.ERROR_MESSAGE, 5000);
                    taskToRun.onError();
                }
            });
        }

        private void handleError(final Exception ex) {
            UI.getCurrent().access(new Runnable(){

                @Override
                public void run() {
                    LOG.error("Unknown Error occurred", (Throwable)ex);
                    UIHelper.showNotification("Unknown Error", ex.getMessage(), Notification.Type.ERROR_MESSAGE);
                    taskToRun.onError();
                }
            });
        }
    }
}

