/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui;

import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.Validator;
import com.vaadin.data.fieldgroup.FieldGroup;
import com.vaadin.data.util.BeanItem;
import com.vaadin.data.util.converter.Converter;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.navigator.View;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Field;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.vaadin.jmxconfiggenerator.JmxConfigGeneratorUI;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.ButtonPanel;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UIHelper;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;

public class ConfigView
extends VerticalLayout
implements View,
Button.ClickListener {
    private static final long serialVersionUID = -9179098093927051983L;
    private final ConfigForm configForm;
    private final JmxConfigGeneratorUI app;
    private final ButtonPanel buttonPanel;

    public ConfigView(JmxConfigGeneratorUI app) {
        this.app = app;
        this.configForm = new ConfigForm();
        this.buttonPanel = new ButtonPanel(this);
        this.buttonPanel.getPrevious().setVisible(false);
        this.addComponent((Component)this.configForm);
        this.addComponent((Component)this.buttonPanel);
        this.setExpandRatio((Component)this.configForm, 1.0f);
        this.setSizeFull();
    }

    public void enter(ViewChangeListener.ViewChangeEvent event) {
    }

    public void buttonClick(Button.ClickEvent event) {
        if (this.buttonPanel.getNext().equals(event.getButton())) {
            if (!this.configForm.configFieldGroup.isValid()) {
                UIHelper.showValidationError("There are still errors on this page. You cannot continue. Please check if all required fields have been filled.");
                return;
            }
            try {
                this.configForm.configFieldGroup.commit();
                this.app.updateView(UiState.MbeansDetection);
            }
            catch (FieldGroup.CommitException e) {
                UIHelper.showNotification("An unexpected error occurred.");
            }
        }
    }

    private class ConfigForm
    extends FormLayout {
        private FieldGroup configFieldGroup = new FieldGroup();

        public ConfigForm() {
            this.configFieldGroup.setItemDataSource((Item)new BeanItem((Object)UIHelper.getCurrent().getUiModel().getServiceConfig()));
            this.initFields();
            this.updateAuthenticationFields(false);
            this.setImmediate(true);
            this.setMargin(true);
            this.setSpacing(true);
        }

        private void updateAuthenticationFields(boolean visible) throws Property.ReadOnlyException, Converter.ConversionException {
            this.configFieldGroup.getField((Object)"authenticate").setValue((Object)visible);
            this.configFieldGroup.getField((Object)"user").setVisible(visible);
            this.configFieldGroup.getField((Object)"password").setVisible(visible);
            if (!visible) {
                this.configFieldGroup.getField((Object)"user").setValue(null);
                this.configFieldGroup.getField((Object)"password").setValue(null);
            }
        }

        private void initFields() {
            CheckBox authenticateField = new CheckBox();
            authenticateField.setCaption("Authentication");
            authenticateField.addValueChangeListener(new Property.ValueChangeListener(){

                public void valueChange(Property.ValueChangeEvent event) {
                    ConfigForm.this.updateAuthenticationFields((Boolean)event.getProperty().getValue());
                }
            });
            authenticateField.setDescription("Connection requires authentication");
            TextField userField = new TextField();
            userField.setCaption("User");
            userField.setNullRepresentation("");
            userField.setDescription("Username for JMX-RMI Authentication");
            PasswordField passwordField = new PasswordField();
            passwordField.setCaption("Password");
            passwordField.setNullRepresentation("");
            passwordField.setDescription("Password for JMX-RMI Authentication");
            TextField serviceNameField = new TextField();
            serviceNameField.setCaption("Service name");
            serviceNameField.setNullRepresentation("");
            serviceNameField.setRequired(true);
            serviceNameField.setRequiredError("required");
            serviceNameField.addValidator((Validator)new RegexpValidator("^[A-Za-z0-9_-]+$", "You must specify a valid name. Allowed characters: (A-Za-z0-9_-)"));
            serviceNameField.setDescription("The service name of the JMX data collection config, e.g. cassandra, jboss, tomcat");
            TextField hostNameField = new TextField();
            hostNameField.setCaption("Host");
            hostNameField.setRequired(true);
            hostNameField.setRequiredError("required");
            hostNameField.setDescription("Hostname or ip address of JMX-RMI host");
            TextField portField = new TextField();
            portField.setCaption("Port");
            portField.setRequired(true);
            portField.setRequiredError("required");
            portField.setId("port");
            portField.setDescription("Port of JMX-RMI service");
            this.addComponent((Component)serviceNameField);
            this.addComponent((Component)hostNameField);
            this.addComponent((Component)portField);
            this.addComponent((Component)authenticateField);
            this.addComponent((Component)userField);
            this.addComponent((Component)passwordField);
            Field skipDefaultVMField = this.configFieldGroup.buildAndBind((Object)"skipDefaultVM");
            skipDefaultVMField.setCaption("Skip JVM MBeans");
            skipDefaultVMField.setId("skipDefaultVM");
            ((AbstractComponent)skipDefaultVMField).setDescription("Set to include/exclude default JavaVM MBeans");
            this.addComponent((Component)skipDefaultVMField);
            Field runWritableMbeansField = this.configFieldGroup.buildAndBind((Object)"runWritableMBeans");
            runWritableMbeansField.setCaption("Run writable MBeans");
            ((AbstractComponent)runWritableMbeansField).setDescription("By default writable MBeans are not included, even if they are readable. Enable to exclude/include writable MBeans as well.");
            this.addComponent((Component)runWritableMbeansField);
            Field jmxMpField = this.configFieldGroup.buildAndBind((Object)"jmxmp");
            jmxMpField.setCaption("JMXMP");
            ((AbstractComponent)jmxMpField).setDescription("Use JMXMP instead of JMX-RMI");
            this.addComponent((Component)jmxMpField);
            this.configFieldGroup.bind((Field)serviceNameField, (Object)"serviceName");
            this.configFieldGroup.bind((Field)hostNameField, (Object)"host");
            this.configFieldGroup.bind((Field)portField, (Object)"port");
            this.configFieldGroup.bind((Field)passwordField, (Object)"password");
            this.configFieldGroup.bind((Field)authenticateField, (Object)"authenticate");
            this.configFieldGroup.bind((Field)userField, (Object)"user");
        }
    }
}

