/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.jobs;

import java.io.IOException;
import java.util.Collection;
import org.opennms.features.jmxconfiggenerator.graphs.GraphConfigGenerator;
import org.opennms.features.jmxconfiggenerator.graphs.JmxConfigReader;
import org.opennms.features.vaadin.jmxconfiggenerator.data.UiModel;
import org.opennms.features.vaadin.jmxconfiggenerator.jobs.JobManager;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UIHelper;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.UiState;

public class GenerateConfigsJob
implements JobManager.Task {
    private final UiModel model;

    public GenerateConfigsJob(UiModel model) {
        this.model = model;
    }

    public Void execute() throws JobManager.TaskRunException {
        try {
            GraphConfigGenerator graphConfigGenerator = new GraphConfigGenerator();
            Collection reports = new JmxConfigReader().generateReportsByJmxDatacollectionConfig(this.model.getOutputConfig());
            this.model.setSnmpGraphProperties(graphConfigGenerator.generateSnmpGraph(reports));
            this.model.updateOutput();
            return null;
        }
        catch (IOException ex) {
            throw new JobManager.TaskRunException("SNMP Graph-Properties couldn't be created.", ex);
        }
    }

    public void onSuccess(Object result) {
        UIHelper.updateView(UiState.ResultView);
    }

    @Override
    public void onError() {
    }
}

