/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Component;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class UrlDashlet
extends AbstractDashlet {
    private DashletComponent m_dashletComponent;

    public UrlDashlet(String name, DashletSpec dashletSpec) {
        super(name, dashletSpec);
    }

    public DashletComponent getWallboardComponent() {
        if (this.m_dashletComponent == null) {
            this.m_dashletComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(UrlDashlet.this.getName());
                    this.m_verticalLayout.setSizeFull();
                }

                public void refresh() {
                    this.m_verticalLayout.removeAllComponents();
                    String url = "";
                    String username = "";
                    String password = "";
                    if (UrlDashlet.this.getDashletSpec().getParameters().containsKey("url")) {
                        url = (String)UrlDashlet.this.getDashletSpec().getParameters().get("url");
                    }
                    if (UrlDashlet.this.getDashletSpec().getParameters().containsKey("username")) {
                        username = (String)UrlDashlet.this.getDashletSpec().getParameters().get("username");
                    }
                    if (UrlDashlet.this.getDashletSpec().getParameters().containsKey("password")) {
                        password = (String)UrlDashlet.this.getDashletSpec().getParameters().get("password");
                    }
                    String usernamePassword = "";
                    if (!"".equals(username) && !"".equals(password)) {
                        usernamePassword = username + ":" + password;
                    }
                    if (!"".equals(url)) {
                        URL parsedUrl = null;
                        try {
                            parsedUrl = new URL(url);
                        }
                        catch (MalformedURLException e) {
                            this.m_verticalLayout.addComponent((Component)new Label("MalformedURLException: " + e.getMessage()));
                            return;
                        }
                        URL urlWithAuth = null;
                        try {
                            urlWithAuth = new URI(parsedUrl.getProtocol(), usernamePassword, parsedUrl.getHost(), parsedUrl.getPort() == -1 ? parsedUrl.getDefaultPort() : parsedUrl.getPort(), parsedUrl.getPath(), parsedUrl.getQuery(), parsedUrl.getRef()).toURL();
                        }
                        catch (MalformedURLException e) {
                            this.m_verticalLayout.addComponent((Component)new Label("MalformedURLException: " + e.getMessage()));
                            return;
                        }
                        catch (URISyntaxException e) {
                            this.m_verticalLayout.addComponent((Component)new Label("URISyntaxException: " + e.getMessage()));
                            return;
                        }
                        BrowserFrame browserFrame = new BrowserFrame(null, (Resource)new ExternalResource(urlWithAuth));
                        browserFrame.setSizeFull();
                        this.m_verticalLayout.addComponent((Component)browserFrame);
                    } else {
                        this.m_verticalLayout.addComponent((Component)new Label("No URL specified!"));
                    }
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_dashletComponent;
    }

    public DashletComponent getDashboardComponent() {
        return this.getWallboardComponent();
    }
}

