/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.ui.BrowserFrame;
import com.vaadin.ui.Component;
import com.vaadin.ui.VerticalLayout;
import org.opennms.features.topology.link.TopologyLinkBuilder;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class TopologyDashlet
extends AbstractDashlet {
    private DashletComponent m_dashletComponent;

    public TopologyDashlet(String name, DashletSpec dashletSpec) {
        super(name, dashletSpec);
    }

    public DashletComponent getWallboardComponent() {
        if (this.m_dashletComponent == null) {
            this.m_dashletComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(TopologyDashlet.this.getName());
                    this.m_verticalLayout.setSizeFull();
                }

                public void refresh() {
                    this.m_verticalLayout.removeAllComponents();
                    TopologyLinkBuilder linkBuilder = new TopologyLinkBuilder();
                    if (TopologyDashlet.this.getDashletSpec().getParameters().containsKey("focusNodes")) {
                        linkBuilder.focus(((String)TopologyDashlet.this.getDashletSpec().getParameters().get("focusNodes")).split(","));
                    }
                    if (TopologyDashlet.this.getDashletSpec().getParameters().containsKey("szl")) {
                        linkBuilder.szl(Integer.valueOf((String)TopologyDashlet.this.getDashletSpec().getParameters().get("szl")).intValue());
                    }
                    if (TopologyDashlet.this.getDashletSpec().getParameters().containsKey("provider")) {
                        linkBuilder.provider(() -> (String)TopologyDashlet.this.getDashletSpec().getParameters().get("provider"));
                    }
                    BrowserFrame browserFrame = new BrowserFrame(null, (Resource)new ExternalResource(linkBuilder.getLink()));
                    browserFrame.setSizeFull();
                    this.m_verticalLayout.addComponent((Component)browserFrame);
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_dashletComponent;
    }

    public DashletComponent getDashboardComponent() {
        return this.getWallboardComponent();
    }
}

