/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Accordion;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;

public class SummaryDashlet
extends AbstractDashlet {
    private AlarmDao m_alarmDao;
    private long m_timeslot = 3600L;
    private boolean m_boosted = false;
    private static int TREND_NORTH = 4;
    private static int TREND_NORTHEAST = 3;
    private static int TREND_EAST = 2;
    private static int TREND_SOUTHEAST = 1;
    private static int TREND_SOUTH = 0;
    private DashletComponent m_dashboardComponent;
    private DashletComponent m_wallboardComponent;

    public SummaryDashlet(String name, DashletSpec dashletSpec, AlarmDao alarmDao) {
        super(name, dashletSpec);
        this.m_alarmDao = alarmDao;
    }

    public String getHumanReadableFormat(long secondsAll) {
        long rest;
        long seconds = secondsAll;
        long minutes = 0L;
        long hours = 0L;
        long days = 0L;
        if (seconds / 60L > 0L) {
            rest = seconds % 60L;
            minutes = seconds / 60L;
            seconds = rest;
        }
        if (minutes / 60L > 0L) {
            rest = minutes % 60L;
            hours = minutes / 60L;
            minutes = rest;
        }
        if (hours / 24L > 0L) {
            rest = hours % 24L;
            days = hours / 24L;
            hours = rest;
        }
        String output = "";
        if (days > 0L) {
            output = output + days + "d";
        }
        if (hours > 0L) {
            output = output + hours + "h";
        }
        if (minutes > 0L) {
            output = output + minutes + "m";
        }
        if (seconds > 0L) {
            output = output + seconds + "s";
        }
        return output;
    }

    private int computeTrend(int ack, int notAck) {
        if (ack == notAck) {
            return TREND_EAST;
        }
        if (notAck == 0) {
            return TREND_NORTH;
        }
        if (ack == 0) {
            return TREND_NORTH;
        }
        double ratio = (double)ack / (double)notAck;
        if (ratio < 0.5) {
            return TREND_SOUTH;
        }
        if (ratio < 1.0) {
            return TREND_SOUTHEAST;
        }
        if (ratio > 2.0) {
            return TREND_NORTH;
        }
        return TREND_NORTHEAST;
    }

    private Component getLegend(String entity) {
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setSpacing(true);
        horizontalLayout.addStyleName("summary");
        horizontalLayout.addStyleName("global");
        Label labelx = new Label(entity);
        labelx.addStyleName("summary-font-legend");
        Image ackdImage = new Image(null, (Resource)new ThemeResource("img/acknowledged.png"));
        ackdImage.setWidth(16.0f, Sizeable.Unit.PIXELS);
        Image unackdImage = new Image(null, (Resource)new ThemeResource("img/unacknowledged.png"));
        unackdImage.setWidth(16.0f, Sizeable.Unit.PIXELS);
        Label dummyLabel = new Label();
        dummyLabel.setWidth(32.0f, Sizeable.Unit.PIXELS);
        horizontalLayout.addComponent((Component)labelx);
        horizontalLayout.addComponent((Component)ackdImage);
        horizontalLayout.addComponent((Component)unackdImage);
        horizontalLayout.addComponent((Component)dummyLabel);
        horizontalLayout.setComponentAlignment((Component)ackdImage, Alignment.TOP_RIGHT);
        horizontalLayout.setComponentAlignment((Component)unackdImage, Alignment.TOP_RIGHT);
        horizontalLayout.setExpandRatio((Component)labelx, 4.0f);
        horizontalLayout.setExpandRatio((Component)ackdImage, 1.0f);
        horizontalLayout.setExpandRatio((Component)unackdImage, 1.0f);
        horizontalLayout.setExpandRatio((Component)dummyLabel, 1.0f);
        horizontalLayout.setWidth(375.0f, Sizeable.Unit.PIXELS);
        return horizontalLayout;
    }

    private Component getComponentSeverity(int width) {
        VerticalLayout verticalLayout = new VerticalLayout();
        int overallSum = 0;
        int severitySum = 0;
        verticalLayout.addComponent(this.getLegend("Severity"));
        for (OnmsSeverity onmsSeverity : OnmsSeverity.values()) {
            HorizontalLayout horizontalLayout = new HorizontalLayout();
            horizontalLayout.setSpacing(true);
            horizontalLayout.addStyleName("summary");
            horizontalLayout.addStyleName(onmsSeverity.name().toLowerCase());
            int acknowledged = this.countBySeverity(true, this.m_timeslot, onmsSeverity);
            int notAcknowledged = this.countBySeverity(false, this.m_timeslot, onmsSeverity);
            Label labelSeverity = new Label(onmsSeverity.getLabel());
            labelSeverity.addStyleName("summary-font");
            Label labelAcknowledge = new Label(String.valueOf(acknowledged));
            labelAcknowledge.addStyleName("summary-font");
            Label labelNotAcknowledged = new Label(String.valueOf(notAcknowledged));
            labelNotAcknowledged.addStyleName("summary-font");
            horizontalLayout.addComponent((Component)labelSeverity);
            horizontalLayout.addComponent((Component)labelAcknowledge);
            horizontalLayout.addComponent((Component)labelNotAcknowledged);
            int status = this.computeTrend(acknowledged, notAcknowledged);
            severitySum += onmsSeverity.getId();
            overallSum += onmsSeverity.getId() * status;
            Image image = new Image(null, (Resource)new ThemeResource("img/a" + status + ".png"));
            image.setWidth((float)width, Sizeable.Unit.PIXELS);
            horizontalLayout.addComponent((Component)image);
            horizontalLayout.setExpandRatio((Component)labelSeverity, 4.0f);
            horizontalLayout.setExpandRatio((Component)labelAcknowledge, 1.0f);
            horizontalLayout.setExpandRatio((Component)labelNotAcknowledged, 1.0f);
            horizontalLayout.setExpandRatio((Component)image, 1.0f);
            horizontalLayout.setComponentAlignment((Component)image, Alignment.TOP_CENTER);
            horizontalLayout.setWidth(375.0f, Sizeable.Unit.PIXELS);
            verticalLayout.addComponent((Component)horizontalLayout);
        }
        int globalTrend = (int)Math.max(0L, Math.min(4L, Math.round((double)overallSum / (double)severitySum)));
        Image image = new Image(null, (Resource)new ThemeResource("img/a" + globalTrend + ".png"));
        image.setWidth((float)(width * 8), Sizeable.Unit.PIXELS);
        VerticalLayout globalTrendLayout = new VerticalLayout();
        globalTrendLayout.setSpacing(true);
        globalTrendLayout.addStyleName("summary");
        globalTrendLayout.addStyleName("global");
        globalTrendLayout.setSizeFull();
        Label labelTitle = new Label("Alarms trend by severity");
        labelTitle.addStyleName("summary-font");
        labelTitle.setSizeUndefined();
        Label labelTimeslot = new Label("(" + this.getHumanReadableFormat(this.m_timeslot) + ")");
        labelTimeslot.addStyleName("summary-font");
        labelTimeslot.setSizeUndefined();
        globalTrendLayout.addComponent((Component)labelTitle);
        globalTrendLayout.addComponent((Component)labelTimeslot);
        globalTrendLayout.addComponent((Component)image);
        globalTrendLayout.setWidth(375.0f, Sizeable.Unit.PIXELS);
        globalTrendLayout.setComponentAlignment((Component)labelTitle, Alignment.MIDDLE_CENTER);
        globalTrendLayout.setComponentAlignment((Component)labelTimeslot, Alignment.MIDDLE_CENTER);
        globalTrendLayout.setComponentAlignment((Component)image, Alignment.MIDDLE_CENTER);
        globalTrendLayout.setExpandRatio((Component)labelTitle, 1.0f);
        verticalLayout.addComponent((Component)globalTrendLayout, 0);
        this.m_boosted = globalTrend > 2;
        return verticalLayout;
    }

    private Component getComponentUei(int width) {
        VerticalLayout verticalLayout = new VerticalLayout();
        int overallSum = 0;
        int severitySum = 0;
        verticalLayout.addComponent(this.getLegend("UEI"));
        String[] ueis = new String[]{"uei.opennms.org/nodes/nodeLostService", "uei.opennms.org/nodes/interfaceDown", "uei.opennms.org/nodes/nodeDown"};
        for (int i = 0; i < ueis.length; ++i) {
            String uei = ueis[i];
            HorizontalLayout horizontalLayout = new HorizontalLayout();
            horizontalLayout.setSpacing(true);
            horizontalLayout.addStyleName("summary");
            if (i == 0) {
                horizontalLayout.addStyleName(OnmsSeverity.MINOR.name().toLowerCase());
            } else if (i == 1) {
                horizontalLayout.addStyleName(OnmsSeverity.MINOR.name().toLowerCase());
            } else {
                horizontalLayout.addStyleName(OnmsSeverity.MAJOR.name().toLowerCase());
            }
            int acknowledged = this.countByUei(true, this.m_timeslot, uei);
            int notAcknowledged = this.countByUei(false, this.m_timeslot, uei);
            Label labelSeverity = new Label(uei.replace("uei.opennms.org/nodes/", ""));
            labelSeverity.addStyleName("summary-font");
            Label labelAcknowledge = new Label(String.valueOf(acknowledged));
            labelAcknowledge.addStyleName("summary-font");
            Label labelNotAcknowledged = new Label(String.valueOf(notAcknowledged));
            labelNotAcknowledged.addStyleName("summary-font");
            horizontalLayout.addComponent((Component)labelSeverity);
            horizontalLayout.addComponent((Component)labelAcknowledge);
            horizontalLayout.addComponent((Component)labelNotAcknowledged);
            int status = this.computeTrend(acknowledged, notAcknowledged);
            severitySum += i;
            overallSum += i * status;
            Image image = new Image(null, (Resource)new ThemeResource("img/a" + status + ".png"));
            image.setWidth((float)width, Sizeable.Unit.PIXELS);
            horizontalLayout.addComponent((Component)image);
            horizontalLayout.setExpandRatio((Component)labelSeverity, 4.0f);
            horizontalLayout.setExpandRatio((Component)labelAcknowledge, 1.0f);
            horizontalLayout.setExpandRatio((Component)labelNotAcknowledged, 1.0f);
            horizontalLayout.setExpandRatio((Component)image, 1.0f);
            horizontalLayout.setComponentAlignment((Component)image, Alignment.TOP_CENTER);
            horizontalLayout.setWidth(375.0f, Sizeable.Unit.PIXELS);
            verticalLayout.addComponent((Component)horizontalLayout);
        }
        int globalTrend = (int)Math.max(0L, Math.min(4L, Math.round((double)overallSum / (double)severitySum)));
        Image image = new Image(null, (Resource)new ThemeResource("img/a" + globalTrend + ".png"));
        image.setWidth((float)(width * 8), Sizeable.Unit.PIXELS);
        VerticalLayout globalTrendLayout = new VerticalLayout();
        globalTrendLayout.setSpacing(true);
        globalTrendLayout.addStyleName("summary");
        globalTrendLayout.addStyleName("global");
        globalTrendLayout.setSizeFull();
        Label labelTitle = new Label("Alarms trend by UEI");
        labelTitle.addStyleName("summary-font");
        labelTitle.setSizeUndefined();
        Label labelTimeslot = new Label("(" + this.getHumanReadableFormat(this.m_timeslot) + ")");
        labelTimeslot.addStyleName("summary-font");
        labelTimeslot.setSizeUndefined();
        globalTrendLayout.addComponent((Component)labelTitle);
        globalTrendLayout.addComponent((Component)labelTimeslot);
        globalTrendLayout.addComponent((Component)image);
        globalTrendLayout.setWidth(375.0f, Sizeable.Unit.PIXELS);
        globalTrendLayout.setComponentAlignment((Component)labelTitle, Alignment.MIDDLE_CENTER);
        globalTrendLayout.setComponentAlignment((Component)labelTimeslot, Alignment.MIDDLE_CENTER);
        globalTrendLayout.setComponentAlignment((Component)image, Alignment.MIDDLE_CENTER);
        globalTrendLayout.setExpandRatio((Component)labelTitle, 1.0f);
        verticalLayout.addComponent((Component)globalTrendLayout, 0);
        this.m_boosted = globalTrend > 2;
        return verticalLayout;
    }

    public int countBySeverity(boolean acknowledged, long age, OnmsSeverity onmsSeverity) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class);
        if (acknowledged) {
            criteriaBuilder.isNotNull("alarmAckUser");
        } else {
            criteriaBuilder.isNull("alarmAckUser");
        }
        criteriaBuilder.eq("severity", (Object)onmsSeverity);
        criteriaBuilder.sql("EXTRACT(EPOCH FROM CURRENT_TIMESTAMP - lastEventTime) < " + age);
        return this.m_alarmDao.countMatching(criteriaBuilder.toCriteria());
    }

    public int countByUei(boolean acknowledged, long age, String uei) {
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsAlarm.class);
        if (acknowledged) {
            criteriaBuilder.isNotNull("alarmAckUser");
        } else {
            criteriaBuilder.isNull("alarmAckUser");
        }
        criteriaBuilder.eq("uei", (Object)uei);
        criteriaBuilder.sql("EXTRACT(EPOCH FROM CURRENT_TIMESTAMP - lastEventTime) < " + age);
        return this.m_alarmDao.countMatching(criteriaBuilder.toCriteria());
    }

    public DashletComponent getWallboardComponent() {
        if (this.m_wallboardComponent == null) {
            this.m_wallboardComponent = new AbstractDashletComponent(){
                private HorizontalLayout m_horizontalLayout = new HorizontalLayout();
                {
                    this.m_horizontalLayout.setCaption(SummaryDashlet.this.getName());
                    this.m_horizontalLayout.setSizeFull();
                }

                private void injectWallboardStyles() {
                    Page.getCurrent().getStyles().add(".summary.cleared { background: #000000; border-left: 15px solid #858585; }");
                    Page.getCurrent().getStyles().add(".summary.normal { background: #000000; border-left: 15px solid #336600; }");
                    Page.getCurrent().getStyles().add(".summary.indeterminate {  background: #000000; border-left: 15px solid #999; }");
                    Page.getCurrent().getStyles().add(".summary.warning { background: #000000; border-left: 15px solid #FFCC00; }");
                    Page.getCurrent().getStyles().add(".summary.minor { background: #000000;  border-left: 15px solid #FF9900; }");
                    Page.getCurrent().getStyles().add(".summary.major { background: #000000; border-left: 15px solid #FF3300; }");
                    Page.getCurrent().getStyles().add(".summary.critical { background: #000000; border-left: 15px solid #CC0000; }");
                    Page.getCurrent().getStyles().add(".summary.global { background: #000000; border-left: 15px solid #000000; }");
                    Page.getCurrent().getStyles().add(".summary { padding: 5px 5px; margin: 1px; }");
                    Page.getCurrent().getStyles().add(".summary-font { font-size: 24px; line-height: normal; text-align: right; color: #3ba300; }");
                    Page.getCurrent().getStyles().add(".summary-font-legend { font-size: 16px; line-height: normal; text-align: right; color: #3ba300; }");
                }

                public void refresh() {
                    SummaryDashlet.this.m_timeslot = 3600L;
                    try {
                        SummaryDashlet.this.m_timeslot = Math.max(1, Integer.parseInt((String)SummaryDashlet.this.getDashletSpec().getParameters().get("timeslot")));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.m_horizontalLayout.removeAllComponents();
                    this.injectWallboardStyles();
                    Component severity = SummaryDashlet.this.getComponentSeverity(32);
                    Component uei = SummaryDashlet.this.getComponentUei(32);
                    this.m_horizontalLayout.addComponent(severity);
                    this.m_horizontalLayout.addComponent(uei);
                    this.m_horizontalLayout.setSizeFull();
                    this.m_horizontalLayout.setComponentAlignment(severity, Alignment.TOP_CENTER);
                    this.m_horizontalLayout.setComponentAlignment(uei, Alignment.TOP_CENTER);
                }

                public Component getComponent() {
                    return this.m_horizontalLayout;
                }

                public boolean isBoosted() {
                    return SummaryDashlet.this.m_boosted;
                }
            };
        }
        return this.m_wallboardComponent;
    }

    public DashletComponent getDashboardComponent() {
        if (this.m_dashboardComponent == null) {
            this.m_dashboardComponent = new AbstractDashletComponent(){
                private HorizontalLayout m_horizontalLayout = new HorizontalLayout();
                {
                    this.m_horizontalLayout.setCaption(SummaryDashlet.this.getName());
                    this.m_horizontalLayout.setSizeFull();
                }

                private void injectDashboardStyles() {
                    Page.getCurrent().getStyles().add(".summary.cleared { background: #000000; border-left: 8px solid #858585; }");
                    Page.getCurrent().getStyles().add(".summary.normal { background: #000000; border-left: 8px solid #336600; }");
                    Page.getCurrent().getStyles().add(".summary.indeterminate {  background: #000000; border-left: 8px solid #999; }");
                    Page.getCurrent().getStyles().add(".summary.warning { background: #000000; border-left: 8px solid #FFCC00; }");
                    Page.getCurrent().getStyles().add(".summary.minor { background: #000000;  border-left: 8px solid #FF9900; }");
                    Page.getCurrent().getStyles().add(".summary.major { background: #000000; border-left: 8px solid #FF3300; }");
                    Page.getCurrent().getStyles().add(".summary.critical { background: #000000; border-left: 8px solid #CC0000; }");
                    Page.getCurrent().getStyles().add(".summary.global { background: #000000; border-left: 8px solid #000000; }");
                    Page.getCurrent().getStyles().add(".summary { padding: 5px 5px; margin: 1px; }");
                    Page.getCurrent().getStyles().add(".summary-font { font-size: 17px; line-height: normal; text-align: right; color: #3ba300; }");
                    Page.getCurrent().getStyles().add(".summary-font-legend { font-size: 9px; line-height: normal; text-align: right; color: #3ba300; }");
                }

                public void refresh() {
                    SummaryDashlet.this.m_timeslot = 3600L;
                    try {
                        SummaryDashlet.this.m_timeslot = Math.max(1, Integer.parseInt((String)SummaryDashlet.this.getDashletSpec().getParameters().get("timeslot")));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this.m_horizontalLayout.removeAllComponents();
                    Accordion accordion = new Accordion();
                    accordion.setSizeFull();
                    this.injectDashboardStyles();
                    Component severity = SummaryDashlet.this.getComponentSeverity(16);
                    Component uei = SummaryDashlet.this.getComponentUei(16);
                    VerticalLayout v1 = new VerticalLayout(new Component[]{severity});
                    v1.setSizeFull();
                    v1.setComponentAlignment(severity, Alignment.MIDDLE_CENTER);
                    v1.setMargin(true);
                    accordion.addTab((Component)v1, "by Severity");
                    VerticalLayout v2 = new VerticalLayout(new Component[]{uei});
                    v2.setSizeFull();
                    v2.setComponentAlignment(uei, Alignment.MIDDLE_CENTER);
                    v2.setMargin(true);
                    accordion.addTab((Component)v2, "by Uei");
                    this.m_horizontalLayout.addComponent((Component)accordion);
                }

                public Component getComponent() {
                    return this.m_horizontalLayout;
                }

                public boolean isBoosted() {
                    return SummaryDashlet.this.m_boosted;
                }
            };
        }
        return this.m_dashboardComponent;
    }
}

