/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.Sizeable;
import com.vaadin.ui.Accordion;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.v7.ui.Label;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.opennms.features.vaadin.components.graph.GraphContainer;
import org.opennms.features.vaadin.dashboard.dashlets.RrdGraphHelper;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class RrdDashlet
extends AbstractDashlet {
    RrdGraphHelper m_rrdGraphHelper;
    private DashletComponent m_wallboardComponent;
    private DashletComponent m_dashboardComponent;

    public RrdDashlet(String name, DashletSpec dashletSpec, RrdGraphHelper rrdGraphHelper) {
        super(name, dashletSpec);
        this.m_rrdGraphHelper = rrdGraphHelper;
    }

    public DashletComponent getDashboardComponent(final UI ui) {
        if (this.m_dashboardComponent == null) {
            this.m_dashboardComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(RrdDashlet.this.getName());
                    this.m_verticalLayout.setSizeFull();
                }

                public void refresh() {
                    int timeFrameType;
                    int timeFrameValue;
                    this.m_verticalLayout.removeAllComponents();
                    int columns = 0;
                    int rows = 0;
                    int width = 0;
                    int height = 0;
                    try {
                        columns = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("columns"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        columns = 1;
                    }
                    try {
                        rows = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("rows"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        rows = 1;
                    }
                    try {
                        width = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("width"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        width = 400;
                    }
                    try {
                        height = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("height"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        height = 100;
                    }
                    try {
                        timeFrameValue = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("timeFrameValue"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        timeFrameValue = 1;
                    }
                    try {
                        timeFrameType = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("timeFrameType"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        timeFrameType = 10;
                    }
                    int i = 0;
                    ui.getPage().getStyles().add(".box { margin: 5px; background-color: #444; border: 1px solid #999; border-top: 0; overflow: auto; width: 100% }");
                    ui.getPage().getStyles().add(".text { color:#ffffff; line-height: 11px; font-size: 9px; font-family: 'Lucida Grande', Verdana, sans-serif; font-weight: bold; }");
                    ui.getPage().getStyles().add(".margin { margin:5px; }");
                    Accordion accordion = new Accordion();
                    accordion.setSizeFull();
                    for (int y = 0; y < rows; ++y) {
                        for (int x = 0; x < columns; ++x) {
                            String graphUrl = (String)RrdDashlet.this.getDashletSpec().getParameters().get("graphUrl" + i);
                            if (graphUrl != null && !"".equals(graphUrl)) {
                                accordion.addTab(RrdDashlet.this.getGraphComponent(i, width, height, timeFrameType, timeFrameValue), (String)RrdDashlet.this.getDashletSpec().getParameters().get("nodeLabel" + i) + "/" + (String)RrdDashlet.this.getDashletSpec().getParameters().get("resourceTypeLabel" + i) + ": " + (String)RrdDashlet.this.getDashletSpec().getParameters().get("resourceLabel" + i));
                            }
                            ++i;
                        }
                    }
                    this.m_verticalLayout.addComponent((Component)accordion);
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_dashboardComponent;
    }

    public DashletComponent getWallboardComponent(final UI ui) {
        if (this.m_wallboardComponent == null) {
            this.m_wallboardComponent = new AbstractDashletComponent(){
                private GridLayout m_gridLayout = new GridLayout();
                {
                    this.m_gridLayout.setCaption(RrdDashlet.this.getName());
                    this.m_gridLayout.setSizeFull();
                    this.m_gridLayout.setColumns(1);
                    this.m_gridLayout.setRows(1);
                }

                public void refresh() {
                    int timeFrameType;
                    int timeFrameValue;
                    this.m_gridLayout.removeAllComponents();
                    int columns = 0;
                    int rows = 0;
                    int width = 0;
                    int height = 0;
                    try {
                        columns = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("columns"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        columns = 1;
                    }
                    try {
                        rows = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("rows"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        rows = 1;
                    }
                    try {
                        width = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("width"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        width = 400;
                    }
                    try {
                        height = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("height"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        height = 100;
                    }
                    try {
                        timeFrameValue = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("timeFrameValue"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        timeFrameValue = 1;
                    }
                    try {
                        timeFrameType = Integer.parseInt((String)RrdDashlet.this.getDashletSpec().getParameters().get("timeFrameType"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        timeFrameType = 10;
                    }
                    this.m_gridLayout.setColumns(columns);
                    this.m_gridLayout.setRows(rows);
                    int i = 0;
                    ui.getPage().getStyles().add(".box { margin: 5px; background-color: #444; border: 1px solid #999; border-top: 0; overflow: auto; width: 100%; }");
                    ui.getPage().getStyles().add(".text { color:#ffffff; line-height: 11px; font-size: 9px; font-family: 'Lucida Grande', Verdana, sans-serif; font-weight: bold; }");
                    ui.getPage().getStyles().add(".margin { margin:5px; }");
                    for (int y = 0; y < this.m_gridLayout.getRows(); ++y) {
                        for (int x = 0; x < this.m_gridLayout.getColumns(); ++x) {
                            String graphUrl = (String)RrdDashlet.this.getDashletSpec().getParameters().get("graphUrl" + i);
                            if (graphUrl != null && !"".equals(graphUrl)) {
                                Component component = RrdDashlet.this.getGraphComponent(i, width, height, timeFrameType, timeFrameValue);
                                this.m_gridLayout.addComponent(component, x, y);
                                this.m_gridLayout.setComponentAlignment(component, Alignment.MIDDLE_CENTER);
                            }
                            ++i;
                        }
                    }
                }

                public Component getComponent() {
                    return this.m_gridLayout;
                }
            };
        }
        return this.m_wallboardComponent;
    }

    private Component getGraphComponent(int i, int width, int height, int timeFrameType, int timeFrameValue) {
        String graphTitle = (String)this.getDashletSpec().getParameters().get("graphLabel" + i);
        String graphName = RrdGraphHelper.getGraphNameFromQuery((String)this.getDashletSpec().getParameters().get("graphUrl" + i));
        String resourceId = (String)this.getDashletSpec().getParameters().get("resourceId" + i);
        GraphContainer graph = new GraphContainer(graphName, resourceId);
        graph.setTitle(graphTitle);
        GregorianCalendar cal = new GregorianCalendar();
        graph.setEnd(cal.getTime());
        ((Calendar)cal).add(timeFrameType, -timeFrameValue);
        graph.setStart(cal.getTime());
        graph.setWidthRatio(Double.valueOf(1.0));
        VerticalLayout verticalLayout = new VerticalLayout();
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.addStyleName("box");
        horizontalLayout.setHeight("42px");
        VerticalLayout leftLayout = new VerticalLayout();
        leftLayout.setDefaultComponentAlignment(Alignment.TOP_LEFT);
        leftLayout.addStyleName("margin");
        Label labelFrom = new Label((String)this.getDashletSpec().getParameters().get("nodeLabel" + i));
        labelFrom.addStyleName("text");
        Label labelTo = new Label((String)this.getDashletSpec().getParameters().get("resourceTypeLabel" + i) + ": " + (String)this.getDashletSpec().getParameters().get("resourceLabel" + i));
        labelTo.addStyleName("text");
        leftLayout.addComponent((Component)labelFrom);
        leftLayout.addComponent((Component)labelTo);
        horizontalLayout.addComponent((Component)leftLayout);
        horizontalLayout.setExpandRatio((Component)leftLayout, 1.0f);
        verticalLayout.addComponent((Component)horizontalLayout);
        verticalLayout.addComponent((Component)graph);
        verticalLayout.setWidth((float)width, Sizeable.Unit.PIXELS);
        verticalLayout.setComponentAlignment((Component)horizontalLayout, Alignment.MIDDLE_CENTER);
        verticalLayout.setComponentAlignment((Component)graph, Alignment.MIDDLE_CENTER);
        verticalLayout.setMargin(true);
        return verticalLayout;
    }
}

