/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.data.Property;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.NativeSelect;
import com.vaadin.ui.TextField;
import com.vaadin.ui.VerticalLayout;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardConfigUI;
import org.opennms.features.vaadin.dashboard.config.ui.WallboardProvider;
import org.opennms.features.vaadin.dashboard.dashlets.RrdGraphEntry;
import org.opennms.features.vaadin.dashboard.dashlets.RrdGraphHelper;
import org.opennms.features.vaadin.dashboard.model.DashletConfigurationWindow;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;

public class RrdDashletConfigurationWindow
extends DashletConfigurationWindow {
    private DashletSpec m_dashletSpec;
    private NodeDao m_nodeDao;
    private RrdGraphHelper m_rrdGraphHelper;
    private TextField m_widthField;
    private TextField m_heightField;
    private NativeSelect m_columnsSelect;
    private NativeSelect m_rowsSelect;
    private NativeSelect m_timeFrameType;
    private TextField m_timeFrameValue;
    private GridLayout m_gridLayout;
    private KSC_PerformanceReportFactory kscPerformanceReportFactory;

    public RrdDashletConfigurationWindow(DashletSpec dashletSpec, RrdGraphHelper rrdGraphHelper, NodeDao nodeDao) {
        int rows;
        int columns;
        this.m_dashletSpec = dashletSpec;
        this.m_nodeDao = nodeDao;
        this.m_rrdGraphHelper = rrdGraphHelper;
        this.m_gridLayout = new GridLayout();
        this.m_gridLayout.setSizeFull();
        this.m_gridLayout.setColumns(1);
        this.m_gridLayout.setRows(1);
        FormLayout leftFormLayout = new FormLayout();
        FormLayout middleFormLayout = new FormLayout();
        FormLayout rightFormLayout = new FormLayout();
        this.m_columnsSelect = new NativeSelect();
        this.m_columnsSelect.setCaption("Columns");
        this.m_columnsSelect.setDescription("Number of columns");
        this.m_columnsSelect.setImmediate(true);
        this.m_columnsSelect.setNewItemsAllowed(false);
        this.m_columnsSelect.setMultiSelect(false);
        this.m_columnsSelect.setInvalidAllowed(false);
        this.m_columnsSelect.setNullSelectionAllowed(false);
        this.m_rowsSelect = new NativeSelect();
        this.m_rowsSelect.setCaption("Rows");
        this.m_rowsSelect.setDescription("Number of rows");
        this.m_rowsSelect.setImmediate(true);
        this.m_rowsSelect.setNewItemsAllowed(false);
        this.m_rowsSelect.setMultiSelect(false);
        this.m_rowsSelect.setInvalidAllowed(false);
        this.m_rowsSelect.setNullSelectionAllowed(false);
        for (int i = 1; i < 5; ++i) {
            this.m_columnsSelect.addItem((Object)i);
            this.m_rowsSelect.addItem((Object)i);
        }
        try {
            columns = Integer.parseInt((String)this.m_dashletSpec.getParameters().get("columns"));
        }
        catch (NumberFormatException numberFormatException) {
            columns = 1;
        }
        try {
            rows = Integer.parseInt((String)this.m_dashletSpec.getParameters().get("rows"));
        }
        catch (NumberFormatException numberFormatException) {
            rows = 1;
        }
        this.m_columnsSelect.setValue((Object)columns);
        this.m_rowsSelect.setValue((Object)rows);
        this.m_widthField = new TextField();
        this.m_widthField.setCaption("Graph Width");
        this.m_widthField.setDescription("Width of graphs");
        this.m_widthField.setValue((String)this.m_dashletSpec.getParameters().get("width"));
        this.m_heightField = new TextField();
        this.m_heightField.setCaption("Graph Height");
        this.m_heightField.setDescription("Height of graphs");
        this.m_heightField.setValue((String)this.m_dashletSpec.getParameters().get("height"));
        this.m_timeFrameValue = new TextField("Timeframe value");
        this.m_timeFrameValue.setDescription("Timeframe value");
        this.m_timeFrameValue.setValue((String)this.m_dashletSpec.getParameters().get("timeFrameValue"));
        this.m_timeFrameType = new NativeSelect("Timeframe type");
        this.m_timeFrameType.setDescription("Timeframe type");
        this.m_timeFrameType.setNullSelectionAllowed(false);
        this.m_timeFrameType.setMultiSelect(false);
        this.m_timeFrameType.setNewItemsAllowed(false);
        this.m_timeFrameType.setItemCaptionMode(AbstractSelect.ItemCaptionMode.EXPLICIT);
        this.m_timeFrameType.addItem((Object)String.valueOf(12));
        this.m_timeFrameType.setItemCaption((Object)String.valueOf(12), "Minute");
        this.m_timeFrameType.addItem((Object)String.valueOf(11));
        this.m_timeFrameType.setItemCaption((Object)String.valueOf(11), "Hour");
        this.m_timeFrameType.addItem((Object)String.valueOf(6));
        this.m_timeFrameType.setItemCaption((Object)String.valueOf(6), "Day");
        this.m_timeFrameType.addItem((Object)String.valueOf(3));
        this.m_timeFrameType.setItemCaption((Object)String.valueOf(3), "Week");
        this.m_timeFrameType.addItem((Object)String.valueOf(2));
        this.m_timeFrameType.setItemCaption((Object)String.valueOf(2), "Month");
        this.m_timeFrameType.addItem((Object)String.valueOf(1));
        this.m_timeFrameType.setItemCaption((Object)String.valueOf(1), "Year");
        this.m_timeFrameType.setValue(this.m_dashletSpec.getParameters().get("timeFrameType"));
        this.m_timeFrameType.setImmediate(true);
        this.m_timeFrameValue.setImmediate(true);
        this.m_timeFrameType.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                RrdDashletConfigurationWindow.this.updatePreview();
            }
        });
        this.m_timeFrameValue.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                RrdDashletConfigurationWindow.this.updatePreview();
            }
        });
        this.recreateCells(columns, rows);
        this.m_columnsSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                RrdDashletConfigurationWindow.this.recreateCells(Integer.valueOf(valueChangeEvent.getProperty().getValue().toString()), RrdDashletConfigurationWindow.this.m_gridLayout.getRows());
            }
        });
        this.m_rowsSelect.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                RrdDashletConfigurationWindow.this.recreateCells(RrdDashletConfigurationWindow.this.m_gridLayout.getColumns(), Integer.valueOf(valueChangeEvent.getProperty().getValue().toString()));
            }
        });
        leftFormLayout.addComponent((Component)this.m_columnsSelect);
        leftFormLayout.addComponent((Component)this.m_widthField);
        leftFormLayout.addComponent((Component)this.m_timeFrameValue);
        middleFormLayout.addComponent((Component)this.m_rowsSelect);
        middleFormLayout.addComponent((Component)this.m_heightField);
        middleFormLayout.addComponent((Component)this.m_timeFrameType);
        Button importButton = new Button("KSC Import");
        importButton.setDescription("Import KSC-report");
        final NativeSelect selectKSCReport = new NativeSelect();
        selectKSCReport.setDescription("KSC-report selection");
        selectKSCReport.setCaption("KSC Report");
        selectKSCReport.setImmediate(true);
        selectKSCReport.setNewItemsAllowed(false);
        selectKSCReport.setMultiSelect(false);
        selectKSCReport.setInvalidAllowed(false);
        selectKSCReport.setNullSelectionAllowed(false);
        selectKSCReport.setImmediate(true);
        this.kscPerformanceReportFactory = KSC_PerformanceReportFactory.getInstance();
        Map mapOfKscReports = this.kscPerformanceReportFactory.getReportList();
        if (mapOfKscReports.size() == 0) {
            importButton.setEnabled(false);
        }
        for (Map.Entry entry : mapOfKscReports.entrySet()) {
            selectKSCReport.addItem(entry.getKey());
            selectKSCReport.setItemCaption(entry.getKey(), (String)entry.getValue());
            if (selectKSCReport.getValue() != null) continue;
            selectKSCReport.setValue(entry.getKey());
        }
        importButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                RrdDashletConfigurationWindow.this.importKscReport(Integer.valueOf(selectKSCReport.getValue().toString()));
            }
        });
        rightFormLayout.addComponent((Component)selectKSCReport);
        rightFormLayout.addComponent((Component)importButton);
        HorizontalLayout horizontalLayout = new HorizontalLayout();
        horizontalLayout.setMargin(true);
        horizontalLayout.addComponent((Component)leftFormLayout);
        horizontalLayout.addComponent((Component)middleFormLayout);
        horizontalLayout.addComponent((Component)rightFormLayout);
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(true);
        buttonLayout.setSpacing(true);
        buttonLayout.setWidth("100%");
        Button cancel = new Button("Cancel");
        cancel.setDescription("Cancel editing");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                RrdDashletConfigurationWindow.this.close();
            }
        });
        cancel.setClickShortcut(27, null);
        buttonLayout.addComponent((Component)cancel);
        buttonLayout.setExpandRatio((Component)cancel, 1.0f);
        buttonLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        Button ok = new Button("Save");
        ok.setDescription("Save properties and close");
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                int timeFrameType;
                int timeFrameValue;
                RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("width", ((String)RrdDashletConfigurationWindow.this.m_widthField.getValue()).toString());
                RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("height", ((String)RrdDashletConfigurationWindow.this.m_heightField.getValue()).toString());
                RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("columns", RrdDashletConfigurationWindow.this.m_columnsSelect.getValue().toString());
                RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("rows", RrdDashletConfigurationWindow.this.m_rowsSelect.getValue().toString());
                try {
                    timeFrameValue = Integer.parseInt(((String)RrdDashletConfigurationWindow.this.m_timeFrameValue.getValue()).toString());
                }
                catch (NumberFormatException numberFormatException) {
                    timeFrameValue = 1;
                }
                try {
                    timeFrameType = Integer.parseInt(RrdDashletConfigurationWindow.this.m_timeFrameType.getValue().toString());
                }
                catch (NumberFormatException numberFormatException) {
                    timeFrameType = 10;
                }
                RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("timeFrameType", String.valueOf(timeFrameType));
                RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("timeFrameValue", String.valueOf(timeFrameValue));
                int i = 0;
                for (int y = 0; y < RrdDashletConfigurationWindow.this.m_gridLayout.getRows(); ++y) {
                    for (int x = 0; x < RrdDashletConfigurationWindow.this.m_gridLayout.getColumns(); ++x) {
                        RrdGraphEntry rrdGraphEntry = (RrdGraphEntry)RrdDashletConfigurationWindow.this.m_gridLayout.getComponent(x, y);
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("nodeLabel" + i, rrdGraphEntry.getNodeLabel());
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("nodeId" + i, rrdGraphEntry.getNodeId());
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("resourceTypeLabel" + i, rrdGraphEntry.getResourceTypeLabel());
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("resourceTypeId" + i, rrdGraphEntry.getResourceTypeId());
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("resourceId" + i, rrdGraphEntry.getResourceId());
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("resourceLabel" + i, rrdGraphEntry.getResourceLabel());
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("graphLabel" + i, rrdGraphEntry.getGraphLabel());
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("graphId" + i, rrdGraphEntry.getGraphId());
                        RrdDashletConfigurationWindow.this.m_dashletSpec.getParameters().put("graphUrl" + i, rrdGraphEntry.getGraphUrl());
                        ++i;
                    }
                }
                WallboardProvider.getInstance().save();
                ((WallboardConfigUI)RrdDashletConfigurationWindow.this.getUI()).notifyMessage("Data saved", "Properties");
                RrdDashletConfigurationWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        buttonLayout.addComponent((Component)ok);
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setMargin(true);
        verticalLayout.addComponent((Component)horizontalLayout);
        verticalLayout.addComponent((Component)this.m_gridLayout);
        verticalLayout.addComponent((Component)buttonLayout);
        verticalLayout.setExpandRatio((Component)this.m_gridLayout, 2.0f);
        verticalLayout.setSizeFull();
        this.setContent((Component)verticalLayout);
    }

    private void setRrdGraphEntryFromKscReportGraph(RrdGraphEntry rrdGraphEntry, Graph graph) {
        String[] graphTypeArr = graph.getGraphtype().split("\\.");
        String[] resourceIdArr = graph.getResourceId().orElse("").split("\\.");
        String nodeId = resourceIdArr[0].split("[\\[\\]]")[1];
        String resourceTypeName = resourceIdArr[1].split("[\\[\\]]")[0];
        OnmsNode onmsNode = this.m_nodeDao.get(nodeId);
        String nodeLabel = onmsNode.getLabel();
        Map<OnmsResourceType, List<OnmsResource>> resourceTypeListMap = this.m_rrdGraphHelper.getResourceTypeMapForNodeId(nodeId);
        block2: for (Map.Entry<OnmsResourceType, List<OnmsResource>> entry : resourceTypeListMap.entrySet()) {
            OnmsResourceType onmsResourceType = entry.getKey();
            if (!resourceTypeName.equals(onmsResourceType.getName())) continue;
            String resourceTypeId = "node[" + nodeId + "]." + resourceTypeName;
            String resourceTypeLabel = onmsResourceType.getLabel();
            List<OnmsResource> onmsResourceList = entry.getValue();
            for (OnmsResource onmsResource : onmsResourceList) {
                String onmsResourceId = null;
                try {
                    onmsResourceId = URLDecoder.decode(onmsResource.getId(), StandardCharsets.UTF_8.name());
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                if (!onmsResourceId.equals(graph.getResourceId())) continue;
                String resourceId = onmsResourceId;
                String resourceLabel = onmsResource.getLabel();
                Map<String, String> resultsMap = this.m_rrdGraphHelper.getGraphResultsForResourceId(resourceId);
                Map<String, String> nameTitleMapping = this.m_rrdGraphHelper.getGraphNameTitleMappingForResourceId(resourceId);
                String graphId = onmsResourceId + "." + nameTitleMapping.get(graph.getGraphtype());
                String graphLabel = nameTitleMapping.get(graph.getGraphtype());
                String graphUrl = resultsMap.get(graph.getGraphtype());
                rrdGraphEntry.setNodeId(nodeId);
                rrdGraphEntry.setNodeLabel(nodeLabel);
                rrdGraphEntry.setResourceTypeId(resourceTypeId);
                rrdGraphEntry.setResourceTypeLabel(resourceTypeLabel);
                rrdGraphEntry.setResourceId(resourceId);
                rrdGraphEntry.setResourceLabel(resourceLabel);
                rrdGraphEntry.setGraphId(graphId);
                rrdGraphEntry.setGraphLabel(graphLabel);
                rrdGraphEntry.setGraphUrl(graphUrl);
                break block2;
            }
        }
    }

    private void importKscReport(int reportId) {
        Report report = this.kscPerformanceReportFactory.getReportByIndex(reportId);
        int columns = Math.max(1, report.getGraphsPerLine().orElse(1));
        int rows = report.getGraphs().size() / columns;
        if (rows == 0) {
            rows = 1;
        }
        if (report.getGraphs().size() % columns > 0) {
            ++rows;
        }
        for (int y = 0; y < this.m_gridLayout.getRows(); ++y) {
            for (int x = 0; x < this.m_gridLayout.getColumns(); ++x) {
                if (x < columns && y < rows) continue;
                this.m_gridLayout.removeComponent(x, y);
            }
        }
        this.m_columnsSelect.setValue((Object)columns);
        this.m_rowsSelect.setValue((Object)rows);
        this.m_gridLayout.setColumns(columns);
        this.m_gridLayout.setRows(rows);
        int timeFrameValue = 1;
        int timeFrameType = 10;
        int i = 0;
        for (int y = 0; y < this.m_gridLayout.getRows(); ++y) {
            for (int x = 0; x < this.m_gridLayout.getColumns(); ++x) {
                RrdGraphEntry rrdGraphEntry;
                if (this.m_gridLayout.getComponent(x, y) == null) {
                    rrdGraphEntry = new RrdGraphEntry(this.m_nodeDao, this.m_rrdGraphHelper, x, y);
                    rrdGraphEntry.setPreviewTimeFrame(timeFrameType, timeFrameValue);
                    this.m_gridLayout.addComponent((Component)rrdGraphEntry, x, y);
                }
                rrdGraphEntry = (RrdGraphEntry)this.m_gridLayout.getComponent(x, y);
                if (i < report.getGraphs().size()) {
                    int index = i;
                    this.setRrdGraphEntryFromKscReportGraph(rrdGraphEntry, (Graph)report.getGraphs().get(index));
                }
                rrdGraphEntry.update();
                ++i;
            }
        }
    }

    private void updatePreview() {
        int timeFrameType;
        int timeFrameValue;
        try {
            timeFrameValue = Integer.parseInt(((String)this.m_timeFrameValue.getValue()).toString());
        }
        catch (NumberFormatException numberFormatException) {
            timeFrameValue = 1;
        }
        try {
            timeFrameType = Integer.parseInt(this.m_timeFrameType.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            timeFrameType = 10;
        }
        for (int y = 0; y < this.m_gridLayout.getRows(); ++y) {
            for (int x = 0; x < this.m_gridLayout.getColumns(); ++x) {
                if (this.m_gridLayout.getComponent(x, y) == null) continue;
                ((RrdGraphEntry)this.m_gridLayout.getComponent(x, y)).setPreviewTimeFrame(timeFrameType, timeFrameValue);
            }
        }
    }

    private void recreateCells(int columns, int rows) {
        int timeFrameType;
        int timeFrameValue;
        for (int y = 0; y < this.m_gridLayout.getRows(); ++y) {
            for (int x = 0; x < this.m_gridLayout.getColumns(); ++x) {
                if (x < columns && y < rows) continue;
                this.m_gridLayout.removeComponent(x, y);
            }
        }
        this.m_gridLayout.setColumns(columns);
        this.m_gridLayout.setRows(rows);
        try {
            timeFrameValue = Integer.parseInt(((String)this.m_timeFrameValue.getValue()).toString());
        }
        catch (NumberFormatException numberFormatException) {
            timeFrameValue = 1;
        }
        try {
            timeFrameType = Integer.parseInt(this.m_timeFrameType.getValue().toString());
        }
        catch (NumberFormatException numberFormatException) {
            timeFrameType = 10;
        }
        int i = 0;
        for (int y = 0; y < this.m_gridLayout.getRows(); ++y) {
            for (int x = 0; x < this.m_gridLayout.getColumns(); ++x) {
                if (this.m_gridLayout.getComponent(x, y) == null) {
                    RrdGraphEntry rrdGraphEntry = new RrdGraphEntry(this.m_nodeDao, this.m_rrdGraphHelper, x, y);
                    rrdGraphEntry.setPreviewTimeFrame(timeFrameType, timeFrameValue);
                    if (this.m_dashletSpec.getParameters().containsKey("nodeId" + i)) {
                        rrdGraphEntry.setNodeId((String)this.m_dashletSpec.getParameters().get("nodeId" + i));
                    }
                    if (this.m_dashletSpec.getParameters().containsKey("nodeLabel" + i)) {
                        rrdGraphEntry.setNodeLabel((String)this.m_dashletSpec.getParameters().get("nodeLabel" + i));
                    }
                    if (this.m_dashletSpec.getParameters().containsKey("resourceTypeId" + i)) {
                        rrdGraphEntry.setResourceTypeId((String)this.m_dashletSpec.getParameters().get("resourceTypeId" + i));
                    }
                    if (this.m_dashletSpec.getParameters().containsKey("resourceTypeLabel" + i)) {
                        rrdGraphEntry.setResourceTypeLabel((String)this.m_dashletSpec.getParameters().get("resourceTypeLabel" + i));
                    }
                    if (this.m_dashletSpec.getParameters().containsKey("resourceId" + i)) {
                        rrdGraphEntry.setResourceId((String)this.m_dashletSpec.getParameters().get("resourceId" + i));
                    }
                    if (this.m_dashletSpec.getParameters().containsKey("resourceLabel" + i)) {
                        rrdGraphEntry.setResourceLabel((String)this.m_dashletSpec.getParameters().get("resourceLabel" + i));
                    }
                    if (this.m_dashletSpec.getParameters().containsKey("graphId" + i)) {
                        rrdGraphEntry.setGraphId((String)this.m_dashletSpec.getParameters().get("graphId" + i));
                    }
                    if (this.m_dashletSpec.getParameters().containsKey("graphLabel" + i)) {
                        rrdGraphEntry.setGraphLabel((String)this.m_dashletSpec.getParameters().get("graphLabel" + i));
                    }
                    if (this.m_dashletSpec.getParameters().containsKey("graphUrl" + i)) {
                        rrdGraphEntry.setGraphUrl((String)this.m_dashletSpec.getParameters().get("graphUrl" + i));
                    }
                    rrdGraphEntry.update();
                    this.m_gridLayout.addComponent((Component)rrdGraphEntry, x, y);
                }
                ++i;
            }
        }
    }
}

