/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.data.Container;
import com.vaadin.data.Item;
import com.vaadin.data.Property;
import com.vaadin.data.util.HierarchicalContainer;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.AbstractSelect;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.Tree;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.dashboard.dashlets.RrdGraphEntry;
import org.opennms.features.vaadin.dashboard.dashlets.RrdGraphHelper;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;

public class GraphSelectionWindow
extends Window {
    private Tree m_tree;

    public GraphSelectionWindow(NodeDao nodeDao, final RrdGraphHelper rrdGraphHelper, final RrdGraphEntry rrdGraphEntry) {
        super("Select RRD graph");
        this.setModal(true);
        this.setClosable(false);
        this.setResizable(false);
        this.setWidth(50.0f, Sizeable.Unit.PERCENTAGE);
        this.setHeight(70.0f, Sizeable.Unit.PERCENTAGE);
        final HierarchicalContainer hierarchicalContainer = new HierarchicalContainer();
        hierarchicalContainer.addContainerProperty((Object)"id", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"label", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"type", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"nodeId", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"nodeLabel", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"resourceId", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"resourceLabel", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"resourceTypeId", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"resourceTypeLabel", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"graphId", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"graphLabel", String.class, null);
        hierarchicalContainer.addContainerProperty((Object)"graphUrl", String.class, null);
        List onmsNodeList = nodeDao.findAll();
        for (OnmsNode onmsNode : onmsNodeList) {
            Item item = hierarchicalContainer.addItem((Object)onmsNode.getId().toString());
            item.getItemProperty((Object)"label").setValue((Object)(onmsNode.getLabel() + " (" + onmsNode.getId() + ")"));
            item.getItemProperty((Object)"id").setValue((Object)onmsNode.getId().toString());
            item.getItemProperty((Object)"type").setValue((Object)"node");
            item.getItemProperty((Object)"nodeId").setValue((Object)onmsNode.getId().toString());
        }
        Panel panel = new Panel();
        this.m_tree = new Tree();
        this.m_tree.setCaption("Graph");
        this.m_tree.setSizeFull();
        this.m_tree.setItemCaptionMode(AbstractSelect.ItemCaptionMode.PROPERTY);
        this.m_tree.setItemCaptionPropertyId((Object)"label");
        this.m_tree.setContainerDataSource((Container)hierarchicalContainer);
        this.m_tree.setMultiSelect(false);
        this.m_tree.setNewItemsAllowed(false);
        this.m_tree.setImmediate(true);
        this.m_tree.addExpandListener(new Tree.ExpandListener(){

            public void nodeExpand(Tree.ExpandEvent expandEvent) {
                String itemToExpandId = String.valueOf(expandEvent.getItemId());
                if (GraphSelectionWindow.this.m_tree.hasChildren((Object)itemToExpandId)) {
                    return;
                }
                Item itemToExpand = GraphSelectionWindow.this.m_tree.getItem(expandEvent.getItemId());
                String type = itemToExpand.getItemProperty((Object)"type").getValue().toString();
                if ("node".equals(type)) {
                    Map<OnmsResourceType, List<OnmsResource>> resourceTypeMap = rrdGraphHelper.getResourceTypeMapForNodeId(String.valueOf(itemToExpand.getItemProperty((Object)"id").getValue()));
                    for (Map.Entry<OnmsResourceType, List<OnmsResource>> resourceTypeMapEntry : resourceTypeMap.entrySet()) {
                        String newResourceTypeItemId = "node[" + itemToExpandId + "]." + resourceTypeMapEntry.getKey().getName();
                        Item newResourceTypeItem = hierarchicalContainer.addItem((Object)newResourceTypeItemId);
                        newResourceTypeItem.getItemProperty((Object)"label").setValue((Object)resourceTypeMapEntry.getKey().getLabel());
                        newResourceTypeItem.getItemProperty((Object)"type").setValue((Object)"resourceType");
                        newResourceTypeItem.getItemProperty((Object)"nodeId").setValue((Object)itemToExpandId);
                        newResourceTypeItem.getItemProperty((Object)"nodeLabel").setValue(itemToExpand.getItemProperty((Object)"label").getValue());
                        newResourceTypeItem.getItemProperty((Object)"resourceTypeId").setValue((Object)newResourceTypeItemId);
                        newResourceTypeItem.getItemProperty((Object)"resourceTypeLabel").setValue((Object)resourceTypeMapEntry.getKey().getLabel());
                        GraphSelectionWindow.this.m_tree.setParent((Object)newResourceTypeItemId, (Object)itemToExpandId);
                        GraphSelectionWindow.this.m_tree.setChildrenAllowed((Object)newResourceTypeItemId, true);
                        for (OnmsResource onmsResource : resourceTypeMapEntry.getValue()) {
                            String newResourceItemId;
                            try {
                                newResourceItemId = URLDecoder.decode(onmsResource.getId(), StandardCharsets.UTF_8.name());
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                                continue;
                            }
                            Item newResourceItem = hierarchicalContainer.addItem((Object)newResourceItemId);
                            newResourceItem.getItemProperty((Object)"label").setValue((Object)onmsResource.getLabel());
                            newResourceItem.getItemProperty((Object)"type").setValue((Object)"resource");
                            newResourceItem.getItemProperty((Object)"nodeId").setValue((Object)itemToExpandId);
                            newResourceItem.getItemProperty((Object)"nodeLabel").setValue(itemToExpand.getItemProperty((Object)"label").getValue());
                            newResourceItem.getItemProperty((Object)"resourceId").setValue((Object)newResourceItemId);
                            newResourceItem.getItemProperty((Object)"resourceLabel").setValue((Object)onmsResource.getLabel());
                            newResourceItem.getItemProperty((Object)"resourceTypeId").setValue((Object)newResourceTypeItemId);
                            newResourceItem.getItemProperty((Object)"resourceTypeLabel").setValue(newResourceTypeItem.getItemProperty((Object)"label").getValue());
                            GraphSelectionWindow.this.m_tree.setParent((Object)newResourceItemId, (Object)newResourceTypeItemId);
                            GraphSelectionWindow.this.m_tree.setChildrenAllowed((Object)newResourceItemId, true);
                        }
                    }
                }
                if ("resource".equals(type)) {
                    Map<String, String> map = rrdGraphHelper.getGraphResultsForResourceId(itemToExpandId);
                    Map<String, String> titleNameMapping = rrdGraphHelper.getGraphTitleNameMappingForResourceId(itemToExpandId);
                    for (Map.Entry<String, String> entry : titleNameMapping.entrySet()) {
                        String newGraphItemId = itemToExpandId + "." + entry.getKey();
                        Item newGraphItem = hierarchicalContainer.addItem((Object)newGraphItemId);
                        newGraphItem.getItemProperty((Object)"label").setValue((Object)entry.getKey());
                        newGraphItem.getItemProperty((Object)"type").setValue((Object)"graph");
                        newGraphItem.getItemProperty((Object)"nodeId").setValue((Object)String.valueOf(itemToExpand.getItemProperty((Object)"nodeId").getValue()));
                        newGraphItem.getItemProperty((Object)"nodeLabel").setValue((Object)String.valueOf(itemToExpand.getItemProperty((Object)"nodeLabel").getValue()));
                        newGraphItem.getItemProperty((Object)"resourceId").setValue((Object)String.valueOf(itemToExpand.getItemProperty((Object)"resourceId").getValue()));
                        newGraphItem.getItemProperty((Object)"resourceLabel").setValue((Object)String.valueOf(itemToExpand.getItemProperty((Object)"resourceLabel").getValue()));
                        newGraphItem.getItemProperty((Object)"resourceTypeId").setValue((Object)String.valueOf(itemToExpand.getItemProperty((Object)"resourceTypeId").getValue()));
                        newGraphItem.getItemProperty((Object)"resourceTypeLabel").setValue((Object)String.valueOf(itemToExpand.getItemProperty((Object)"resourceTypeLabel").getValue()));
                        newGraphItem.getItemProperty((Object)"graphId").setValue((Object)newGraphItemId);
                        newGraphItem.getItemProperty((Object)"graphLabel").setValue((Object)entry.getKey());
                        newGraphItem.getItemProperty((Object)"graphUrl").setValue((Object)map.get(entry.getValue()));
                        GraphSelectionWindow.this.m_tree.setParent((Object)newGraphItemId, (Object)itemToExpandId);
                        GraphSelectionWindow.this.m_tree.setChildrenAllowed((Object)newGraphItemId, false);
                    }
                }
            }
        });
        HorizontalLayout buttonLayout = new HorizontalLayout();
        buttonLayout.setMargin(true);
        buttonLayout.setSpacing(true);
        buttonLayout.setWidth("100%");
        Button cancel = new Button("Cancel");
        cancel.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                GraphSelectionWindow.this.close();
            }
        });
        cancel.setClickShortcut(27, null);
        buttonLayout.addComponent((Component)cancel);
        buttonLayout.setExpandRatio((Component)cancel, 1.0f);
        buttonLayout.setComponentAlignment((Component)cancel, Alignment.TOP_RIGHT);
        final Button ok = new Button("Select");
        ok.setEnabled(false);
        ok.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent event) {
                if (GraphSelectionWindow.this.m_tree.getValue() != null) {
                    Item selectedItem = GraphSelectionWindow.this.m_tree.getItem(GraphSelectionWindow.this.m_tree.getValue());
                    rrdGraphEntry.setGraphId(String.valueOf(selectedItem.getItemProperty((Object)"graphId").getValue()));
                    rrdGraphEntry.setResourceTypeId(String.valueOf(selectedItem.getItemProperty((Object)"resourceTypeId").getValue()));
                    rrdGraphEntry.setResourceId(String.valueOf(selectedItem.getItemProperty((Object)"resourceId").getValue()));
                    rrdGraphEntry.setNodeId(String.valueOf(selectedItem.getItemProperty((Object)"nodeId").getValue()));
                    rrdGraphEntry.setGraphLabel(String.valueOf(selectedItem.getItemProperty((Object)"graphLabel").getValue()));
                    rrdGraphEntry.setResourceTypeLabel(String.valueOf(selectedItem.getItemProperty((Object)"resourceTypeLabel").getValue()));
                    rrdGraphEntry.setResourceLabel(String.valueOf(selectedItem.getItemProperty((Object)"resourceLabel").getValue()));
                    rrdGraphEntry.setNodeLabel(String.valueOf(selectedItem.getItemProperty((Object)"nodeLabel").getValue()));
                    rrdGraphEntry.setGraphUrl(String.valueOf(selectedItem.getItemProperty((Object)"graphUrl").getValue()));
                    rrdGraphEntry.update();
                }
                GraphSelectionWindow.this.close();
            }
        });
        ok.setClickShortcut(13, null);
        buttonLayout.addComponent((Component)ok);
        if (rrdGraphEntry.getNodeId() != null) {
            this.m_tree.expandItem((Object)rrdGraphEntry.getNodeId());
            if (rrdGraphEntry.getResourceTypeId() != null) {
                this.m_tree.expandItem((Object)rrdGraphEntry.getResourceTypeId());
                if (rrdGraphEntry.getResourceId() != null) {
                    this.m_tree.expandItem((Object)rrdGraphEntry.getResourceId());
                    if (rrdGraphEntry.getGraphId() != null) {
                        this.m_tree.select((Object)rrdGraphEntry.getGraphId());
                    }
                }
            }
        }
        this.m_tree.addValueChangeListener(new Property.ValueChangeListener(){

            public void valueChange(Property.ValueChangeEvent valueChangeEvent) {
                if (valueChangeEvent.getProperty().getValue() != null) {
                    Item selectedItem = GraphSelectionWindow.this.m_tree.getItem(valueChangeEvent.getProperty().getValue());
                    Object object = selectedItem.getItemProperty((Object)"graphId").getValue();
                    ok.setEnabled(object != null);
                }
            }
        });
        panel.setContent((Component)this.m_tree);
        panel.setCaption("Graph");
        panel.setSizeFull();
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setSizeFull();
        verticalLayout.setMargin(true);
        verticalLayout.addComponent((Component)panel);
        verticalLayout.setExpandRatio((Component)panel, 1.0f);
        verticalLayout.addComponent((Component)buttonLayout);
        this.setContent((Component)verticalLayout);
    }
}

