/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Page;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Image;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import org.opennms.features.vaadin.dashboard.dashlets.GraphSelectionWindow;
import org.opennms.features.vaadin.dashboard.dashlets.RrdGraphHelper;
import org.opennms.netmgt.dao.api.NodeDao;

public class RrdGraphEntry
extends Panel {
    private int m_x;
    private int m_y;
    private String m_graphId;
    private String m_nodeId;
    private String m_resourceTypeId;
    private String m_resourceId;
    private String m_graphUrl;
    private String m_graphLabel;
    private String m_nodeLabel;
    private String m_resourceTypeLabel;
    private String m_resourceLabel;
    private Button m_changeButton = new Button();
    private Button m_removeButton = new Button("Remove");
    private Image m_previewImage = new Image();
    private Label m_nodeLabelComponent = new Label();
    private Label m_graphLabelComponent = new Label();
    int m_calendarField = 10;
    int m_calendarDiff = 1;
    private RrdGraphHelper m_rrdGraphHelper;

    public RrdGraphEntry(final NodeDao nodeDao, final RrdGraphHelper rrdGraphHelper, int x, int y) {
        this.m_x = x;
        this.m_y = y;
        this.m_rrdGraphHelper = rrdGraphHelper;
        this.m_changeButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                GraphSelectionWindow graphSelectionWindow = new GraphSelectionWindow(nodeDao, rrdGraphHelper, RrdGraphEntry.this);
                RrdGraphEntry.this.getUI().addWindow((Window)graphSelectionWindow);
            }
        });
        this.m_removeButton.addClickListener(new Button.ClickListener(){

            public void buttonClick(Button.ClickEvent clickEvent) {
                RrdGraphEntry.this.setGraphId(null);
                RrdGraphEntry.this.setGraphLabel(null);
                RrdGraphEntry.this.setGraphUrl(null);
                RrdGraphEntry.this.setNodeId(null);
                RrdGraphEntry.this.setNodeLabel(null);
                RrdGraphEntry.this.setResourceId(null);
                RrdGraphEntry.this.setResourceLabel(null);
                RrdGraphEntry.this.setResourceTypeId(null);
                RrdGraphEntry.this.setResourceTypeLabel(null);
                RrdGraphEntry.this.update();
            }
        });
        this.m_removeButton.addStyleName("link");
        this.m_changeButton.addStyleName("link");
        VerticalLayout verticalLayout = new VerticalLayout();
        verticalLayout.setDefaultComponentAlignment(Alignment.MIDDLE_CENTER);
        verticalLayout.addComponent((Component)this.m_nodeLabelComponent);
        verticalLayout.addComponent((Component)this.m_graphLabelComponent);
        verticalLayout.addComponent((Component)this.m_changeButton);
        verticalLayout.addComponent((Component)this.m_removeButton);
        verticalLayout.addComponent((Component)this.m_previewImage);
        this.m_nodeLabelComponent.setSizeUndefined();
        this.m_graphLabelComponent.setSizeUndefined();
        verticalLayout.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        this.setSizeFull();
        Page.getCurrent().getStyles().add(".preview { width:175px; }");
        this.update();
        this.setContent((Component)verticalLayout);
    }

    public void setPreviewTimeFrame(int calendarField, int calendarDiff) {
        this.m_calendarField = calendarField;
        this.m_calendarDiff = calendarDiff;
        this.update();
    }

    public void update() {
        if (this.m_graphId == null) {
            this.m_nodeLabelComponent.setValue("No Rrd graph");
            this.m_graphLabelComponent.setValue("selected");
            this.m_changeButton.setCaption("Select Rrd graph");
            this.m_previewImage.setVisible(false);
            this.m_removeButton.setVisible(false);
        } else {
            this.m_previewImage.setSource((Resource)new ExternalResource(this.m_rrdGraphHelper.imageUrlForGraph(this.getGraphUrl(), 150, 50, this.m_calendarField, this.m_calendarDiff)));
            this.m_previewImage.addStyleName("preview");
            this.m_graphLabelComponent.setValue(this.m_resourceTypeLabel + ": " + this.m_resourceLabel);
            this.m_nodeLabelComponent.setValue(this.getNodeLabel());
            this.m_changeButton.setCaption("Change Rrd graph");
            this.m_previewImage.setVisible(true);
            this.m_removeButton.setVisible(true);
        }
    }

    public String getGraphId() {
        return this.m_graphId;
    }

    public void setGraphId(String graphId) {
        this.m_graphId = graphId;
    }

    public String getNodeId() {
        return this.m_nodeId;
    }

    public void setNodeId(String nodeId) {
        this.m_nodeId = nodeId;
    }

    public String getResourceTypeId() {
        return this.m_resourceTypeId;
    }

    public void setResourceTypeId(String resourceTypeId) {
        this.m_resourceTypeId = resourceTypeId;
    }

    public String getResourceId() {
        return this.m_resourceId;
    }

    public void setResourceId(String resourceId) {
        this.m_resourceId = resourceId;
    }

    public String getGraphLabel() {
        return this.m_graphLabel;
    }

    public void setGraphLabel(String graphLabel) {
        this.m_graphLabel = graphLabel;
    }

    public String getNodeLabel() {
        return this.m_nodeLabel;
    }

    public void setNodeLabel(String nodeLabel) {
        this.m_nodeLabel = nodeLabel;
    }

    public String getResourceTypeLabel() {
        return this.m_resourceTypeLabel;
    }

    public void setResourceTypeLabel(String resourceTypeLabel) {
        this.m_resourceTypeLabel = resourceTypeLabel;
    }

    public String getResourceLabel() {
        return this.m_resourceLabel;
    }

    public void setResourceLabel(String resourceLabel) {
        this.m_resourceLabel = resourceLabel;
    }

    public String getGraphUrl() {
        return this.m_graphUrl;
    }

    public void setGraphUrl(String graphUrl) {
        this.m_graphUrl = graphUrl;
    }
}

