/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.dashlets;

import com.vaadin.server.Page;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.label.ContentMode;
import com.vaadin.ui.Accordion;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.opennms.features.timeformat.api.TimeformatService;
import org.opennms.features.vaadin.components.graph.GraphContainer;
import org.opennms.features.vaadin.dashboard.model.AbstractDashlet;
import org.opennms.features.vaadin.dashboard.model.AbstractDashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.vaadin.user.UserTimeZoneExtractor;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionOperations;

public class KscDashlet
extends AbstractDashlet {
    private NodeDao m_nodeDao;
    private ResourceDao m_resourceDao;
    private TransactionOperations m_transactionOperations;
    private DashletComponent m_wallboardComponent;
    private DashletComponent m_dashboardComponent;
    private static final int DEFAULT_GRAPH_WIDTH_PX = 400;
    private final TimeformatService m_timeformatService;
    private final ZoneId m_userTimezoneId;

    public KscDashlet(String name, DashletSpec dashletSpec, NodeDao nodeDao, ResourceDao resourceDao, TransactionOperations transactionOperations, TimeformatService timeformatService) {
        super(name, dashletSpec);
        this.m_nodeDao = nodeDao;
        this.m_resourceDao = resourceDao;
        this.m_transactionOperations = transactionOperations;
        this.m_timeformatService = timeformatService;
        this.m_userTimezoneId = UserTimeZoneExtractor.extractUserTimeZoneIdOrNull();
    }

    public DashletComponent getWallboardComponent() {
        if (this.m_wallboardComponent == null) {
            this.m_wallboardComponent = new AbstractDashletComponent(){
                private GridLayout m_gridLayout = new GridLayout();
                {
                    this.m_gridLayout.setCaption(KscDashlet.this.getName());
                    this.m_gridLayout.setSizeFull();
                    this.m_gridLayout.setColumns(1);
                    this.m_gridLayout.setRows(1);
                }

                public void refresh() {
                    this.m_gridLayout.removeAllComponents();
                    int columns = 0;
                    int rows = 0;
                    String kscReportName = (String)KscDashlet.this.getDashletSpec().getParameters().get("kscReport");
                    if (kscReportName == null || "".equals(kscReportName)) {
                        return;
                    }
                    KSC_PerformanceReportFactory kscPerformanceReportFactory = KSC_PerformanceReportFactory.getInstance();
                    Map reportsMap = kscPerformanceReportFactory.getReportList();
                    int kscReportId = -1;
                    for (Map.Entry entry : reportsMap.entrySet()) {
                        if (!kscReportName.equals(entry.getValue())) continue;
                        kscReportId = (Integer)entry.getKey();
                        break;
                    }
                    if (kscReportId == -1) {
                        return;
                    }
                    Report kscReport = kscPerformanceReportFactory.getReportByIndex(kscReportId);
                    columns = Math.max(1, kscReport.getGraphsPerLine().orElse(1));
                    rows = kscReport.getGraphs().size() / columns;
                    if (rows == 0) {
                        rows = 1;
                    }
                    if (kscReport.getGraphs().size() % columns > 0) {
                        ++rows;
                    }
                    this.m_gridLayout.setColumns(columns);
                    this.m_gridLayout.setRows(rows);
                    int i = 0;
                    Page.getCurrent().getStyles().add(".box { margin: 5px; background-color: #444; border: 1px solid #999; border-top: 0; overflow: auto; }");
                    Page.getCurrent().getStyles().add(".text { color:#ffffff; line-height: 11px; font-size: 9px; font-family: 'Lucida Grande', Verdana, sans-serif; font-weight: bold; }");
                    Page.getCurrent().getStyles().add(".margin { margin:5px; }");
                    for (int y = 0; y < this.m_gridLayout.getRows(); ++y) {
                        for (int x = 0; x < this.m_gridLayout.getColumns(); ++x) {
                            if (i < kscReport.getGraphs().size()) {
                                Label labelTitle;
                                int index = i;
                                Graph graph = (Graph)kscReport.getGraphs().get(index);
                                Map<String, String> data = KscDashlet.this.getDataForResourceId(graph.getNodeId().orElse(null), graph.getResourceId().orElse(null));
                                Calendar beginTime = Calendar.getInstance();
                                Calendar endTime = Calendar.getInstance();
                                KSC_PerformanceReportFactory.getBeginEndTime((String)graph.getTimespan(), (Calendar)beginTime, (Calendar)endTime);
                                GraphContainer graphContainer = KscDashlet.getGraphContainer(graph, beginTime.getTime(), endTime.getTime());
                                VerticalLayout verticalLayout = new VerticalLayout();
                                HorizontalLayout horizontalLayout = new HorizontalLayout();
                                horizontalLayout.addStyleName("box");
                                horizontalLayout.setWidth("100%");
                                horizontalLayout.setHeight("42px");
                                VerticalLayout leftLayout = new VerticalLayout();
                                leftLayout.setDefaultComponentAlignment(Alignment.TOP_LEFT);
                                leftLayout.addStyleName("margin");
                                if (graph.getTitle() == null || "".equals(graph.getTitle())) {
                                    labelTitle = new Label("&nbsp;");
                                    labelTitle.setContentMode(ContentMode.HTML);
                                } else {
                                    labelTitle = new Label(graph.getTitle());
                                }
                                labelTitle.addStyleName("text");
                                Label labelFrom = new Label("From: " + KscDashlet.this.m_timeformatService.format(beginTime.getTime(), KscDashlet.this.m_userTimezoneId));
                                labelFrom.addStyleName("text");
                                Label labelTo = new Label("To: " + KscDashlet.this.m_timeformatService.format(endTime.getTime(), KscDashlet.this.m_userTimezoneId));
                                labelTo.addStyleName("text");
                                Label labelNodeLabel = new Label(data.get("nodeLabel"));
                                labelNodeLabel.addStyleName("text");
                                Label labelResourceLabel = new Label(data.get("resourceTypeLabel") + ": " + data.get("resourceLabel"));
                                labelResourceLabel.addStyleName("text");
                                leftLayout.addComponent((Component)labelTitle);
                                leftLayout.addComponent((Component)labelFrom);
                                leftLayout.addComponent((Component)labelTo);
                                VerticalLayout rightLayout = new VerticalLayout();
                                rightLayout.setDefaultComponentAlignment(Alignment.TOP_LEFT);
                                rightLayout.addStyleName("margin");
                                rightLayout.addComponent((Component)labelNodeLabel);
                                rightLayout.addComponent((Component)labelResourceLabel);
                                horizontalLayout.addComponent((Component)leftLayout);
                                horizontalLayout.addComponent((Component)rightLayout);
                                horizontalLayout.setExpandRatio((Component)leftLayout, 1.0f);
                                horizontalLayout.setExpandRatio((Component)rightLayout, 1.0f);
                                verticalLayout.addComponent((Component)horizontalLayout);
                                verticalLayout.addComponent((Component)graphContainer);
                                verticalLayout.setWidth(400.0f, Sizeable.Unit.PIXELS);
                                this.m_gridLayout.addComponent((Component)verticalLayout, x, y);
                                verticalLayout.setComponentAlignment((Component)horizontalLayout, Alignment.MIDDLE_CENTER);
                                verticalLayout.setComponentAlignment((Component)graphContainer, Alignment.MIDDLE_CENTER);
                                this.m_gridLayout.setComponentAlignment((Component)verticalLayout, Alignment.MIDDLE_CENTER);
                            }
                            ++i;
                        }
                    }
                }

                public Component getComponent() {
                    return this.m_gridLayout;
                }
            };
        }
        return this.m_wallboardComponent;
    }

    public DashletComponent getDashboardComponent() {
        if (this.m_dashboardComponent == null) {
            this.m_dashboardComponent = new AbstractDashletComponent(){
                private VerticalLayout m_verticalLayout = new VerticalLayout();
                {
                    this.m_verticalLayout.setCaption(KscDashlet.this.getName());
                    this.m_verticalLayout.setSizeFull();
                }

                public void refresh() {
                    this.m_verticalLayout.removeAllComponents();
                    String kscReportName = (String)KscDashlet.this.getDashletSpec().getParameters().get("kscReport");
                    if (kscReportName == null || "".equals(kscReportName)) {
                        return;
                    }
                    KSC_PerformanceReportFactory kscPerformanceReportFactory = KSC_PerformanceReportFactory.getInstance();
                    Map reportsMap = kscPerformanceReportFactory.getReportList();
                    int kscReportId = -1;
                    for (Map.Entry entry : reportsMap.entrySet()) {
                        if (!kscReportName.equals(entry.getValue())) continue;
                        kscReportId = (Integer)entry.getKey();
                        break;
                    }
                    if (kscReportId == -1) {
                        return;
                    }
                    Report kscReport = kscPerformanceReportFactory.getReportByIndex(kscReportId);
                    Page.getCurrent().getStyles().add(".box { margin: 5px; background-color: #444; border: 1px solid #999; border-top: 0; overflow: auto; }");
                    Page.getCurrent().getStyles().add(".text { color:#ffffff; line-height: 11px; font-size: 9px; font-family: 'Lucida Grande', Verdana, sans-serif; font-weight: bold; }");
                    Page.getCurrent().getStyles().add(".margin { margin:5px; }");
                    Accordion accordion = new Accordion();
                    accordion.setSizeFull();
                    this.m_verticalLayout.addComponent((Component)accordion);
                    for (Graph graph : kscReport.getGraphs()) {
                        Label labelTitle;
                        Map<String, String> data = KscDashlet.this.getDataForResourceId(graph.getNodeId().orElse(null), graph.getResourceId().orElse(null));
                        Calendar beginTime = Calendar.getInstance();
                        Calendar endTime = Calendar.getInstance();
                        KSC_PerformanceReportFactory.getBeginEndTime((String)graph.getTimespan(), (Calendar)beginTime, (Calendar)endTime);
                        GraphContainer graphContainer = KscDashlet.getGraphContainer(graph, beginTime.getTime(), endTime.getTime());
                        VerticalLayout verticalLayout = new VerticalLayout();
                        HorizontalLayout horizontalLayout = new HorizontalLayout();
                        horizontalLayout.addStyleName("box");
                        horizontalLayout.setWidth("100%");
                        horizontalLayout.setHeight("42px");
                        VerticalLayout leftLayout = new VerticalLayout();
                        leftLayout.setDefaultComponentAlignment(Alignment.TOP_LEFT);
                        leftLayout.addStyleName("margin");
                        if (graph.getTitle() == null || "".equals(graph.getTitle())) {
                            labelTitle = new Label("&nbsp;");
                            labelTitle.setContentMode(ContentMode.HTML);
                        } else {
                            labelTitle = new Label(graph.getTitle());
                        }
                        labelTitle.addStyleName("text");
                        Label labelFrom = new Label("From: " + KscDashlet.this.m_timeformatService.format(beginTime.getTime(), KscDashlet.this.m_userTimezoneId));
                        labelFrom.addStyleName("text");
                        Label labelTo = new Label("To: " + KscDashlet.this.m_timeformatService.format(endTime.getTime(), KscDashlet.this.m_userTimezoneId));
                        labelTo.addStyleName("text");
                        Label labelNodeLabel = new Label(data.get("nodeLabel"));
                        labelNodeLabel.addStyleName("text");
                        Label labelResourceLabel = new Label(data.get("resourceTypeLabel") + ": " + data.get("resourceLabel"));
                        labelResourceLabel.addStyleName("text");
                        leftLayout.addComponent((Component)labelTitle);
                        leftLayout.addComponent((Component)labelFrom);
                        leftLayout.addComponent((Component)labelTo);
                        VerticalLayout rightLayout = new VerticalLayout();
                        rightLayout.setDefaultComponentAlignment(Alignment.TOP_LEFT);
                        rightLayout.addStyleName("margin");
                        rightLayout.addComponent((Component)labelNodeLabel);
                        rightLayout.addComponent((Component)labelResourceLabel);
                        horizontalLayout.addComponent((Component)leftLayout);
                        horizontalLayout.addComponent((Component)rightLayout);
                        horizontalLayout.setExpandRatio((Component)leftLayout, 1.0f);
                        horizontalLayout.setExpandRatio((Component)rightLayout, 1.0f);
                        verticalLayout.addComponent((Component)horizontalLayout);
                        verticalLayout.addComponent((Component)graphContainer);
                        verticalLayout.setWidth(400.0f, Sizeable.Unit.PIXELS);
                        accordion.addTab((Component)verticalLayout, data.get("nodeLabel") + "/" + data.get("resourceTypeLabel") + ": " + data.get("resourceLabel"));
                        verticalLayout.setComponentAlignment((Component)horizontalLayout, Alignment.MIDDLE_CENTER);
                        verticalLayout.setComponentAlignment((Component)graphContainer, Alignment.MIDDLE_CENTER);
                        verticalLayout.setMargin(true);
                    }
                }

                public Component getComponent() {
                    return this.m_verticalLayout;
                }
            };
        }
        return this.m_dashboardComponent;
    }

    public Map<String, String> getDataForResourceId(final String nodeId, final String resourceIdString) {
        return (Map)this.m_transactionOperations.execute((TransactionCallback)new TransactionCallback<Map<String, String>>(){

            public Map<String, String> doInTransaction(TransactionStatus transactionStatus) {
                OnmsNode node;
                OnmsResource resource;
                HashMap<String, String> data = new HashMap<String, String>();
                ResourceId resourceId = ResourceId.fromString((String)resourceIdString);
                if (nodeId == null) {
                    resource = KscDashlet.this.determineResourceByResourceId(resourceId);
                    node = ResourceTypeUtils.getNodeFromResource((OnmsResource)resource);
                } else {
                    node = KscDashlet.this.m_nodeDao.get(nodeId);
                    resource = KscDashlet.this.m_resourceDao.getResourceForNode(node);
                }
                data.put("nodeId", node.getNodeId());
                data.put("nodeLabel", node.getLabel());
                for (OnmsResource onmsResource : resource.getChildResources()) {
                    if (!resourceId.equals((Object)onmsResource.getId())) continue;
                    data.put("resourceLabel", onmsResource.getLabel());
                    data.put("resourceTypeLabel", onmsResource.getResourceType().getLabel());
                    break;
                }
                return data;
            }
        });
    }

    OnmsResource determineResourceByResourceId(ResourceId resourceId) {
        OnmsResource resource = this.m_resourceDao.getResourceById(resourceId);
        resource = resource.getParent() == null ? resource : resource.getParent();
        return resource;
    }

    private static GraphContainer getGraphContainer(Graph graph, Date start, Date end) {
        GraphContainer graphContainer = new GraphContainer(graph.getGraphtype(), (String)graph.getResourceId().orElse(null));
        graphContainer.setTitle(graph.getTitle());
        graphContainer.setStart(start);
        graphContainer.setEnd(end);
        graphContainer.setWidthRatio(Double.valueOf(1.0));
        return graphContainer;
    }
}

